/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.disasm;

import com.arm.debug.icodec.swig.Architecture;
import com.arm.debug.icodec.swig.DisasslibCallbackBase;
import com.arm.debug.icodec.swig.SWIGTYPE_p_void;
import com.arm.debug.icodec.swig.SWIGicodec;
import com.arm.debug.icodec.swig.TargetArch;

public class Disassembler {
    public int disassembleARM(long address, int instr, DisasslibCallbackBase callback, StringBuilder b, Architecture arch) {
        SWIGTYPE_p_void state = SWIGicodec.disasslibWrapperNew(address);
        SWIGicodec.disasslibWrapperSetCallback(state, callback);
        TargetArch targetArch = new TargetArch(arch);
        SWIGicodec.setArchitecuralDisas(state, targetArch);
        try {
            String disas = SWIGicodec.disasslibWrapperDisassembleARM(state, instr);
            int size = disas.charAt(0) - 48;
            b.append(disas, 1, disas.length());
            int n = size;
            return n;
        }
        finally {
            targetArch.delete();
            SWIGicodec.disasslibWrapperFree(state);
        }
    }

    public int disassembleThumb(long address, short instr1, short instr2, boolean thumb2ee, DisasslibCallbackBase callback, StringBuilder b, Architecture arch) {
        SWIGTYPE_p_void state = SWIGicodec.disasslibWrapperNew(address);
        SWIGicodec.disasslibWrapperSetCallback(state, callback);
        TargetArch targetArch = new TargetArch(arch);
        SWIGicodec.setArchitecuralDisas(state, targetArch);
        try {
            String disas = SWIGicodec.disasslibWrapperDisassembleThumb(state, instr1, instr2, thumb2ee);
            int size = disas.charAt(0) - 48;
            b.append(disas, 1, disas.length());
            int n = size;
            return n;
        }
        finally {
            targetArch.delete();
            SWIGicodec.disasslibWrapperFree(state);
        }
    }

    public int disassembleAArch64(long address, int instr, DisasslibCallbackBase callback, StringBuilder b, Architecture arch) {
        SWIGTYPE_p_void state = SWIGicodec.disasslibWrapperNew(address);
        SWIGicodec.disasslibWrapperSetCallback(state, callback);
        TargetArch targetArch = new TargetArch(arch);
        SWIGicodec.setArchitecuralDisas(state, targetArch);
        try {
            String disas = SWIGicodec.disasslibWrapperDisassembleAArch64(state, instr);
            int size = disas.charAt(0) - 48;
            b.append(disas, 1, disas.length());
            int n = size;
            return n;
        }
        finally {
            targetArch.delete();
            SWIGicodec.disasslibWrapperFree(state);
        }
    }
}

