/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.asm;

import com.arm.debug.icodec.asm.DirectiveOperand;
import java.util.List;

public class AssemblyDirective {
    public final String mnemonic;
    public final IDirective directive;
    public final List<DirectiveOperand> operands;

    public AssemblyDirective(String mnemonic, IDirective directive, List<DirectiveOperand> oplist) {
        this.mnemonic = mnemonic;
        this.directive = directive;
        this.operands = oplist;
    }

    public static IDirective stringToDirective(String directive_name) {
        try {
            return ARCH_DIRECTIVE.valueOf(directive_name.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return DATA_DIRECTIVE.valueOf(directive_name.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    public boolean isValidDataDirective() {
        try {
            DATA_DIRECTIVE.valueOf(this.directive.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public boolean isValidCodeDirective() {
        try {
            ARCH_DIRECTIVE.valueOf(this.directive.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    public static enum ARCH_DIRECTIVE implements IDirective
    {
        ARM,
        THUMB,
        THUMBX,
        CODE32,
        CODE16,
        A64;

    }

    public static enum DATA_DIRECTIVE implements IDirective
    {
        DCB,
        DCD,
        DCDU,
        DCDO,
        DCFD,
        DCFDU,
        DCFS,
        DCFSU,
        DCI,
        DCI_W,
        DCQ,
        DCQU,
        DCW,
        DCWU;

    }

    public static interface IDirective {
    }
}

