/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.asm;

import com.arm.debug.icodec.asm.DirectiveAssembler;
import com.arm.debug.icodec.asm.IAsmSymbolResolver;
import com.arm.debug.icodec.asm.Messages;
import com.arm.debug.icodec.swig.Architecture;
import com.arm.debug.icodec.swig.EncodeError;
import com.arm.debug.icodec.swig.GenericCCEffect;
import com.arm.debug.icodec.swig.GenericInstruction;
import com.arm.debug.icodec.swig.GenericWidth;
import com.arm.debug.icodec.swig.SWIGicodec;
import com.arm.debug.icodec.swig.TargetArch;
import com.arm.text.FormattedException;
import com.arm.text.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Assembler {
    private static final Pattern PC_REL_PATTERN = Pattern.compile("\\s*\\{\\s*([A-Za-z_][A-Za-z_0-9]*)\\s*\\}");
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$arm$debug$icodec$swig$GenericWidth;

    public List<AsmInfo> assembleSource(long address, List<String> mnemonics, TargetArch ta, IAsmSymbolResolver resolver) throws FormattedException {
        ArrayList<AsmInfo> assembled = new ArrayList<AsmInfo>();
        DirectiveAssembler dAssembler = new DirectiveAssembler();
        for (String mnemonic : mnemonics) {
            List<AsmInfo> asmDetList = dAssembler.assembleDirective(address, ta, mnemonic);
            if (asmDetList == null) {
                try {
                    AsmInfo asmDet = this.assemble(address, mnemonic, ta, resolver);
                    assembled.add(asmDet);
                    address += (long)asmDet.size;
                    continue;
                }
                catch (FormattedException de) {
                    throw new FormattedException(Messages.FAILED_TO_ASSEMBLE.format(mnemonic), (Throwable)de);
                }
            }
            if (asmDetList.isEmpty()) continue;
            assembled.addAll(asmDetList);
            AsmInfo asmInfo = asmDetList.get(asmDetList.size() - 1);
            address = asmInfo.address + (long)asmInfo.size;
        }
        return assembled;
    }

    public AsmInfo assembleARM(long address, String mnemonic, Architecture.CoreVersion core, Architecture.VFPNEONVersion vfpNeon, IAsmSymbolResolver resolver) throws FormattedException {
        Architecture arch = new Architecture(core, vfpNeon);
        try {
            Throwable throwable = null;
            Object var9_9 = null;
            TargetArch ta = new TargetArch(arch);
            try {
                if (!arch.archHasARM()) {
                    throw new FormattedException((IMessage)Messages.CONFIG_NEED_ARM_A1630E);
                }
                AsmInfo asmInfo = this.assemble(address, mnemonic, ta, resolver);
                if (ta != null) {
                    ta.close();
                }
                return asmInfo;
            }
            catch (Throwable throwable2) {
                try {
                    if (ta != null) {
                        ta.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            arch.delete();
        }
    }

    public AsmInfo assembleThumb(long address, String mnemonic, Architecture.CoreVersion core, Architecture.VFPNEONVersion vfpNeon, IAsmSymbolResolver resolver) throws FormattedException {
        Architecture arch = new Architecture(core, vfpNeon);
        try {
            Throwable throwable = null;
            Object var9_9 = null;
            TargetArch ta = new TargetArch(arch);
            try {
                if (!arch.archHasThumb()) {
                    throw new FormattedException((IMessage)Messages.CONFIG_NEED_THUMB_A1461E);
                }
                ta.select(TargetArch.FeatureStateSelection.feature_Thumb);
                AsmInfo asmInfo = this.assemble(address, mnemonic, ta, resolver);
                if (ta != null) {
                    ta.close();
                }
                return asmInfo;
            }
            catch (Throwable throwable2) {
                try {
                    if (ta != null) {
                        ta.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            arch.delete();
        }
    }

    public AsmInfo assembleA64(long address, String mnemonic, Architecture.CoreVersion core, Architecture.VFPNEONVersion vfpNeon, IAsmSymbolResolver resolver) throws FormattedException {
        Architecture arch = new Architecture(core, vfpNeon);
        try {
            Throwable throwable = null;
            Object var9_9 = null;
            TargetArch ta = new TargetArch(arch);
            try {
                if (!arch.archHasA64()) {
                    throw new FormattedException((IMessage)Messages.CONFIG_NEED_ARM_A1630E);
                }
                ta.select(TargetArch.FeatureStateSelection.feature_A64);
                AsmInfo asmInfo = this.assemble(address, mnemonic, ta, resolver);
                if (ta != null) {
                    ta.close();
                }
                return asmInfo;
            }
            catch (Throwable throwable2) {
                try {
                    if (ta != null) {
                        ta.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            arch.delete();
        }
    }

    /*
     * Exception decompiling
     */
    public AsmInfo assemble(long address, String mnemonic, TargetArch ta, IAsmSymbolResolver resolver) throws FormattedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 14[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ReportIcodecError(GenericInstruction gi, EncodeError err) throws FormattedException {
        switch (err) {
            case iee_cannotdoshift: {
                throw new FormattedException((IMessage)Messages.ERRORS_SHIFT_NOT_ALLOWED_A1856E);
            }
            case iee_cannotdoflags: {
                if (gi.cc() == GenericCCEffect.gicc_keep) {
                    throw new FormattedException((IMessage)Messages.ERRORS_FLAG_PRESERVING_FORM_NOT_ALLOWED_A1859E);
                }
                throw new FormattedException((IMessage)Messages.ERRORS_FLAG_SETTING_FORM_NOT_ALLOWED_A1858E);
            }
            case iee_cannotdoconditional: {
                throw new FormattedException((IMessage)Messages.ERRORS_CONDITIONAL_NOT_ALLOWED_A1694E);
            }
            case iee_shiftnotmultipleofeight: {
                throw new FormattedException((IMessage)Messages.ERRORS_SHIFT_OPT_RANGE_081624_A1501E);
            }
            case iee_cannotdowidth: {
                throw new FormattedException((IMessage)Messages.ERRORS_WIDTH_NOT_SUPPORTED_ON_THIS_TARGET_A1617E);
            }
            case iee_notlowreg: {
                throw new FormattedException((IMessage)Messages.ERRORS_MUST_BE_LOW_REGS_A1860E);
            }
            case iee_rdnotlowreg: {
                throw new FormattedException(Messages.ERRORS_REG_MUST_LOW_REG_A1875E.format("Rd"));
            }
            case iee_rnnotlowreg: {
                throw new FormattedException(Messages.ERRORS_REG_MUST_LOW_REG_A1875E.format("Rn"));
            }
            case iee_rtnotlowreg: {
                throw new FormattedException(Messages.ERRORS_REG_MUST_LOW_REG_A1875E.format("Rt"));
            }
            case iee_cannotdoshifttype: {
                throw new FormattedException((IMessage)Messages.ERRORS_SHIFT_TYPE_NOT_ALLOWED_A1857E);
            }
            case iee_cannotdotransfersize: {
                throw new FormattedException((IMessage)Messages.ERRORS_LOAD_STORE_TRANSFER_SIZE_A1880E);
            }
            case iee_rdnotpc: {
                throw new FormattedException((IMessage)Messages.ERRORS_GROUP_CONDITIONAL_DEST_NOT_PC_A1651E);
            }
            case iee_cannotusexscalectrlreginshift: {
                throw new FormattedException((IMessage)Messages.ERRORS_SHIFT_REG_NOT_GENERAL_A1653E);
            }
            case iee_cannotdoxscalectrlreg: {
                throw new FormattedException((IMessage)Messages.ERRORS_CONTROL_REGISTER_UNDEFINED_A1866E);
            }
            case iee_cannotdoloadstoremode: {
                throw new FormattedException((IMessage)Messages.ERRORS_LOAD_STORE_ADDRESSING_MODE_A1879E);
            }
            case iee_bitfieldlsbnot5bits: {
                throw new FormattedException(Messages.ERRORS_BITFIELD_LSB_RANGE_A1868E.format(31));
            }
            case iee_bitfieldmsbnot5bits: {
                throw new FormattedException(Messages.ERRORS_BITFIELD_WIDTH_RANGE_A1897E.format(32));
            }
            case iee_rnmustnotpc: {
                throw new FormattedException(Messages.ERRORS_REG_MUST_NOT_PC_A1869E.format("Rn"));
            }
            case iee_rtmustnotpc: {
                throw new FormattedException(Messages.ERRORS_REG_MUST_NOT_PC_A1869E.format("Rt"));
            }
            case iee_ramustnotpc: {
                throw new FormattedException(Messages.ERRORS_REG_MUST_NOT_PC_A1869E.format("Ra"));
            }
            case iee_notarmdpimm: {
                throw new FormattedException(Messages.ERRORS_BAD_IMMEDIATE_ROT_A1510E.format(gi.immediate()));
            }
            case iee_preferredrotatenot5bitsmultiple2: {
                throw new FormattedException(Messages.ERRORS_BAD_ROT_A1172E.format(gi.theARMPreferredRotation()));
            }
            case iee_notthumbdpimm: {
                throw new FormattedException(Messages.ERRORS_BAD_IMMEDIATE_THUMB2_A1871E.format(gi.immediate()));
            }
            case iee_cannotdoshiftbyreg: {
                throw new FormattedException((IMessage)Messages.ERRORS_REG_SHIFT_NOT_ALLOWED_A1872E);
            }
            case iee_rdrmnotsame: {
                throw new FormattedException((IMessage)Messages.ERRORS_RD_RM_NOT_SAME_A1883E);
            }
            case iee_rdrnnotsame: {
                throw new FormattedException((IMessage)Messages.ERRORS_RD_RN_NOT_SAME_A1882E);
            }
            case iee_cannotdoreglist: {
                throw new FormattedException((IMessage)Messages.ERRORS_REG_LIST_NOT_AVAILABLE_A1874E);
            }
            case iee_cannotdowriteback: {
                throw new FormattedException((IMessage)Messages.ERRORS_WRITEBACK_NOT_ALLOWED_A1873E);
            }
            case iee_cannotdonowriteback: {
                throw new FormattedException((IMessage)Messages.ERRORS_WRITEBACK_MISSING_A1433E);
            }
            case iee_cannotdoloadstoremultiplemode: {
                throw new FormattedException(Messages.ERRORS_PL_ADDR_MODE_DISALLOWED_A1612E.format(new Object[]{gi.loadStoreMultipleMode(), gi.minorOpcode()}));
            }
            case iee_cannotdoloadstoremultiplespecial: {
                throw new FormattedException((IMessage)Messages.ERRORS_NO_USER_MODE_LDM_A1641E);
            }
            case iee_cannotdoloadstorespecial: {
                throw new FormattedException((IMessage)Messages.ERRORS_LOAD_STORE_SPECIAL_A1881E);
            }
            case iee_cannotdorm: {
                throw new FormattedException(Messages.ERRORS_REG_NOT_ALLOWED_A1877E.format("Rm"));
            }
            case iee_cannotdorn: {
                throw new FormattedException(Messages.ERRORS_REG_NOT_ALLOWED_A1877E.format("Rn"));
            }
            case iee_cannotdovd: {
                throw new FormattedException(Messages.ERRORS_REG_NOT_ALLOWED_A1877E.format("Vd"));
            }
            case iee_cannotdovn: {
                throw new FormattedException(Messages.ERRORS_REG_NOT_ALLOWED_A1877E.format("Vn"));
            }
            case iee_cannotdovm: {
                throw new FormattedException(Messages.ERRORS_REG_NOT_ALLOWED_A1877E.format("Vm"));
            }
            case iee_cannotdocpsaifmask: {
                throw new FormattedException((IMessage)Messages.ERRORS_CPS_AIF_MASK_NOT_ALLOWED_A1884E);
            }
            case iee_cannotdocpsprocmode: {
                throw new FormattedException((IMessage)Messages.ERRORS_PROC_MODE_NOT_ALLOWED_A1885E);
            }
            case iee_notwmmxsizehw: {
                throw new FormattedException((IMessage)Messages.ERRORS_WMMXINVALID_OPERAND_SIZE_FOR_CARRY_IN_A1886E);
            }
            case iee_cannotdoregsort: {
                throw new FormattedException((IMessage)Messages.ERRORS_REGISTER_TYPE_NOT_ALLOWED_A1889E);
            }
            case iee_cannotdocompressedconst: {
                throw new FormattedException((IMessage)Messages.ERRORS_BAD_IMMEDIATE_NEON_A1601E);
            }
            case iee_cannotdovtblength: {
                throw new FormattedException((IMessage)Messages.ERRORS_BAD_LENGTH_OR_STEP_FOR_VLD1_A1732E);
            }
            case iee_cannotdoregcount: {
                throw new FormattedException((IMessage)Messages.ERRORS_VLD_REGLIST_LEN_A1598E);
            }
            case iee_cannotdoregspacing: {
                throw new FormattedException((IMessage)Messages.ERRORS_VLD_REGLIST_INCREMENT_A1611E);
            }
            case iee_cannotdoalign: {
                throw new FormattedException((IMessage)Messages.ERRORS_NEON_ALIGN_NOT_VALID_A1896E);
            }
            case iee_rdmustnotpcwhens: {
                throw new FormattedException(Messages.ERRORS_REG_MUST_NOT_PCWHEN_S_A1912E.format("Rs"));
            }
            case iee_copronot1415: {
                throw new FormattedException((IMessage)Messages.ERRORS_COPRO_NOT1415_A1925E);
            }
            case iee_cannotdortrt2: {
                throw new FormattedException((IMessage)Messages.ERRORS_REGPAIR_NOT_CONTIGUOUS_A1499E);
            }
        }
        if (SWIGicodec.encodeFailedMiscImmediate(err)) {
            throw new FormattedException((IMessage)Messages.GENERIC_IMM_ERROR_NC);
        }
        if (SWIGicodec.encodeFailedMiscDt(err)) {
            throw new FormattedException((IMessage)Messages.GENERIC_REGISTER_ERROR_NC);
        }
        throw new FormattedException(Messages.GENERIC_UNHANDLED_ERROR_NC.format("Could not assemble"));
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$arm$debug$icodec$swig$GenericWidth() {
        if ($SWITCH_TABLE$com$arm$debug$icodec$swig$GenericWidth != null) {
            return $SWITCH_TABLE$com$arm$debug$icodec$swig$GenericWidth;
        }
        int[] nArray = new int[GenericWidth.values().length];
        try {
            nArray[GenericWidth.giw_N.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GenericWidth.giw_W.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GenericWidth.giw_any.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$arm$debug$icodec$swig$GenericWidth = nArray;
        return nArray;
    }

    public static final class AsmInfo {
        public final String mnemonic;
        public final boolean isdatadirective;
        public final int size;
        public final int alignto;
        public final int opcode;
        public final long address;

        public AsmInfo(String mnemonic, int size, int opcode, long address, int alignto, boolean isdatadir) {
            this.mnemonic = mnemonic;
            this.size = size;
            this.opcode = opcode;
            this.address = address;
            this.alignto = alignto;
            this.isdatadirective = isdatadir;
        }
    }
}

