/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec;

import com.arm.debug.icodec.swig.GenericBranchImmOperation;
import com.arm.debug.icodec.swig.GenericBranchRegOperation;
import com.arm.debug.icodec.swig.GenericBranchTableOperation;
import com.arm.debug.icodec.swig.GenericCompareBranchOperation;
import com.arm.debug.icodec.swig.GenericConditionalExecution;
import com.arm.debug.icodec.swig.GenericDpImmOperation;
import com.arm.debug.icodec.swig.GenericDpRegOperation;
import com.arm.debug.icodec.swig.GenericHandlerBranchOperation;
import com.arm.debug.icodec.swig.GenericInstruction;
import com.arm.debug.icodec.swig.GenericInstructionMajorOpcode;
import com.arm.debug.icodec.swig.GenericLoadStoreExOperation;
import com.arm.debug.icodec.swig.GenericLoadStoreImmOperation;
import com.arm.debug.icodec.swig.GenericLoadStoreMultipleOperation;
import com.arm.debug.icodec.swig.GenericLoadStoreRegOperation;
import com.arm.debug.icodec.swig.GenericMoveImmOperation;
import com.arm.debug.icodec.swig.GenericMoveRegOperation;
import com.arm.debug.icodec.swig.GenericRegisterModel;
import com.arm.debug.icodec.swig.GenericRegisterSpecial;
import com.arm.debug.icodec.swig.GenericRfeOperation;
import com.arm.debug.icodec.swig.GenericTestAndBranchOperation;
import com.arm.debug.icodec.swig.GenericTrapOperation;
import com.arm.debug.icodec.swig.GenericWidth;
import com.arm.debug.icodec.swig.SWIGicodec;

public class Instruction
implements AutoCloseable {
    private final GenericInstruction instruction;
    private final GenericRegisterModel registerModel;
    private final int opcode;
    public final long pcNumber;
    public final long lrNumber;
    private final long spNumber;
    private static final long PC_NUM = 4L;

    public Instruction(GenericInstruction instruction, GenericRegisterModel registerModel, int opcode) {
        if (instruction == null || registerModel == null) {
            throw new NullPointerException("instruction can't be null");
        }
        this.opcode = opcode;
        this.instruction = instruction;
        this.registerModel = registerModel;
        this.pcNumber = SWIGicodec.genericRegisterForSpecial(registerModel, GenericRegisterSpecial.grs_PC);
        this.lrNumber = SWIGicodec.genericRegisterForSpecial(registerModel, GenericRegisterSpecial.grs_LR);
        this.spNumber = SWIGicodec.genericRegisterForSpecial(registerModel, GenericRegisterSpecial.grs_SP);
    }

    @Override
    public void close() {
        this.instruction.close();
    }

    public int getSize() {
        int instructions = this.instruction.isTwoInstructions() ? 2 : 1;
        return instructions * (this.instruction.width() == GenericWidth.giw_N ? 2 : 4);
    }

    public boolean mightChangeInstructionSet() {
        return this.instruction.isStateChange();
    }

    public boolean isBranchOrCall() {
        Enum minorOpcode;
        GenericInstructionMajorOpcode majorOpcode = this.instruction.majorOpcode();
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_branch_imm) {
            try {
                minorOpcode = GenericBranchImmOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericBranchImmOperation.giop_bl) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_branch_reg) {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            try {
                                minorOpcode = GenericBranchRegOperation.swigToEnum(this.instruction.minorOpcode());
                                if (minorOpcode != GenericBranchRegOperation.giop_bx) break block12;
                                return true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        if (minorOpcode != GenericBranchRegOperation.giop_blr) break block13;
                        return true;
                    }
                    if (minorOpcode != GenericBranchRegOperation.giop_blx_reg) break block14;
                    return true;
                }
                if (minorOpcode != GenericBranchRegOperation.giop_bxns) break block15;
                return true;
            }
            if (minorOpcode == GenericBranchRegOperation.giop_blxns_reg) {
                return true;
            }
        }
        return false;
    }

    public boolean isA64_BC() {
        return this.registerModel == GenericRegisterModel.grm_aarch64 && (this.opcode & 0xFF000010) == 1409286160;
    }

    private static final int signedField(int src, int offset, int width) {
        int num_leading_bits = 32 - width - offset;
        return src << num_leading_bits >> offset + num_leading_bits;
    }

    public long signedImmediate() {
        if (this.isA64_BC()) {
            int imm19 = Instruction.signedField(this.opcode, 5, 19);
            return imm19 * 4;
        }
        return this.instruction.signedImmediate();
    }

    public boolean isBranch() {
        Enum minorOpcode;
        if (this.isA64_BC()) {
            return true;
        }
        GenericInstructionMajorOpcode majorOpcode = this.instruction.majorOpcode();
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_branch_imm) {
            try {
                minorOpcode = GenericBranchImmOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericBranchImmOperation.giop_b) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_handler_branch) {
            block90: {
                try {
                    minorOpcode = GenericHandlerBranchOperation.swigToEnum(this.instruction.minorOpcode());
                    if (minorOpcode != GenericHandlerBranchOperation.giop_hb) break block90;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (minorOpcode == GenericHandlerBranchOperation.giop_hbp) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_branch_reg) {
            block92: {
                block91: {
                    try {
                        minorOpcode = GenericBranchRegOperation.swigToEnum(this.instruction.minorOpcode());
                        if (minorOpcode != GenericBranchRegOperation.giop_bxj) break block91;
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (minorOpcode != GenericBranchRegOperation.giop_ret) break block92;
                return true;
            }
            if (minorOpcode == GenericBranchRegOperation.giop_br) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_compare_branch) {
            try {
                minorOpcode = GenericCompareBranchOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericCompareBranchOperation.giop_cb) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_test_and_branch) {
            block93: {
                try {
                    minorOpcode = GenericTestAndBranchOperation.swigToEnum(this.instruction.minorOpcode());
                    if (minorOpcode != GenericTestAndBranchOperation.giop_tbz) break block93;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (minorOpcode == GenericTestAndBranchOperation.giop_tbnz) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_rfe) {
            try {
                minorOpcode = GenericRfeOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericRfeOperation.giop_rfe) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_branch_table) {
            block94: {
                try {
                    minorOpcode = GenericBranchTableOperation.swigToEnum(this.instruction.minorOpcode());
                    if (minorOpcode != GenericBranchTableOperation.giop_tbb) break block94;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (minorOpcode == GenericBranchTableOperation.giop_tbh) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_ldrstr_imm) {
            try {
                minorOpcode = GenericLoadStoreImmOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericLoadStoreImmOperation.giop_ldr_imm && this.isRtPC()) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_ldrstr_reg) {
            try {
                minorOpcode = GenericLoadStoreRegOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericLoadStoreRegOperation.giop_ldr_reg && this.isRtPC()) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_ldrstrex) {
            try {
                minorOpcode = GenericLoadStoreExOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericLoadStoreExOperation.giop_ldrex && this.isRtPC()) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_ldmstm) {
            try {
                minorOpcode = GenericLoadStoreMultipleOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericLoadStoreMultipleOperation.giop_ldm) {
                    int r15PositionMask = 32768;
                    long registerList = this.instruction.immediate();
                    if ((registerList & (long)r15PositionMask) != 0L) {
                        return true;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_dp_imm) {
            block104: {
                block103: {
                    block102: {
                        block101: {
                            block100: {
                                block99: {
                                    block98: {
                                        block97: {
                                            block96: {
                                                block95: {
                                                    try {
                                                        minorOpcode = GenericDpImmOperation.swigToEnum(this.instruction.minorOpcode());
                                                        if (minorOpcode != GenericDpImmOperation.giop_and_imm || !this.isRdPC()) break block95;
                                                        return true;
                                                    }
                                                    catch (IllegalArgumentException illegalArgumentException) {}
                                                }
                                                if (minorOpcode != GenericDpImmOperation.giop_eor_imm || !this.isRdPC()) break block96;
                                                return true;
                                            }
                                            if (minorOpcode != GenericDpImmOperation.giop_sub_imm || !this.isRdPC()) break block97;
                                            return true;
                                        }
                                        if (minorOpcode != GenericDpImmOperation.giop_rsb_imm || !this.isRdPC()) break block98;
                                        return true;
                                    }
                                    if (minorOpcode != GenericDpImmOperation.giop_add_imm || !this.isRdPC()) break block99;
                                    return true;
                                }
                                if (minorOpcode != GenericDpImmOperation.giop_adc_imm || !this.isRdPC()) break block100;
                                return true;
                            }
                            if (minorOpcode != GenericDpImmOperation.giop_sbc_imm || !this.isRdPC()) break block101;
                            return true;
                        }
                        if (minorOpcode != GenericDpImmOperation.giop_rsc_imm || !this.isRdPC()) break block102;
                        return true;
                    }
                    if (minorOpcode != GenericDpImmOperation.giop_orr_imm || !this.isRdPC()) break block103;
                    return true;
                }
                if (minorOpcode != GenericDpImmOperation.giop_bic_imm || !this.isRdPC()) break block104;
                return true;
            }
            if (minorOpcode == GenericDpImmOperation.giop_orn_imm && this.isRdPC()) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_dp_reg) {
            block114: {
                block113: {
                    block112: {
                        block111: {
                            block110: {
                                block109: {
                                    block108: {
                                        block107: {
                                            block106: {
                                                block105: {
                                                    try {
                                                        minorOpcode = GenericDpRegOperation.swigToEnum(this.instruction.minorOpcode());
                                                        if (minorOpcode != GenericDpRegOperation.giop_and_reg || !this.isRdPC()) break block105;
                                                        return true;
                                                    }
                                                    catch (IllegalArgumentException illegalArgumentException) {}
                                                }
                                                if (minorOpcode != GenericDpRegOperation.giop_eor_reg || !this.isRdPC()) break block106;
                                                return true;
                                            }
                                            if (minorOpcode != GenericDpRegOperation.giop_sub_reg || !this.isRdPC()) break block107;
                                            return true;
                                        }
                                        if (minorOpcode != GenericDpRegOperation.giop_rsb_reg || !this.isRdPC()) break block108;
                                        return true;
                                    }
                                    if (minorOpcode != GenericDpRegOperation.giop_add_reg || !this.isRdPC()) break block109;
                                    return true;
                                }
                                if (minorOpcode != GenericDpRegOperation.giop_adc_reg || !this.isRdPC()) break block110;
                                return true;
                            }
                            if (minorOpcode != GenericDpRegOperation.giop_sbc_reg || !this.isRdPC()) break block111;
                            return true;
                        }
                        if (minorOpcode != GenericDpRegOperation.giop_rsc_reg || !this.isRdPC()) break block112;
                        return true;
                    }
                    if (minorOpcode != GenericDpRegOperation.giop_orr_reg || !this.isRdPC()) break block113;
                    return true;
                }
                if (minorOpcode != GenericDpRegOperation.giop_bic_reg || !this.isRdPC()) break block114;
                return true;
            }
            if (minorOpcode == GenericDpRegOperation.giop_orn_reg && this.isRdPC()) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_move_imm) {
            block116: {
                block115: {
                    try {
                        minorOpcode = GenericMoveImmOperation.swigToEnum(this.instruction.minorOpcode());
                        if (minorOpcode != GenericMoveImmOperation.giop_mvn_imm || !this.isRdPC()) break block115;
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (minorOpcode != GenericMoveImmOperation.giop_mov_imm || !this.isRdPC()) break block116;
                return true;
            }
            if (minorOpcode == GenericMoveImmOperation.giop_movt && this.isRdPC()) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_move_reg) {
            block117: {
                try {
                    minorOpcode = GenericMoveRegOperation.swigToEnum(this.instruction.minorOpcode());
                    if (minorOpcode != GenericMoveRegOperation.giop_mvn_reg || !this.isRdPC()) break block117;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (minorOpcode == GenericMoveRegOperation.giop_mov_reg && this.isRdPC()) {
                return true;
            }
        }
        return majorOpcode == GenericInstructionMajorOpcode.gimop_eret;
    }

    public boolean isCall() {
        Enum minorOpcode;
        GenericInstructionMajorOpcode majorOpcode = this.instruction.majorOpcode();
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_branch_imm) {
            try {
                minorOpcode = GenericBranchImmOperation.swigToEnum(this.instruction.minorOpcode());
                if (minorOpcode == GenericBranchImmOperation.giop_blx_imm) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_branch_reg) {
            block20: {
                try {
                    minorOpcode = GenericBranchRegOperation.swigToEnum(this.instruction.minorOpcode());
                    if (minorOpcode != GenericBranchRegOperation.giop_blx_reg) break block20;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (minorOpcode == GenericBranchRegOperation.giop_blxns_reg) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_handler_branch) {
            block21: {
                try {
                    minorOpcode = GenericHandlerBranchOperation.swigToEnum(this.instruction.minorOpcode());
                    if (minorOpcode != GenericHandlerBranchOperation.giop_hbl) break block21;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (minorOpcode == GenericHandlerBranchOperation.giop_hblp) {
                return true;
            }
        }
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_trap) {
            block23: {
                block22: {
                    try {
                        minorOpcode = GenericTrapOperation.swigToEnum(this.instruction.minorOpcode());
                        if (minorOpcode != GenericTrapOperation.giop_svc) break block22;
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (minorOpcode != GenericTrapOperation.giop_smc) break block23;
                return true;
            }
            if (minorOpcode == GenericTrapOperation.giop_hvc) {
                return true;
            }
        }
        return false;
    }

    public boolean isConditional() {
        if (this.isA64_BC()) {
            return true;
        }
        GenericInstructionMajorOpcode majorOpcode = this.instruction.majorOpcode();
        if (majorOpcode == GenericInstructionMajorOpcode.gimop_compare_branch || majorOpcode == GenericInstructionMajorOpcode.gimop_test_and_branch) {
            return true;
        }
        return this.instruction.condex() != GenericConditionalExecution.gice_al;
    }

    public boolean isBX() {
        GenericBranchRegOperation minorOpcode;
        GenericInstructionMajorOpcode majorOpcode = this.instruction.majorOpcode();
        return majorOpcode == GenericInstructionMajorOpcode.gimop_branch_reg && ((minorOpcode = GenericBranchRegOperation.swigToEnum(this.instruction.minorOpcode())) == GenericBranchRegOperation.giop_bx || minorOpcode == GenericBranchRegOperation.giop_bxns);
    }

    public boolean isBXusingLR() {
        GenericBranchRegOperation minorOpcode;
        GenericInstructionMajorOpcode majorOpcode = this.instruction.majorOpcode();
        return majorOpcode == GenericInstructionMajorOpcode.gimop_branch_reg && ((minorOpcode = GenericBranchRegOperation.swigToEnum(this.instruction.minorOpcode())) == GenericBranchRegOperation.giop_bx || minorOpcode == GenericBranchRegOperation.giop_bxns) && this.instruction.rm() == this.lrNumber;
    }

    public boolean isMOVfromPCtoR() {
        GenericMoveRegOperation minorOpcode;
        GenericInstructionMajorOpcode majorOpcode = this.instruction.majorOpcode();
        return majorOpcode == GenericInstructionMajorOpcode.gimop_move_reg && (minorOpcode = GenericMoveRegOperation.swigToEnum(this.instruction.minorOpcode())) == GenericMoveRegOperation.giop_mov_reg && this.instruction.rm() == this.pcNumber && this.instruction.rd() == this.lrNumber;
    }

    private boolean isRtPC() {
        return this.instruction.rt() == this.pcNumber;
    }

    private boolean isRdPC() {
        return this.instruction.rd() == this.pcNumber;
    }

    public long getCoreRegistersUsed() {
        long registers = this.instruction.coreRegisterReads(this.registerModel) | this.instruction.coreRegisterWrites(this.registerModel);
        return registers;
    }

    public long getSpecialRegistersUsed() {
        if (this.isA64_BC()) {
            return 4L;
        }
        return this.instruction.specialRegisterReads(this.registerModel) | this.instruction.specialRegisterWrites(this.registerModel);
    }

    public GenericInstruction getInstruction() {
        return this.instruction;
    }
}

