/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.ssh;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.ITerminalConnection;
import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.AsyncInputStreamLineReaderAndLogger;
import com.arm.streamline.deviceconn.lib.EscapeUtils;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.streamline.deviceconn.lib.LineBuffer;
import com.arm.streamline.deviceconn.lib.LogDirectory;
import com.arm.streamline.deviceconn.ssh.IBasicSshDeviceConnection;
import com.arm.streamline.deviceconn.ssh.SshDeviceConfiguration;
import com.arm.streamline.deviceconn.ssh.jsch.IChannelExec;
import com.arm.streamline.deviceconn.ssh.jsch.IChannelSftp;
import com.arm.streamline.deviceconn.ssh.jsch.IJSch;
import com.arm.streamline.deviceconn.ssh.jsch.ISession;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.Throwing;
import com.arm.utils.io.FileUtils;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class BasicSshDeviceConnection
implements IBasicSshDeviceConnection {
    private final @NonNull LogDirectory logDirectory;
    private final @NonNull ISession session;

    public static boolean test(@NonNull SshDeviceConfiguration configuration) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BasicSshDeviceConnection connection = new BasicSshDeviceConnection(configuration, null, (TIntIntMap)new TIntIntHashMap());){
                String string = connection.getUserHome();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public BasicSshDeviceConnection(@NonNull SshDeviceConfiguration configuration, @Nullable File logDirectory, @NonNull TIntIntMap portsToForward) throws JSchException {
        this(configuration.create(IJSch.wrap(new JSch())), logDirectory, portsToForward);
    }

    BasicSshDeviceConnection(@NonNull ISession session, @Nullable File logDirectory, @NonNull TIntIntMap portsToForward) throws JSchException {
        this.logDirectory = new LogDirectory(logDirectory);
        this.session = session;
        session.connect(60000);
        TIntIntIterator it = portsToForward.iterator();
        while (it.hasNext()) {
            it.advance();
            int remote = it.key();
            int local = it.value();
            session.setPortForwardingL(local, "localhost", remote);
        }
    }

    @Override
    public void close() throws Exception {
        this.session.disconnect();
    }

    @Override
    public @NonNull String getUserHome() throws IOException {
        IChannelSftp sftp = this.session.openSftpChannel();
        if (sftp == null) {
            throw new IOException("Could not open SSH sftp channel");
        }
        try {
            sftp.connect();
            String string = (String)NullChecking.neverNull((Object)sftp.getHome());
            sftp.disconnect();
            return string;
        }
        catch (Throwable throwable) {
            try {
                sftp.disconnect();
                throw throwable;
            }
            catch (JSchException | SftpException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.session.isConnected();
    }

    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull IBasicSshDeviceConnection.WrapMode wrapMode, @NonNull String command, String ... arguments) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (@NonNull InteractiveCommand interactiveCommand = this.runInteractiveCommand(wrapMode, command, arguments);){
            @NonNull List<@NonNull String> lines = interactiveCommand.collectAllRemainingOutputAndWaitForExit();
            @Nullable List<@NonNull String> errorLines = interactiveCommand.getErrorLines();
            return new IBasicInteractiveShell.InteractiveCommandResult((IBasicInteractiveShell.CommandStatus)NullChecking.neverNull((Object)interactiveCommand.getExitCode()), lines, errorLines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull InteractiveCommand runInteractiveCommand(@NonNull IBasicSshDeviceConnection.WrapMode wrapMode, @NonNull String command, String ... arguments) throws IOException {
        StringBuilder commandString = new StringBuilder();
        commandString.append(EscapeUtils.escapeArg(command));
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            commandString.append(' ').append(EscapeUtils.escapeArg(argument));
            ++n2;
        }
        @Nullable Pair<@NonNull File, @NonNull File> logFiles = this.logDirectory.get(command, arguments);
        File stdOutLog = logFiles != null ? (File)logFiles.first : null;
        File stdErrLog = logFiles != null ? (File)logFiles.second : null;
        try {
            IChannelExec execChannel = this.session.openExecChannel();
            if (execChannel == null) {
                throw new IOException("Could not open SSH exec channel");
            }
            execChannel.setCommand(commandString.toString());
            if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_COMMAND_TO_SCREEN) {
                System.out.printf("%n%n[CMD]: %s%n%n", commandString);
            }
            return new InteractiveCommand(execChannel, stdOutLog, stdErrLog);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    @Override
    public @NonNull File scpPull(boolean recursive, @NonNull File localFile, @NonNull String remotePath) throws IOException {
        IChannelSftp sftp = this.session.openSftpChannel();
        if (sftp == null) {
            throw new IOException("Could not open SSH sftp channel");
        }
        sftp.connect();
        try {
            File file = sftp.get(recursive, remotePath, FileUtils.canonicalisePath((File)localFile), new ProgressMonitor(), 0);
            sftp.disconnect();
            return file;
        }
        catch (Throwable throwable) {
            try {
                sftp.disconnect();
                throw throwable;
            }
            catch (JSchException | SftpException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public @NonNull String scpPush(@NonNull File localFile, @NonNull String remotePath) throws IOException {
        IChannelSftp sftp = this.session.openSftpChannel();
        if (sftp == null) {
            throw new IOException("Could not open SSH sftp channel");
        }
        sftp.connect();
        try {
            sftp.put(FileUtils.canonicalisePath((File)localFile), remotePath, new ProgressMonitor(), 0);
            String string = (String)NullChecking.neverNull((Object)sftp.realpath(remotePath));
            sftp.disconnect();
            return string;
        }
        catch (Throwable throwable) {
            try {
                sftp.disconnect();
                throw throwable;
            }
            catch (JSchException | SftpException e) {
                throw new IOException(e);
            }
        }
    }

    private static final class InteractiveCommand
    implements IProcessInteractiveCommand {
        private final @NonNull IChannelExec execChannel;
        private final @NonNull StringBuilder logOut = new StringBuilder();
        private final @NonNull AbstractAsyncByteReaderLineReaderAndLogger processStdErr;
        private final @NonNull OutputStream processStdIn;
        private final @NonNull AbstractAsyncByteReaderLineReaderAndLogger processStdOut;
        private final @NonNull LineBuffer stdErrBuffer = new LineBuffer();
        private final @NonNull LineBuffer stdOutBuffer = new LineBuffer();

        private static @NonNull IBasicInteractiveShell.CommandStatus decodeExitStatus(int exitStatus) {
            if ((exitStatus & 0xFF) == exitStatus) {
                return IBasicInteractiveShell.CommandStatus.exited((byte)exitStatus);
            }
            return IBasicInteractiveShell.CommandStatus.unknown("ssh session out of range exit code: " + exitStatus);
        }

        public InteractiveCommand(@NonNull IChannelExec execChannel, @Nullable File stdOutLog, @Nullable File stdErrLog) throws IOException, JSchException {
            this.execChannel = execChannel;
            this.processStdIn = (OutputStream)NullChecking.neverNull((Object)execChannel.getOutputStream());
            this.processStdOut = new AsyncInputStreamLineReaderAndLogger(Charset.defaultCharset(), (InputStream)NullChecking.neverNull((Object)execChannel.getInputStream()), stdOutLog, true, this.stdOutBuffer);
            this.processStdErr = new AsyncInputStreamLineReaderAndLogger(Charset.defaultCharset(), (InputStream)NullChecking.neverNull((Object)execChannel.getErrStream()), stdErrLog, true, this.stdErrBuffer);
            execChannel.connect();
        }

        @Override
        public void close() throws IOException {
            try {
                this.waitForExit();
            }
            catch (Throwable throwable) {
                Throwing.closeAll((Closeable[])new Closeable[]{this.processStdIn, this.processStdOut, this.processStdErr});
                throw throwable;
            }
            Throwing.closeAll((Closeable[])new Closeable[]{this.processStdIn, this.processStdOut, this.processStdErr});
        }

        @Override
        public @NonNull List<@NonNull String> collectAllRemainingOutputAndWaitForExit() throws IOException {
            ITerminalConnection.TerminalLine line;
            this.waitForExit();
            @NonNull ArrayList<@NonNull String> result = new ArrayList<String>();
            while ((line = this.stdOutBuffer.nextLine()) != null || this.processStdOut.isRunning() || this.processStdErr.isRunning()) {
                if (line != null && line.complete) {
                    result.add(line.line);
                    continue;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public @Nullable List<@NonNull String> getErrorLines() {
            ITerminalConnection.TerminalLine line;
            @NonNull ArrayList<@NonNull String> result = new ArrayList<String>();
            while ((line = this.stdErrBuffer.nextLine()) != null) {
                if (!line.complete) continue;
                result.add(line.line);
            }
            return result;
        }

        @Override
        public @Nullable IBasicInteractiveShell.CommandStatus getExitCode() {
            if (this.isConnected()) {
                return null;
            }
            this.dump();
            return InteractiveCommand.decodeExitStatus(this.execChannel.getExitStatus());
        }

        @Override
        public void interrupt() throws Exception {
            this.execChannel.sendSigInt();
        }

        @Override
        public boolean isConnected() {
            return this.execChannel.isConnected() && this.execChannel.getExitStatus() < 0 || this.processStdOut.isRunning() || this.processStdErr.isRunning();
        }

        @Override
        public void kill() throws Exception {
            this.execChannel.sendSigKill();
        }

        @Override
        public @Nullable ITerminalConnection.TerminalLine nextLine() throws IOException {
            return this.stdOutBuffer.nextLine();
        }

        @Override
        public void send(@NonNull String text) throws IOException {
            if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_OUTPUT_TO_SCREEN) {
                int nl;
                this.logOut.append(text);
                int from = 0;
                while ((nl = this.logOut.indexOf("\n", from)) >= 0) {
                    System.out.printf("[OUT]: %s%n", this.logOut.substring(from, nl));
                    from = nl + 1;
                }
                if (from > 0) {
                    this.logOut.replace(0, from, "");
                }
            }
            this.processStdIn.write(text.getBytes());
            this.processStdIn.flush();
        }

        @Override
        public @NonNull IBasicInteractiveShell.CommandStatus waitForExitInterruptible() throws InterruptedException {
            while (this.isConnected()) {
                Thread.sleep(100L);
            }
            this.dump();
            return InteractiveCommand.decodeExitStatus(this.execChannel.getExitStatus());
        }

        private void dump() {
            if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_OUTPUT_TO_SCREEN) {
                System.err.printf("%n%n--------------------------------%n", new Object[0]);
                System.err.printf("         ------ isconnected %s%n", this.execChannel.isConnected());
                System.err.printf("         ------ iseof %s%n", this.execChannel.isEOF());
                System.err.printf("         ------ exitstatus %s%n", this.execChannel.getExitStatus());
                System.err.printf("         ------ processStdOut %s%n", this.processStdOut.isRunning());
                System.err.printf("         ------ processStdErr %s%n", this.processStdErr.isRunning());
                System.err.printf("--------------------------------%n%n%n", new Object[0]);
            }
        }
    }

    private static final class ProgressMonitor
    implements SftpProgressMonitor {
        private int lastProgress = 10;
        private long max = 0L;

        public boolean count(long count) {
            int percent;
            int progress;
            if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_OUTPUT_TO_SCREEN && (progress = (percent = Math.min(100, Math.max(0, (int)(100L * count / this.max)))) / 10) > this.lastProgress) {
                System.err.printf("[SFTP]     %d%%%n", percent);
            }
            return true;
        }

        public void end() {
            if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_OUTPUT_TO_SCREEN) {
                System.err.printf("[SFTP] Done%n", new Object[0]);
                this.lastProgress = 10;
            }
        }

        public void init(int op, String src, String dest, long max) {
            if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_OUTPUT_TO_SCREEN) {
                System.err.printf("[SFTP] %s %s -> %s%n", op == 1 ? "Getting" : "Putting", src, dest);
                this.max = max;
                this.lastProgress = 0;
            }
        }
    }
}

