/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.utils.function.IThrowingBiPredicate;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingPredicate;
import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TerminalWrapperConstants {
    private static final @NonNull Map<@NonNull String, @NonNull File> WRAPPER_EXES = new HashMap<String, File>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try {
                InputStream arm32Resource = TerminalWrapperConstants.class.getResourceAsStream("/armv7_terminal_wrapper");
                try {
                    block23: {
                        InputStream aarch64Resource = TerminalWrapperConstants.class.getResourceAsStream("/aarch64_terminal_wrapper");
                        try {
                            try (InputStream x86_64Resource = TerminalWrapperConstants.class.getResourceAsStream("/x86_64_terminal_wrapper");){
                                if (arm32Resource != null) {
                                    TerminalWrapperConstants.extractWrapperExe("arm32", arm32Resource);
                                }
                                if (aarch64Resource != null) {
                                    TerminalWrapperConstants.extractWrapperExe("arm64", aarch64Resource);
                                }
                                if (x86_64Resource != null) {
                                    TerminalWrapperConstants.extractWrapperExe("x86_64", x86_64Resource);
                                }
                            }
                            if (aarch64Resource == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (aarch64Resource == null) throw throwable;
                            aarch64Resource.close();
                            throw throwable;
                        }
                        aarch64Resource.close();
                    }
                    if (arm32Resource == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (arm32Resource == null) throw throwable;
                    arm32Resource.close();
                    throw throwable;
                }
                arm32Resource.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final boolean pushTerminalWrapper(@NonNull String destinationPath, @NonNull IThrowingSupplier<@NonNull IBasicInteractiveShell.InteractiveCommandResult, IOException> unameDashMRunner, @NonNull IThrowingFunction<@NonNull File, @Nullable String, IOException> remoteFilePusher, @NonNull IThrowingPredicate<@NonNull String, IOException> chmod755Runner, @NonNull IThrowingBiPredicate<@NonNull String, @NonNull String, IOException> renamerRunner) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult unameCmd = (IBasicInteractiveShell.InteractiveCommandResult)unameDashMRunner.get();
        if (!unameCmd.status.isSuccessful()) {
            unameCmd = (IBasicInteractiveShell.InteractiveCommandResult)unameDashMRunner.get();
            if (!unameCmd.status.isSuccessful()) {
                return false;
            }
        }
        assert (unameCmd.output.size() > 0);
        String machine = unameCmd.output.get(0).trim();
        @Nullable File wrapperExe = machine.startsWith("aarch64") ? WRAPPER_EXES.get("arm64") : (machine.startsWith("arm") ? WRAPPER_EXES.get("arm32") : (machine.startsWith("x86_64") ? WRAPPER_EXES.get("x86_64") : WRAPPER_EXES.get("x86_32")));
        if (wrapperExe == null) {
            return false;
        }
        String tempPath = (String)remoteFilePusher.apply((Object)wrapperExe);
        if (tempPath == null) {
            return false;
        }
        if (!chmod755Runner.test((Object)tempPath)) {
            return false;
        }
        return renamerRunner.test((Object)tempPath, (Object)destinationPath);
    }

    private static void extractWrapperExe(@NonNull String key, @NonNull InputStream data) throws IOException {
        File file = File.createTempFile("twr", "bin");
        file.deleteOnExit();
        FileUtils.writeStreamToFile((InputStream)data, (File)file);
        WRAPPER_EXES.put(key, file);
    }
}

