/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.streamline.deviceconn.lib.AbstractAsyncByteReaderLineReaderAndLogger;
import com.arm.utils.collections.Pair;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LogDirectory {
    private int commandCounter;
    private final @Nullable File logDirectory;

    private static @NonNull String cleanLogName(@NonNull String string) {
        return string.replaceAll("[^0-9A-Za-z]+", "_");
    }

    public LogDirectory(@Nullable File logDirectory) {
        this.logDirectory = logDirectory;
    }

    public @Nullable Pair<@NonNull File, @NonNull File> get(@NonNull List<@NonNull String> commandAndArgs) {
        @Nullable File logDirectory = this.logDirectory;
        if (logDirectory == null) {
            return null;
        }
        @NonNull String logName = this.makeLogName(commandAndArgs);
        @NonNull File stdOutLog = new File(logDirectory, String.format("%s.out", logName));
        @NonNull File stdErrLog = new File(logDirectory, String.format("%s.err", logName));
        if (AbstractAsyncByteReaderLineReaderAndLogger.LOG_COMMAND_TO_SCREEN) {
            System.out.printf("[LGF] Log file status:%n[LGF]   Command: %s%n[LGF]   Std Out: %s%n[LGF]   Std Err: %s%n", commandAndArgs.stream().collect(Collectors.joining(" ", "", "")), stdOutLog, stdErrLog);
        }
        return new Pair((Object)stdOutLog, (Object)stdErrLog);
    }

    public @Nullable Pair<@NonNull File, @NonNull File> get(@NonNull String command, @NonNull String[] arguments) {
        ArrayList<@NonNull String> commandAndArgs = new ArrayList<String>();
        commandAndArgs.add(command);
        commandAndArgs.addAll(Arrays.asList(arguments));
        return this.get(commandAndArgs);
    }

    private @NonNull String makeLogName(@NonNull List<@NonNull String> commandAndArgs) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
        int token = this.commandCounter++;
        StringBuilder builder = new StringBuilder();
        builder.append(token);
        builder.append('-').append(format.format(new Date()));
        int sep = 45;
        for (String argument : commandAndArgs) {
            builder.append((char)sep).append(LogDirectory.cleanLogName(argument));
            sep = 95;
        }
        String result = builder.toString();
        int len = result.length();
        return len < 64 ? result : result.substring(0, 64);
    }
}

