/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;

public final class AsyncCommandFuture
implements Future<IBasicInteractiveShell.InteractiveCommandResult> {
    public static final @NonNull ExecutorService ASYNC_CMD_EXECUTOR = Executors.newCachedThreadPool();
    private final @NonNull AtomicReference<Throwable> exception = new AtomicReference();
    private final @NonNull IAsyncCommandFutureHelper helper;
    private final @NonNull AtomicReference<@NonNull IBasicInteractiveShell.InteractiveCommandResult> result = new AtomicReference();
    private final @NonNull AtomicReference<CompletionState> state_ = new AtomicReference<CompletionState>(CompletionState.PENDING);
    private final @NonNull Object waitNotifier_ = new Object();

    public AsyncCommandFuture(@NonNull IAsyncCommandFutureHelper helper) {
        this.helper = helper;
        ASYNC_CMD_EXECUTOR.submit(() -> {
            if (this.moveState(CompletionState.PENDING, CompletionState.RUNNING)) {
                try {
                    try {
                        @NonNull IBasicInteractiveShell.InteractiveCommandResult value = helper.waitForResult();
                        this.result.set(value);
                        this.moveState(CompletionState.RUNNING, CompletionState.SUCCESS);
                    }
                    catch (Throwable t) {
                        this.exception.set(t);
                        this.moveState(CompletionState.RUNNING, CompletionState.EXCEPTION);
                        this.moveState(CompletionState.CANCEL_REQUESTED, CompletionState.CANCELLED);
                    }
                }
                finally {
                    this.moveState(CompletionState.CANCEL_REQUESTED, CompletionState.CANCELLED);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        CompletionState state;
        block8: while (true) {
            state = this.state_.get();
            switch (AsyncCommandFuture.$SWITCH_TABLE$com$arm$streamline$deviceconn$lib$AsyncCommandFuture$CompletionState()[state.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    return false;
                }
                case 4: {
                    if (!this.moveState(CompletionState.PENDING, CompletionState.CANCELLED)) continue block8;
                    return true;
                }
                case 5: {
                    if (!mayInterruptIfRunning) {
                        return false;
                    }
                    if (!this.moveState(CompletionState.RUNNING, CompletionState.CANCEL_REQUESTED)) continue block8;
                    Object object = this.waitNotifier_;
                    synchronized (object) {
                        this.tryToStop(CompletionState.CANCEL_REQUESTED);
                    }
                }
                continue block8;
            }
            break;
        }
        throw new AssertionError((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult get() throws InterruptedException, ExecutionException {
        while (true) {
            Object object = this.waitNotifier_;
            synchronized (object) {
                CompletionState currentState = this.state_.get();
                switch (currentState) {
                    case CANCEL_REQUESTED: 
                    case CANCELLED: {
                        throw new CancellationException();
                    }
                    case EXCEPTION: {
                        throw new ExecutionException(this.exception.get());
                    }
                    case SUCCESS: {
                        return this.result.get();
                    }
                    case PENDING: 
                    case RUNNING: {
                        this.waitNotifier_.wait();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)currentState);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull IBasicInteractiveShell.InteractiveCommandResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean firstPass = true;
        while (true) {
            Object object = this.waitNotifier_;
            synchronized (object) {
                CompletionState currentState = this.state_.get();
                switch (currentState) {
                    case CANCEL_REQUESTED: 
                    case CANCELLED: {
                        throw new CancellationException();
                    }
                    case EXCEPTION: {
                        throw new ExecutionException(this.exception.get());
                    }
                    case SUCCESS: {
                        return this.result.get();
                    }
                    case PENDING: 
                    case RUNNING: {
                        if (!firstPass) {
                            throw new TimeoutException();
                        }
                        long milliseconds = TimeUnit.MILLISECONDS.convert(timeout, unit);
                        int nanoseconds = (int)(TimeUnit.NANOSECONDS.convert(timeout, unit) % 1000000L);
                        this.waitNotifier_.wait(milliseconds, nanoseconds);
                        firstPass = false;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)currentState);
                    }
                }
            }
        }
    }

    @Override
    public boolean isCancelled() {
        CompletionState currentState = this.state_.get();
        switch (currentState) {
            case CANCEL_REQUESTED: 
            case CANCELLED: {
                return true;
            }
            case EXCEPTION: 
            case PENDING: 
            case RUNNING: 
            case SUCCESS: {
                return false;
            }
        }
        throw new AssertionError((Object)currentState);
    }

    @Override
    public boolean isDone() {
        CompletionState currentState = this.state_.get();
        switch (currentState) {
            case CANCEL_REQUESTED: 
            case CANCELLED: 
            case EXCEPTION: 
            case SUCCESS: {
                return true;
            }
            case PENDING: 
            case RUNNING: {
                return false;
            }
        }
        throw new AssertionError((Object)currentState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        CompletionState state;
        block14: while (true) {
            state = this.state_.get();
            switch (AsyncCommandFuture.$SWITCH_TABLE$com$arm$streamline$deviceconn$lib$AsyncCommandFuture$CompletionState()[state.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    return false;
                }
                case 6: {
                    return true;
                }
                case 4: {
                    CompletionState state1;
                    Object object = this.waitNotifier_;
                    synchronized (object) {
                        state1 = this.state_.get();
                        if (state1 == CompletionState.PENDING) {
                            try {
                                this.waitNotifier_.wait();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        continue block14;
                    }
                }
                case 5: {
                    CompletionState state1;
                    Object object = this.waitNotifier_;
                    synchronized (object) {
                        state1 = this.state_.get();
                        if (state1 == CompletionState.RUNNING) {
                            this.tryToStop(CompletionState.RUNNING);
                        }
                    }
                }
                continue block14;
            }
            break;
        }
        throw new AssertionError((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveState(@NonNull CompletionState expected, @NonNull CompletionState to) {
        Object object = this.waitNotifier_;
        synchronized (object) {
            block4: {
                if (this.state_.compareAndSet(expected, to)) break block4;
                return false;
            }
            this.waitNotifier_.notifyAll();
            return true;
        }
    }

    private void tryToStop(@NonNull CompletionState expectedCurrentState) {
        System.err.printf("Terminating async command %s%n", this.helper.name());
        try {
            int i = 0;
            while (i < 20 && this.state_.get() == expectedCurrentState) {
                System.err.printf(" ...interrupting (%d)%n", i);
                this.helper.interrupt(false);
                this.waitNotifier_.wait(1000L);
                ++i;
            }
            i = 0;
            while (i < 20 && this.state_.get() == expectedCurrentState) {
                System.err.printf(" ...terminating (%d)%n", i);
                this.helper.interrupt(true);
                this.waitNotifier_.wait(1000L);
                ++i;
            }
            i = 0;
            while (i < 20 && this.state_.get() == expectedCurrentState) {
                System.err.printf(" ...killing (%d)%n", i);
                this.helper.kill();
                this.waitNotifier_.wait(1000L);
                ++i;
            }
            this.moveState(expectedCurrentState, CompletionState.CANCELLED);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static enum CompletionState {
        CANCEL_REQUESTED,
        CANCELLED,
        EXCEPTION,
        PENDING,
        RUNNING,
        SUCCESS;

    }

    public static interface IAsyncCommandFutureHelper {
        public void interrupt(boolean var1) throws Exception;

        public void kill() throws Exception;

        public @NonNull String name();

        public @NonNull IBasicInteractiveShell.InteractiveCommandResult waitForResult() throws IOException;
    }
}

