/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.lib;

import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.function.Throwing;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractAsyncByteReaderLineReaderAndLogger
implements Closeable {
    public static final boolean LOG_COMMAND_TO_SCREEN;
    public static final boolean LOG_OUTPUT_TO_SCREEN;
    private final @NonNull CharsetDecoder charsetDecoder;
    private final @NonNull ILineConsumer lineConsumer;
    private final @NonNull IThrowingSupplier<@NonNull IByteConsumer, IOException> logStreamFactory;
    private final @NonNull AtomicBoolean running = new AtomicBoolean(true);
    private final long startTs = System.nanoTime();
    private final @NonNull Thread thread;
    private final boolean wantPartial;

    static {
        @Nullable String envLogCommand = System.getenv("DEVTEST_LOG_COMMAND");
        @Nullable String envLogToScreen = System.getenv("DEVTEST_LOG_TO_SCREEN");
        LOG_OUTPUT_TO_SCREEN = envLogToScreen != null ? envLogToScreen.toLowerCase().matches("^(true)|([1-9][0-9]*)$") : false;
        LOG_COMMAND_TO_SCREEN = envLogCommand != null ? LOG_OUTPUT_TO_SCREEN || envLogCommand.toLowerCase().matches("^(true)|([1-9][0-9]*)$") : LOG_OUTPUT_TO_SCREEN;
    }

    public static @NonNull IThrowingSupplier<@NonNull IByteConsumer, IOException> createLogFileOutputStreamFactory(@Nullable File logFile) {
        return () -> {
            if (logFile == null) {
                return IByteConsumer.NULL_BYTE_CONSUMER;
            }
            return new OutputStreamByteConsumer(logFile);
        };
    }

    public AbstractAsyncByteReaderLineReaderAndLogger(@NonNull Charset charSet, boolean wantPartial, @NonNull ILineConsumer lineConsumer, @NonNull IThrowingSupplier<@NonNull IByteConsumer, IOException> logStreamFactory) {
        this.logStreamFactory = logStreamFactory;
        this.wantPartial = wantPartial;
        this.lineConsumer = lineConsumer;
        this.charsetDecoder = charSet.newDecoder();
        this.charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.charsetDecoder.replaceWith("?");
        this.thread = new Thread(this::run);
        this.thread.setDaemon(true);
        this.thread.setName(AbstractAsyncByteReaderLineReaderAndLogger.class.getSimpleName());
    }

    @Override
    public void close() throws IOException {
        this.logLine("----------- CLOSED -----------");
    }

    public @NonNull StackTraceElement @NonNull [] getStackTrace() {
        return this.thread.getStackTrace();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected abstract int read(byte @NonNull [] var1) throws IOException;

    protected final void start() {
        this.thread.start();
    }

    private void appendLine(byte @NonNull [] bytes) {
        String line = this.convertLine(bytes);
        this.logLine(line);
        this.lineConsumer.accept(true, line);
    }

    private @NonNull String convertLine(byte @NonNull [] bytes) {
        try {
            CharBuffer buffer = this.charsetDecoder.decode(ByteBuffer.wrap(bytes));
            return buffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void logLine(@NonNull String line) {
        if (LOG_OUTPUT_TO_SCREEN) {
            long d = System.nanoTime() - this.startTs;
            int m_s = (int)(d / 1000000000L);
            int m = m_s / 60;
            int s = m_s % 60;
            int u = (int)(d % 1000000000L) / 1000000;
            System.out.printf("[LOG %02d:%02d.%03d]: %s%n", m, s, u, line);
        }
    }

    private byte processBuffer(@NonNull ByteArrayOutputStream byteBuffer, byte @NonNull [] buffer, int nRead, byte lastNewline) {
        int readPos = 0;
        byte result = 0;
        while (readPos < nRead) {
            int remaining;
            int newlinePos = -1;
            int i = readPos;
            while (i < nRead) {
                if (buffer[i] == 10 || buffer[i] == 13) {
                    newlinePos = i;
                    break;
                }
                ++i;
            }
            if (newlinePos < 0) {
                remaining = nRead - readPos;
                if (remaining > 0) {
                    byteBuffer.write(buffer, readPos, remaining);
                }
                return 0;
            }
            if (newlinePos == 0 && (lastNewline == 10 && buffer[newlinePos] == 13 || lastNewline == 13 && buffer[newlinePos] == 10)) {
                readPos = 1;
                continue;
            }
            remaining = newlinePos - readPos;
            if (remaining > 0) {
                byteBuffer.write(buffer, readPos, remaining);
            }
            this.appendLine(byteBuffer.toByteArray());
            byteBuffer.reset();
            if (newlinePos == nRead - 1) {
                result = buffer[newlinePos];
                readPos = nRead;
                continue;
            }
            readPos = buffer[newlinePos] == 10 && buffer[newlinePos + 1] == 13 || buffer[newlinePos] == 13 && buffer[newlinePos + 1] == 10 ? newlinePos + 2 : newlinePos + 1;
        }
        return result;
    }

    private void run() {
        try {
            try {
                byte lastNewline = 0;
                Throwable throwable = null;
                Object var3_5 = null;
                try (ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (IByteConsumer fileOuputStream = (IByteConsumer)this.logStreamFactory.get();){
                        String line;
                        byte[] buffer = new byte[65536];
                        int nRead = 0;
                        while ((nRead = this.read(buffer)) >= 0) {
                            if (nRead <= 0) continue;
                            fileOuputStream.write(buffer, 0, nRead);
                            lastNewline = this.processBuffer(byteBuffer, buffer, nRead, lastNewline);
                            if (!this.wantPartial || (line = this.convertLine(byteBuffer.toByteArray())).isEmpty()) continue;
                            this.lineConsumer.accept(false, line);
                        }
                        line = this.convertLine(byteBuffer.toByteArray());
                        if (!line.isEmpty()) {
                            this.lineConsumer.accept(true, line);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                this.running.set(false);
            }
        }
        finally {
            this.running.set(false);
        }
    }

    public static interface IByteConsumer
    extends Closeable {
        public static final @NonNull IByteConsumer NULL_BYTE_CONSUMER = new IByteConsumer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(byte @NonNull [] data, int offset, int length) throws IOException {
            }
        };

        public void write(byte @NonNull [] var1, int var2, int var3) throws IOException;
    }

    @FunctionalInterface
    public static interface ILineConsumer {
        public static final @NonNull ILineConsumer NULL_LINE_CONSUMER = (complete, text) -> {};

        public void accept(boolean var1, @NonNull String var2);
    }

    public static final class OutputStreamByteConsumer
    implements IByteConsumer {
        private final @NonNull OutputStream stream;

        public OutputStreamByteConsumer(@NonNull File file) throws FileNotFoundException {
            this.stream = (OutputStream)Throwing.closeIfThrows(BufferedOutputStream::new, (Object)((FileOutputStream)Throwing.closeIfThrows(FileOutputStream::new, (Object)file, (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
        }

        public OutputStreamByteConsumer(@NonNull OutputStream stream) {
            this.stream = stream;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public void write(byte @NonNull [] data, int offset, int length) throws IOException {
            this.stream.write(data, offset, length);
        }
    }
}

