/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.deviceconn.adb;

import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.IAdbPackageCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.lib.AsyncCommandFuture;
import com.arm.streamline.deviceconn.lib.IProcessInteractiveCommand;
import com.arm.utils.function.IThrowingSupplier;
import gnu.trove.map.TIntIntMap;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IAdbCommandRunner
extends IBasicInteractiveShell {
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$deviceconn$adb$AdbDeviceRootMode;

    public static @NonNull AdbDeviceRootMode detectRootMode(@NonNull IAdbCommandRunner commandRunner) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult result = commandRunner.runCommandAndGetOutput(WrapMode.DEFAULT, "getprop", "ro.build.type");
        if (result.status.isSuccessful() && result.output.size() > 0 && result.output.get(0).contentEquals("user")) {
            return AdbDeviceRootMode.NONE;
        }
        result = commandRunner.runCommandAndGetOutput(WrapMode.SU, "id", new String[0]);
        if (result.status.isSuccessful() && result.output.size() > 0 && IAdbCommandRunner.idIsRoot(result.output.get(0))) {
            return AdbDeviceRootMode.USE_SU_0;
        }
        result = commandRunner.runCommandAndGetOutput(WrapMode.SU, "sh", "-c", "echo $USER");
        if (result.status.isSuccessful() && result.output.size() > 0 && result.output.get(0).contentEquals("root")) {
            return AdbDeviceRootMode.USE_SU_0;
        }
        result = commandRunner.runCommandAndGetOutput(WrapMode.DEFAULT, "id", new String[0]);
        if (result.status.isSuccessful() && result.output.size() > 0 && IAdbCommandRunner.idIsRoot(result.output.get(0))) {
            return AdbDeviceRootMode.DEFAULTS_TO_ROOT;
        }
        result = commandRunner.runCommandAndGetOutput(WrapMode.DEFAULT, "sh", "-c", "echo $USER");
        if (result.status.isSuccessful() && result.output.size() > 0 && result.output.get(0).contentEquals("root")) {
            return AdbDeviceRootMode.DEFAULTS_TO_ROOT;
        }
        return AdbDeviceRootMode.NONE;
    }

    public static @NonNull WrapMode rootWrapModeOrDefault(@NonNull AdbDeviceRootMode rootMode) {
        switch (rootMode) {
            case DEFAULTS_TO_ROOT: {
                return WrapMode.DEFAULT;
            }
            case USE_SU_0: {
                return WrapMode.SU;
            }
            case NONE: {
                return WrapMode.DEFAULT;
            }
        }
        throw new AssertionError((Object)rootMode);
    }

    public static @Nullable WrapMode rootWrapMode(@NonNull AdbDeviceRootMode rootMode) {
        switch (rootMode) {
            case DEFAULTS_TO_ROOT: {
                return WrapMode.DEFAULT;
            }
            case USE_SU_0: {
                return WrapMode.SU;
            }
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)rootMode);
    }

    private static boolean idIsRoot(@NonNull String string) {
        String[] parts;
        String[] stringArray = parts = string.split("[ \\t\\n\\r]+");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.contentEquals("uid=0") || part.contentEquals("uid=root") || part.startsWith("uid=0(")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public @NonNull File adbPull(boolean var1, @NonNull File var2, @NonNull String var3) throws IOException;

    public @NonNull String adbPush(@NonNull File var1, @NonNull String var2) throws IOException;

    default public @NonNull AdbDeviceRootMode detectRootMode() throws IOException {
        return IAdbCommandRunner.detectRootMode(this);
    }

    public @NonNull IAdbProcessRunner getAdbProcessRunner();

    public @NonNull String getDeviceSerial();

    public @Nullable String pushAsTempFile(@NonNull File var1) throws IOException;

    public @NonNull IAdbPackageCommandRunner runAs(@NonNull String var1) throws IOException;

    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutput(@NonNull WrapMode var1, @NonNull String var2, String ... var3) throws IOException;

    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull IThrowingSupplier< @NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> var1, @NonNull String var2, String ... var3) throws IOException;

    public @NonNull IBasicInteractiveShell.InteractiveCommandResult runCommandAndGetOutputAsStream(@NonNull WrapMode var1, @NonNull IThrowingSupplier< @NonNull AbstractAsyncByteReaderLineReaderAndLogger.IByteConsumer, IOException> var2, @NonNull String var3, String ... var4) throws IOException;

    public @NonNull AsyncCommandFuture runCommandAsync(@NonNull WrapMode var1, @NonNull String var2, String ... var3) throws IOException;

    public @NonNull IProcessInteractiveCommand runInteractiveCommand(@NonNull WrapMode var1, @NonNull String var2, String ... var3) throws IOException;

    public void setPortForwards(@NonNull TIntIntMap var1) throws IOException;

    public static enum WrapMode {
        DEFAULT,
        PLAIN,
        SU;

    }
}

