/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.IterUtils;
import gnu.trove.TIntCollection;
import gnu.trove.TShortCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StreamUtils {
    public static <T> @NonNull Stream<T> addFirst(T element, @NonNull Stream<? extends T> stream) {
        return Stream.concat(Stream.of(element), stream);
    }

    public static <T> @NonNull Stream<T> addLast(@NonNull Stream<? extends T> stream, T element) {
        return Stream.concat(stream, Stream.of(element));
    }

    @SafeVarargs
    public static <T> @NonNull Stream<T> concat(Stream<? extends T> ... streams) {
        if (streams.length == 0) {
            return Stream.empty();
        }
        Stream<? extends T> stream = StreamUtils.superOf(streams[0]);
        int i = 1;
        while (i < streams.length) {
            stream = Stream.concat(stream, streams[i]);
            ++i;
        }
        return stream;
    }

    public static <T> @NonNull Stream<@NonNull T> emptyIfNullOf(@Nullable T item) {
        if (item == null) {
            return Stream.empty();
        }
        return Stream.of(item);
    }

    public static <T> @NonNull Stream<T> emptyIfNullOfArray(T @Nullable [] values) {
        if (values == null) {
            return Stream.empty();
        }
        return Arrays.stream(values);
    }

    public static <T> @NonNull Stream<T> emptyIfNullOfCollection(@Nullable Collection<T> collection) {
        if (collection == null) {
            return Stream.empty();
        }
        return collection.stream();
    }

    public static <T> @NonNull Stream<@NonNull T> filterClass(@NonNull Stream<?> stream, @NonNull Class<? extends T> klass) {
        return stream.filter(klass::isInstance);
    }

    public static <T> @NonNull Stream<@NonNull T> filterOutNull(@NonNull Stream<@Nullable T> stream) {
        return stream.filter(Objects::nonNull);
    }

    public static <T> boolean hasAny(@NonNull Stream<T> stream) {
        return stream.map(x -> new Object()).findAny().isPresent();
    }

    public static @NonNull IntStream intSetBitIndexes(int ... is) {
        return IntStream.range(0, is.length * 32).filter(bit -> (is[bit / 32] & 1 << bit % 32) != 0);
    }

    public static @NonNull LongStream longBinaryZip(@NonNull LongStream a, @NonNull LongStream b, final @NonNull LongBinaryOperator zipper) {
        Spliterator.OfLong aSpliterator = a.spliterator();
        Spliterator.OfLong bSpliterator = b.spliterator();
        int characteristics = aSpliterator.characteristics() & bSpliterator.characteristics() & 0xFFFFFFFA;
        long zipSize = (characteristics & 0x40) != 0 ? Math.min(aSpliterator.getExactSizeIfKnown(), bSpliterator.getExactSizeIfKnown()) : -1L;
        final PrimitiveIterator.OfLong aIterator = Spliterators.iterator(aSpliterator);
        final PrimitiveIterator.OfLong bIterator = Spliterators.iterator(bSpliterator);
        PrimitiveIterator.OfLong cIterator = new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return aIterator.hasNext() && bIterator.hasNext();
            }

            @Override
            public long nextLong() {
                return zipper.applyAsLong(aIterator.nextLong(), bIterator.nextLong());
            }
        };
        Spliterator.OfLong split = Spliterators.spliterator(cIterator, zipSize, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.longStream(split, true) : StreamSupport.longStream(split, false);
    }

    public static @NonNull IntStream longSetBitIndexes(long ... is) {
        return IntStream.range(0, is.length * 64).filter(bit -> (is[bit / 64] & 1L << bit % 64) != 0L);
    }

    public static @NonNull Stream<@NonNull String> matches(@NonNull Matcher matcher) {
        return StreamUtils.matches(matcher, 0);
    }

    public static @NonNull Stream<@NonNull String> matches(final @NonNull Matcher matcher, final int group) {
        if (group < 0 || group > matcher.groupCount()) {
            throw new IllegalArgumentException("group " + group + "is larger than the group count " + matcher.groupCount());
        }
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<String>((long)(matcher.regionEnd() - matcher.regionStart()), 272){

            @Override
            public boolean tryAdvance(Consumer<? super String> action) {
                if (!matcher.find()) {
                    return false;
                }
                action.accept(matcher.group(group));
                return true;
            }
        }, false);
    }

    public static <T> @NonNull Stream<T> of(@NonNull Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static @NonNull IntStream of(@NonNull TIntCollection collection) {
        return StreamSupport.intStream(Spliterators.spliterator(IterUtils.of(collection), (long)collection.size(), 0), false);
    }

    public static @NonNull IntStream ofUnsigned(@NonNull TShortCollection collection) {
        return StreamSupport.intStream(Spliterators.spliterator(IterUtils.ofUnsigned(collection), (long)collection.size(), 0), false);
    }

    public static <I, P> @NonNull Stream<P> pairs(@NonNull Stream<? extends I> input, final @NonNull BiFunction<? super I, ? super I, ? extends P> pairer) {
        Spliterator inputSpliterator = input.spliterator();
        int characteristics = inputSpliterator.characteristics() & 0xFFFFFFFA;
        long size = (characteristics & 0x40) != 0 ? inputSpliterator.getExactSizeIfKnown() / 2L : -1L;
        final Iterator inputIterator = Spliterators.iterator(inputSpliterator);
        Iterator outputIterator = new Iterator<P>(){
            @Nullable I next = null;
            boolean nextIsValid = false;

            @Override
            public boolean hasNext() {
                if (!this.nextIsValid) {
                    if (inputIterator.hasNext()) {
                        this.next = inputIterator.next();
                        this.nextIsValid = true;
                    } else {
                        return false;
                    }
                }
                return inputIterator.hasNext();
            }

            @Override
            public P next() {
                if (!this.nextIsValid) {
                    this.next = inputIterator.next();
                    this.nextIsValid = true;
                }
                Object next2 = inputIterator.next();
                this.nextIsValid = false;
                return pairer.apply(this.next, next2);
            }
        };
        Spliterator split = Spliterators.spliterator(outputIterator, size, characteristics);
        return StreamSupport.stream(split, input.isParallel());
    }

    public static <V> @NonNull Stream<@Nullable V> singleNullIfEmpty(@NonNull Collection<V> collection) {
        if (collection.isEmpty()) {
            return Stream.of((Object)null);
        }
        return StreamUtils.superOf(collection.stream());
    }

    public static <T> @NonNull Stream<T> superOf(@NonNull Stream<? extends T> stream) {
        return stream;
    }

    public static <A, B> @NonNull IntStream toIntZip(@NonNull Stream<? extends A> a, @NonNull Stream<? extends B> b, final @NonNull ToIntBiFunction<? super A, ? super B> zipper) {
        Spliterator aSpliterator = a.spliterator();
        Spliterator bSpliterator = b.spliterator();
        int characteristics = aSpliterator.characteristics() & bSpliterator.characteristics() & 0xFFFFFFFA;
        long zipSize = (characteristics & 0x40) != 0 ? Math.min(aSpliterator.getExactSizeIfKnown(), bSpliterator.getExactSizeIfKnown()) : -1L;
        final Iterator aIterator = Spliterators.iterator(aSpliterator);
        final Iterator bIterator = Spliterators.iterator(bSpliterator);
        PrimitiveIterator.OfInt cIterator = new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return aIterator.hasNext() && bIterator.hasNext();
            }

            @Override
            public int nextInt() {
                return zipper.applyAsInt(aIterator.next(), bIterator.next());
            }
        };
        Spliterator.OfInt split = Spliterators.spliterator(cIterator, zipSize, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.intStream(split, true) : StreamSupport.intStream(split, false);
    }

    public static <A, B> @NonNull LongStream toLongZip(@NonNull Stream<? extends A> a, @NonNull Stream<? extends B> b, final @NonNull ToLongBiFunction<? super A, ? super B> zipper) {
        Spliterator aSpliterator = a.spliterator();
        Spliterator bSpliterator = b.spliterator();
        int characteristics = aSpliterator.characteristics() & bSpliterator.characteristics() & 0xFFFFFFFA;
        long zipSize = (characteristics & 0x40) != 0 ? Math.min(aSpliterator.getExactSizeIfKnown(), bSpliterator.getExactSizeIfKnown()) : -1L;
        final Iterator aIterator = Spliterators.iterator(aSpliterator);
        final Iterator bIterator = Spliterators.iterator(bSpliterator);
        PrimitiveIterator.OfLong cIterator = new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return aIterator.hasNext() && bIterator.hasNext();
            }

            @Override
            public long nextLong() {
                return zipper.applyAsLong(aIterator.next(), bIterator.next());
            }
        };
        Spliterator.OfLong split = Spliterators.spliterator(cIterator, zipSize, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.longStream(split, true) : StreamSupport.longStream(split, false);
    }

    public static <T> @NonNull Stream<@NonNull T> whileNotNull(@Nullable T first, @NonNull Function<? super @NonNull T, ? extends @Nullable T> map) {
        return StreamSupport.stream(IterUtils.whileNotNull(first, map).spliterator(), false);
    }

    public static <T> @NonNull Stream<@NonNull List<T>> windowsOf(@NonNull List<T> list, int windowSize) {
        return IntStream.range(0, list.size() - windowSize + 1).mapToObj(i -> list.subList(i, i + windowSize));
    }

    public static <T> @NonNull Stream<@NonNull List<T>> windowsOf(@NonNull Stream<T> stream, int windowSize) {
        return StreamUtils.windowsOf(stream.collect(Collectors.toList()), windowSize);
    }

    public static <A, B, C> @NonNull Stream<C> zip(@NonNull Stream<? extends A> a, @NonNull Stream<? extends B> b, final @NonNull BiFunction<? super A, ? super B, ? extends C> zipper) {
        Spliterator aSpliterator = a.spliterator();
        Spliterator bSpliterator = b.spliterator();
        int characteristics = aSpliterator.characteristics() & bSpliterator.characteristics() & 0xFFFFFFFA;
        long zipSize = (characteristics & 0x40) != 0 ? Math.min(aSpliterator.getExactSizeIfKnown(), bSpliterator.getExactSizeIfKnown()) : -1L;
        final Iterator aIterator = Spliterators.iterator(aSpliterator);
        final Iterator bIterator = Spliterators.iterator(bSpliterator);
        Iterator cIterator = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return aIterator.hasNext() && bIterator.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(aIterator.next(), bIterator.next());
            }
        };
        Spliterator split = Spliterators.spliterator(cIterator, zipSize, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.stream(split, true) : StreamSupport.stream(split, false);
    }
}

