/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingIntFunction;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jdt.annotation.NonNull;

public class ArrayUtils {
    @SafeVarargs
    public static <T> T @NonNull [] append(T @NonNull [] array, T ... elementsToAppend) {
        return ArrayUtils.concat(array, elementsToAppend, array.getClass());
    }

    public static int binarySearchUnsigned(long @NonNull [] values, long key) {
        int low = 0;
        int high = values.length - 1;
        while (high >= low) {
            int mid = low + high >>> 1;
            long value = values[mid];
            if (key == value) {
                return mid;
            }
            if (Long.compareUnsigned(key, value) < 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -low - 1;
    }

    public static <T> void clear(T[] array) {
        Arrays.fill(array, null);
    }

    public static <T> T @NonNull [] concat(T @NonNull [] first, T @NonNull [] second, @NonNull Class<? extends T[]> newType) {
        T @NonNull [] result = Arrays.copyOf(first, first.length + second.length, newType);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T, E extends Throwable> T @NonNull [] create(@NonNull IntFunction<T @NonNull []> arraySupplier, int count, IThrowingIntFunction<? extends T, E> elementSupplier) throws E {
        T @NonNull [] array = arraySupplier.apply(count);
        int i = 0;
        while (i < count) {
            array[i] = elementSupplier.apply(i);
            ++i;
        }
        return array;
    }

    public static <T> T @NonNull [] create(@NonNull IntFunction<T @NonNull []> arraySupplier, int count, Supplier<? extends T> elementSupplier) {
        return ArrayUtils.create(arraySupplier, count, (int i) -> elementSupplier.get());
    }

    public static <T, E extends Throwable> @NonNull T @NonNull [] createNonNull(@NonNull IntFunction<T @NonNull []> arraySupplier, int count, IThrowingIntFunction<? extends @NonNull T, E> elementSupplier) throws E {
        @NonNull T @NonNull [] array = arraySupplier.apply(count);
        int i = 0;
        while (i < count) {
            array[i] = elementSupplier.apply(i);
            ++i;
        }
        return array;
    }

    public static <T> void forEach(T[] array, @NonNull Consumer<? super T> consumer) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            consumer.accept(element);
            ++n2;
        }
    }

    public static <T> void forN(T[] array, int n, @NonNull Supplier<? extends T> supplier, @NonNull Consumer<? super T> consumer) {
        int numberFromArray = Math.min(array.length, n);
        int i = 0;
        while (i < numberFromArray) {
            consumer.accept(array[i]);
            ++i;
        }
        int numberFromSupplier = Math.max(n - array.length, 0);
        int i2 = 0;
        while (i2 < numberFromSupplier) {
            consumer.accept(supplier.get());
            ++i2;
        }
    }

    public static int indexOf(int @NonNull [] haystack, int needle) {
        int i = 0;
        while (i < haystack.length) {
            if (needle == haystack[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(long @NonNull [] haystack, long needle) {
        int i = 0;
        while (i < haystack.length) {
            if (needle == haystack[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] haystack, T needle) {
        int i = 0;
        while (i < haystack.length) {
            if (NullChecking.equalsNullable(needle, haystack[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int indexOfMatch(T[] haystack, @NonNull Predicate<T> isMatch) {
        int i = 0;
        while (i < haystack.length) {
            if (isMatch.test(haystack[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, R, E extends Throwable> R @NonNull [] map(T @NonNull [] input, @NonNull IntFunction<R @NonNull []> constructor, @NonNull IThrowingFunction<? super T, ? extends R, E> entryMapper) throws E {
        int length = input.length;
        R[] result = constructor.apply(length);
        assert (result != null && result.length == length);
        int i = 0;
        while (i < length) {
            result[i] = entryMapper.apply(input[i]);
            ++i;
        }
        return result;
    }

    public static int max(int ... elements) {
        return IntStream.of(elements).max().orElse(Integer.MIN_VALUE);
    }

    @SafeVarargs
    public static <T> T @NonNull [] of(T ... ts) {
        return ts;
    }

    @SafeVarargs
    public static <T> T @NonNull [] prepend(T @NonNull [] array, T ... elementsToPrepend) {
        return ArrayUtils.concat(elementsToPrepend, array, array.getClass());
    }

    public static <T> T put(T[] array, int index, T item) {
        T result = array[index];
        array[index] = item;
        return result;
    }

    public static void reverse(long[] array) {
        int middle = array.length / 2;
        int i = 0;
        while (i < middle) {
            int j = array.length - i - 1;
            long temp = array[i];
            array[i] = array[j];
            array[j] = temp;
            ++i;
        }
    }

    public static void sortUnsigned(byte @NonNull [] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = (byte)(values[n] + -128);
        }
        Arrays.sort(values);
        i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = (byte)(values[n] - -128);
        }
    }

    public static void sortUnsigned(int @NonNull [] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] + Integer.MIN_VALUE;
        }
        Arrays.sort(values);
        i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] - Integer.MIN_VALUE;
        }
    }

    public static void sortUnsigned(long @NonNull [] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] + Long.MIN_VALUE;
        }
        Arrays.sort(values);
        i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] - Long.MIN_VALUE;
        }
    }

    public static void sortUnsigned(short @NonNull [] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = (short)(values[n] + Short.MIN_VALUE);
        }
        Arrays.sort(values);
        i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = (short)(values[n] - Short.MIN_VALUE);
        }
    }

    public static @NonNull String toString(byte[] array, @NonNull IntFunction<@NonNull String> mapper) {
        StringBuilder result = new StringBuilder();
        result.append('[');
        boolean first = true;
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int i = b & 0xFF;
            @NonNull String s = mapper.apply(i);
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(s);
            ++n2;
        }
        result.append(']');
        return result.toString();
    }

    public static @NonNull String toString(int[] array, @NonNull IntFunction<@NonNull String> mapper) {
        return Arrays.stream(array).mapToObj(mapper).collect(Collectors.joining(", ", "[", "]"));
    }

    public static @NonNull String toString(long[] array, @NonNull LongFunction<@NonNull String> mapper) {
        return Arrays.stream(array).mapToObj(mapper).collect(Collectors.joining(", ", "[", "]"));
    }
}

