# Arm® Streamline CLI Tools Release Note

_Non-confidential. Copyright © 2024 Arm Limited._

## 1 Release overview

Arm Neoverse™ CPUs provide cloud and server workloads with an energy efficient
computing platform. These systems give high application performance and an
excellent operational price-performance ratio. To maximize performance, you can
tune your software for the underlying hardware. To do this effectively, you
need high quality performance data from the hardware, and performance analysis
tooling to capture and interpret it.

The Streamline CLI tools provide a software profiling methodology that gives
you clear and actionable performance data. You can use this data to guide the
optimization of the heavily used functions in your software.

The CLI tools are simple to deploy, and can be used in a standalone workflow
that runs entirely on the Arm server. Alternatively, data can be recorded on
the server using `sl-record`, and then exported for offline analysis using the
full Streamline GUI application.

## 1.1 Release status

This is the REL quality release of Arm Streamline CLI Tools 9.2.2.

This release produces captures that are compatible with the Streamline 9.2.x
GUI, which is part of the Arm Performance Studio 2024.2 release.

## 1.2 Feedback

We love to hear developer feedback, and use this feedback to prioritize fixes
and feature development. Please let us know about any bugs you encounter, or
features you would like to see in a future release.

You can contact the product team via email at performancestudio@arm.com.

# 2 Changes in this release

The 9.2.x series is the first production quality release of the Streamline CLI
Tools. The following changes have be been made since the 9.2.0 release:

* **Feature:** Improved quality of tooling logging output.
* **Feature:** User guide now documents recommended application build settings.
* **Feature:** User guide now documents recommended profile runtime.
* **Fix:** Fix intermittent crash during analysis.
* **Fix:** Fix crash on systems with more than 96 cores.

# 3 Platform support

This release has been built against glibc 2.28. This supports the following
host operating systems running on an Arm AArch64 host machine:

* Amazon Linux 2023 or newer
* Debian 10 or newer
* RHEL 8 or newer
* Ubuntu 20.04 or newer

This release has been tested on the following Arm CPUs:

* Arm Neoverse N1
* Arm Neoverse N2
* Arm Neoverse V1
