/**
 * Copyright (C) 2006-2023 by Arm Limited (or its affiliates). All rights reserved.
 * Use, modification and redistribution of this file is subject to your possession of a
 * valid End User License Agreement for the Arm Product of which these examples are part of
 * and your compliance with all applicable terms and conditions of such license agreement.
 */
/*
 * This file contains the main() program that sets the vector table location, displays a welcome message,
 * initializes the MPU, starts the SysTick timer, initializes the Process Stack Pointer, changes Thread mode
 * to Unprivileged and to use the Process Stack, then runs the main application
 */

#include "scs.h"
#include "timer.h"
#include "intrinsics.h"
#include "sorts.h"
#include "barman.h"
#include "barman-example.h"


#include <stdio.h>
#include <stdarg.h>

#define VectorTableOffsetRegister MEMORY_MAPPED_REGISTER_32(0xE000ED08)

extern unsigned int Image$$VECTORS$$Base;
extern unsigned int Image$$PROCESS_STACK$$ZI$$Limit;


int main(void)
{
    /* Processor starts-up in Privileged Thread Mode using Main Stack */

    /* Tell the processor the location of the vector table, obtained from the scatter file */
    VectorTableOffsetRegister = (unsigned int) &Image$$VECTORS$$Base;

    /* Initialize MPU */
    SCS_init();

    /* Initialize SysTick Timer */
    SysTick_init();

    /* Initialize barman */
    initBarman();

    /* Initialize Process Stack Pointer */
    MSR(PSP, (unsigned int) &Image$$PROCESS_STACK$$ZI$$Limit);

    /* Change Thread mode to Unprivileged and to use the Process Stack */
    unsigned int ctrl;
    MRS(CONTROL, ctrl);
    MSR(CONTROL, ctrl | 3);

    /* Flush and refill pipeline with unprivileged permissions */
    asm ("isb sy");

    compare_sorts();

    while (1)
    {
        asm ("wfi");
    }
}
