/**
 * Copyright (C) 2017-2023 by Arm Limited (or its affiliates). All rights reserved.
 * Use, modification and redistribution of this file is subject to your possession of a
 * valid End User License Agreement for the Arm Product of which these examples are part of
 * and your compliance with all applicable terms and conditions of such license agreement.
 */
#ifndef INCLUDE_BARMAN_EXAMPLE_H
#define INCLUDE_BARMAN_EXAMPLE_H

/*
 * Initialize barman and start sampling.
 *
 * Must be called in privileged mode.
 */
void initBarman(void);

enum task_id
{
    TASK_ID_INIT,
    TASK_ID_INSERTION_SORT,
    TASK_ID_SHELL_SORT,
    TASK_ID_QUICK_SORT,
    TASK_ID_INTERRUPT
};

/*
 * Record task switch
 */
void switchTask(enum task_id);

/*
 * Get the current task id
 */
enum task_id getTaskId();

#endif
