/**
* Copyright (C) 2016-2023 by Arm Limited (or its affiliates). All rights reserved.
* Use, modification and redistribution of this file is subject to your possession of a
* valid End User License Agreement for the Arm Product of which these examples are part of 
* and your compliance with all applicable terms and conditions of such license agreement.
*/
/* Device specific functions */

#include "psci.h"

    .text

    .global mpidr_to_core_number
    .type mpidr_to_core_number, "function"
mpidr_to_core_number:
    ubfx x1, x0, #8, #8
    ubfx x0, x0, #0, #8
    cmp x1, #0
    b.eq 1f
    add x0, x0, #2
1:
    ret

    .global mpidr_to_cluster_number
    .type mpidr_to_cluster_number, "function"
mpidr_to_cluster_number:
    ubfx x0, x0, #8, #8
    ret


#if 0 /* We are only going to use a single core for this example */
    .global wake_secondary_cores
    .type wake_secondary_cores, "function"
wake_secondary_cores:
    ldr x0, =PSCI_CPU_ON
    ldr x1, =0x0000 // core 0
    ldr x2, =start64
    ldr x3, =0
    smc #0

    ldr x0, =PSCI_CPU_ON
    ldr x1, =0x0001 // core 1
    ldr x2, =start64
    ldr x3, =0
    smc #0

    // core 2 should be already awake and running this code

    ldr x0, =PSCI_CPU_ON
    ldr x1, =0x0101 // core 3
    ldr x2, =start64
    ldr x3, =0
    smc #0

    ldr x0, =PSCI_CPU_ON
    ldr x1, =0x0102 // core 4
    ldr x2, =start64
    ldr x3, =0
    smc #0

    ldr x0, =PSCI_CPU_ON
    ldr x1, =0x0103 // core 5
    ldr x2, =start64
    ldr x3, =0
    smc #0

    ret
#endif
