/* Bare-metal example for ARMv8-A */

/* Timer and interrupts */
/**
 * Copyright (C) 2016-2023 by Arm Limited (or its affiliates). All rights reserved.
 * Use, modification and redistribution of this file is subject to your possession of a
 * valid End User License Agreement for the Arm Product of which these examples are part of
 * and your compliance with all applicable terms and conditions of such license agreement.
 */

#include <stdio.h>

#include "gic.h"
#include "v8_aarch64.h"
#include "barman_interrupt.h"

// --------------------------------------------------------

void el1IrqHandler(void)
{
  unsigned int ID;

  ID = ReadIAR();

  // Check for reserved IDs
  if ((1020 <= ID) && (ID <= 1023))
  {
      printf("Reserved INTID %d\n\n", ID);
      return;
  }

  switch(ID)
  {
    case 23:
      // PMU counter overflow
      break;

    case 30:
      // EL1 physical timer
      // Sample the PMU
      barmanInterruptHandler();
      break;

    default:
      // Unexpected ID value
      printf("Unexpected INTID %d\n\n", ID);
      break;
  }


  // Write the End of Interrupt register to tell the GIC
  // we've finished handling the interrupt
  WriteEOI(ID);
}
