// ------------------------------------------------------------
// AArch64 Generic Timer
//
// Copyright (C) 2017-2023 by Arm Limited (or its affiliates). All rights reserved.
// Use, modification and redistribution of this file is subject to your possession of a
// valid End User License Agreement for the Arm Product of which these examples are part of
// and your compliance with all applicable terms and conditions of such license agreement.
//

// ------------------------------------------------------------


#ifndef INCLUDE_GENERIC_TIMER_H
#define INCLUDE_GENERIC_TIMER_H

#include <stdint.h>
#include <stdbool.h>

/**
 * Gets the system counter frequency
 *
 * @return The frequency in Hz
 */
uint64_t getSystemCounterFrequency(void);

/**
 * Gets the system counter
 *
 * @return The value of the system counter
 */
uint64_t getSystemCounter(void);

/**
 * Sets the EL1 physical timer TimerValue
 *
 * @param value The TimerValue to set
 */
void setEl1PhysicalTimerTimerValue(int32_t value);

/**
 * Sets the EL1 physical timer enabled or disabled
 *
 * @param enable true to enable, false to disable
 */
void setEl1PhysicalTimerEnabled(bool enable);

/**
 * Sets the EL1 physical timer interrupt enabled or disabled
 *
 * @param enable true to enable, false to disable
 */
void setEl1PhysicalTimerInterruptEnabled(bool enable);

#endif
