/**
 * Copyright (C) 2016-2023 by Arm Limited (or its affiliates). All rights reserved.
 * Use, modification and redistribution of this file is subject to your possession of a
 * valid End User License Agreement for the Arm Product of which these examples are part of 
 * and your compliance with all applicable terms and conditions of such license agreement.
 */

/* Device specific functions */

    .text

    .global mpidr_to_core_number
    .type mpidr_to_core_number, "function"
mpidr_to_core_number:
    ubfx x1, x0, #8, #8
    ubfx x0, x0, #0, #8
    cmp x1, #0
    b.eq 1f
    add x0, x0, #2
1:
    ret

    .global mpidr_to_cluster_number
    .type mpidr_to_cluster_number, "function"
mpidr_to_cluster_number:
    ubfx x0, x0, #8, #8
    ret
