/*** MEERKAT HELPER MODULE ***/

var MeerkatHelper;

/* Define a namespace for Meerkat specific helper functions */
(function MeerkatHelperModule() {

  /* Public collections of helper methods */
  var utilHelpers    = {}; // General useful functions

  /* milliseconds to 'mins:secs' format (2git  d.p. default) */
  utilHelpers.msToTime = function (ms, decimalPlaces=2) {
    var minutes = Math.floor(ms / 60000);
    var seconds = ((ms % 60000) / 1000).toFixed(decimalPlaces);
    return minutes + ":" + (seconds < 10 ? '0' : '') + parseFloat(seconds);
  }

  /* milliseconds to a frame range such as 'frame: 1' or 'frames: 2 - 3'*/
  utilHelpers.timeToFrameRange = function (ms, mapper) {
    // Due to double precision errors, index can become a decimal so round to whole number.
    var index = Math.round((ms - mapper.firstBinMs) / mapper.binSize);
    var startFrame = mapper.binFrameMarkers[index];
    // Note: binFrameMarkers length is 1 larger than number of bins so this is safe.
    var endFrame = mapper.binFrameMarkers[index + 1];
    if (endFrame > startFrame) {
      return "Frames: " + startFrame + " - " + endFrame;
    }
    return "Frame: " + startFrame;
  }

  /* Start/end milliseconds to a frame range such as 'frames: 2 - 3'*/
  utilHelpers.timesToFrameRange = function (startTime, endTime, mapper) {
    // Due to double precision errors, index can become a decimal so round to whole number.
    var index = Math.round((startTime - mapper.firstBinMs) / mapper.binSize);
    var startFrame = mapper.binFrameMarkers[index];

    index = Math.round((endTime - mapper.firstBinMs) / mapper.binSize);
    var endFrame = mapper.binFrameMarkers[index];
    // Note: binFrameMarkers length is 1 larger than number of bins so this is safe.
    var endFrame2 = mapper.binFrameMarkers[index + 1];
    if (endFrame2 > endFrame) {
      return startFrame + " - " + endFrame2;
    }
    return startFrame + " - " + endFrame;
  }

  utilHelpers.insertChartDiv = function (width, counter) {
    if (width) {
      return "<div id='graph" + counter + "' style='width:" + width + "%; float: left;'></div>";
    } else {
      return "<div id='graph" + counter + "'></div>";
    }
  }

  utilHelpers.insertChartDivWithLink = function (width, counter, linkTitle, linkId) {
    return "<div style='width:" + width + "%; float: left;'> \n" +
              "<div align=center>" +
                  "<a class='regionLink' title='" + linkTitle + "' href='" + linkId + "'>\n" +
                    "<b>" + linkTitle + "</b>\n" +
                  "</a>\n" +
              "</div>\n" +
              "</p>\n" +
              "<div id='graph" + counter + "'></div>\n" +
            "</div>\n";
  }

  utilHelpers.insertTitle = function (headingId, heading, content, description, image, counter) {
    if (!description) {
      return "<div id='" + headingId + "'><" + heading + ">"  + content + "</" + heading + "></div>";
    } else {
      return "<div id='" + headingId + "' style='position: relative; overflow: auto; clear: left;'><" + heading + " style='float:left;'>"
      + content + "</" + heading + ">" + `<img src="` + image + `" width="18" height="18"
      class="toggleImage" title="Click for more information" onclick="ToggleVisibility('toggle` + counter
      + `'); return false;"/></div><div id="headingToggle` + headingCounter + `" class="toggle` + counter + `" style="display: none; clear: both;">`
      + description + `</div>`;
    }
  }

  utilHelpers.insertAdvice = function (adviceCounter, content, link, className) {
    return "<ul class='messages'><li id='advice" + adviceCounter + "' class='" + className + "' style='display: flex;'><span class='text'>"
      + content + (link ? (" Read our <a href='" + link
      + "' target='_blank'>optimization advice.</a>") : ("")) + "</span></li></ul>"
  }

  // Create global MeerkatHelper object with all helper submodules
  MeerkatHelper = {
    Util:   utilHelpers
  }

})();

