Branding directory
==================

You are in `com.arm.mgd.ui/resources/branding`.

This directory contains derived branding images. These derived images are
generated from master images held in the subdirectories here. Each subdirectory
represents a different brand.


Choosing a brand
----------------

A brand may be selected either implicitly or explicitly:

 - Implicitly: If the environment variable `MGD_SUITE` is *not* set then
   the default Mobile Studio (`arm-ms`) brand will be used.

 - Explicitly: If the environment variable `MGD_SUITE` is set to the name of
   a specific studio then the relevant brand sub-directory will be used.

Note: If an image is not present in a brand subdirectory it will automatically
fall back to the version in the default (`arm-ms`) directory.


Meanings of files in per-brand subdirectories
---------------------------------------------

 - `aga.icns`: Pre-built Mac icons. Note: This file is only present because it
   cannot be generated (from icon.png) under Windows or Linux.

 - icon.png: Main launcher icon

 - `side_banner.png`: Used in the Windows installer and the About box

 - `splash.png`: GUI splash screen

Each branding subdirectory has a further subdirectory called `originals`. This
contains versions of the above images as they were received from sources
external to the Graphics Analyzer development team.


How to update branding images
-----------------------------

There are currently two brands: `arm-ds` and `arm-mobile-studio`. You will need
a new version of `icon.png`, `side_banner.png` and `splash.png` for both these
brands – that is, six new files in total.

First, replace these six files with their new versions. If you have to make any
changes to the images you were given, put the original versions into the
"external" directory. In any case, remove files relating to the old branding
from the "external" directory.

Then, on a Mac, enter the following commands:
```
cd <repository-root>/com.arm.mgd.ui/resources/branding
MGD_SUITE=arm-ds rake branding:clean branding:create
cp aga.icns arm-ds
MGD_SUITE=arm-mobile-studio rake branding:clean branding:create
cp aga.icns arm-mobile-studio
```

This erases the pre-built "derived" images and rebuilds them.

Finally, check in your work and send it for review as normal.

On other platforms, this process won't update the Mac application icon because
the tool for this purpose (`iconutil`) isn't available. You should therefore
use a Mac to update the branding for all platforms.


Branding resources outside this directory
-----------------------------------------

The default brand to use, and various brand-related details such as the name
string of the product, are set in the top level `Rakefile`; to change these
please edit `../../../Rakefile.rb`

As a future simplification, it might be nice to bring these details into the
present branding directory.
