# Copyright (C) 2022-2023 by Arm Limited (or its affiliates). All rights reserved.

FIND_PROGRAM(CMAKE_ADDR2LINE NAMES "${CROSS_COMPILE}addr2line" REQUIRED)
FIND_PROGRAM(CMAKE_AR NAMES "${CROSS_COMPILE}gcc-ar" "${CROSS_COMPILE}ar" REQUIRED)
FIND_PROGRAM(CMAKE_LINKER NAMES "ld.bfd" "ld.gold" "ld" REQUIRED)
FIND_PROGRAM(CMAKE_NM NAMES "${CROSS_COMPILE}gcc-nm" "${CROSS_COMPILE}nm" REQUIRED)
FIND_PROGRAM(CMAKE_OBJCOPY NAMES "${CROSS_COMPILE}objcopy" REQUIRED)
FIND_PROGRAM(CMAKE_OBJDUMP NAMES "${CROSS_COMPILE}objdump" REQUIRED)
FIND_PROGRAM(CMAKE_RANLIB NAMES "${CROSS_COMPILE}gcc-ranlib" "${CROSS_COMPILE}ranlib" REQUIRED)
FIND_PROGRAM(CMAKE_READELF NAMES "${CROSS_COMPILE}readelf" REQUIRED)
FIND_PROGRAM(CMAKE_STRIP NAMES "${CROSS_COMPILE}strip" REQUIRED)
FIND_PROGRAM(CMAKE_GCOV NAMES "${CROSS_COMPILE}gcov" "gcov")

FIND_PROGRAM(CMAKE_C_COMPILER NAMES "${CROSS_COMPILE}gcc" REQUIRED)
FIND_PROGRAM(CMAKE_C_COMPILER_AR NAMES "${CROSS_COMPILE}gcc-ar")
FIND_PROGRAM(CMAKE_C_COMPILER_NM NAMES "${CROSS_COMPILE}gcc-nm")
FIND_PROGRAM(CMAKE_C_COMPILER_RANLIB NAMES "${CROSS_COMPILE}gcc-ranlib")
FIND_PROGRAM(CMAKE_CXX_COMPILER NAMES "${CROSS_COMPILE}g++" REQUIRED)
FIND_PROGRAM(CMAKE_CXX_COMPILER_AR NAMES "${CROSS_COMPILE}gcc-ar")
FIND_PROGRAM(CMAKE_CXX_COMPILER_NM NAMES "${CROSS_COMPILE}gcc-nm")
FIND_PROGRAM(CMAKE_CXX_COMPILER_RANLIB NAMES "${CROSS_COMPILE}gcc-ranlib")

# here is the target environment located
IF(_VCPKG_INSTALLED_DIR AND VCPKG_TARGET_TRIPLET)
  SET(CMAKE_FIND_ROOT_PATH "${_VCPKG_INSTALLED_DIR}/${VCPKG_TARGET_TRIPLET}")

  # adjust the default behaviour of the FIND_XXX() commands:
  # search headers and libraries in the target environment, search
  # programs in the host environment
  if(NOT VCPKG_REQUIRES_HOST_LIBRARIES)
    SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
    SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
    SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
    SET(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)
  endif()
ENDIF()

# Default standard
SET(CMAKE_CXX_STANDARD 17)
SET(CMAKE_CXX_STANDARD_REQUIRED ON)
