Streamline bare-metal profiling patch for U-Boot
================================================

An example showing how to modify the sources of [U-Boot](http://www.denx.de/wiki/U-Boot) so as to be able to instrument and profile the boot loader.

Purpose and scope
-----------------

This example demonstrates one way to modify U-Boot to allow it to be profiled using the barman bare-metal profiling agent. This example makes use of the GCC
function instrumentation option [-finstrument-functions](https://gcc.gnu.org/onlinedocs/gcc/Instrumentation-Options.html) in order to capture counters and hot
functions on function entry and exit.

This example is intended to show one possible way to modify the boot loader in order to profile it; it is not intended as a complete solution. In particular not
all parts of the boot loader are instrumented with `-finstrument-functions` and the user must configure the capture buffer at run time so it cannot be used to
profile the early initialisation of the boot loader in its current form.

The patch provided is based off of the [v2016.05 git tag](http://git.denx.de/?p=u-boot.git&a=commit&h=aeaec0e682f45b9e0c62c522fafea353931f73ed) and was tested
on an [INSIGNAL Arndale board](http://www.arndaleboard.org/wiki/index.php/Main_Page) using the default configuration; `make arndale_defconfig`. The changes to
U-Boot are, however, platform agnostic and are expected to work for any target board.

Building this example
---------------------

The following instructions detil how to download and apply the patch to the U-Boot git repository. They are expected to work on a recent Linux system. They
require the usual U-Boot build tools, git, and the
[Linaro soft-float Linux GCC 4.9 compiler](https://releases.linaro.org/15.02/components/toolchain/binaries/arm-linux-gnueabi/) to have been installed and be
available on the path.

1. Clone a copy of the U-Boot git repository, in this example the repository is cloned into the folder `u-boot`:
   `git clone git://git.denx.de/u-boot.git u-boot`
   `cd u-boot`
2. Checkout the `v2016.05` branch:
   `git checkout v2016.05`
3. Apply the `u-boot-instrumentation.patch` file:
   `git apply <EXAMPLE_PATH>/u-boot-instrumentation.patch`
4. Launch Streamline and use the bare-metal configuration wizard to generate the appropriate barman source files using the provided configuration file found
   in <U_BOOT_PATH>/libbarman/barman.xml.
   You should see there are now two additional files (`barman.c` and `barman.h`) found in `<U_BOOT_PATH>/libbarman/` that were not previously there.
4. Build U-Boot:
   `CROSS_COMPILE=arm-linux-gnueabi- make arndale_defconfig`
   `CROSS_COMPILE=arm-linux-gnueabi- make all`
5. Apply the modified SPL and U-Boot files:
   `dd if=spl/arndale-spl.bin of=<ARNDALE_BOOT_MMC_DEVICE> bs=512 seek=17`
   `dd if=u-boot.bin of=<ARNDALE_BOOT_MMC_DEVICE> bs=512 seek=49`

**For a different target, use the appropriate configuration and deployment method**

Running this example
--------------------

Once the boot loader has been correctly configured, built and deployed on target you should start the device, and run the boot loader to the U-Boot console.
For the Arndale board, this means connecting to the board via serial terminal, then escaping out of the automatic boot before the boot loader runs the default
boot option. From the U-Boot command line there are now four additional commands available:

* `barman_init <BASE> <LENGTH>` - this command is used to initialise sampling and to provide a memory buffer to the agent. For the Arndale board an appropriate
   value for `<BASE>` is `56000000` which is the *hex* address where the memory buffer will be located. In this example a useful value for `<LENGTH>` may be
   `100000` which is 1mb (again in *hex*).
* `barman_enable` - this enables sampling. Once this command completes, all instrumented functions within the boot loader will be sampled at entry and exit and
   the results will be stored in the memory buffer at address `0x56000000` that was previously configured.
   Enter `barman_enable` to enable sampling.
* `barman_disable` - this disables sampling. Once this command completes, no further samples will be stored until a subsequent call to `barman_enable`.
   **NB: ** This command should be called before the data is saved, particularly when using a circular buffer, otherwise it is possible the save command will be
   instrumented, overwriting and corrupting the capture buffer during the save.
* `barman_sample` - this command manually performs a sample.

The `save` command may then be used to store the barman capture to disk.

An example run on the Arndale board would be:

    barman_init 56000000 100000
    barman_enable
    fatload mmc 1:1 uImage
    barman_disable
    save mmc 1:1 56000000 barman.raw 100000

This example profiles the loading of a Linux kernel `uImage` from the FAT formatted first partition on the MMC, and saves the capture to the same partition in a
file named `barman.raw`.

Analyzing the capture in Streamline
-----------------------------------
1. Click the "Import Capture File(s)" button and find the previously saved capture file, in the above case it would be `barman.raw` on the MMC card.
2. Click the "Change analysis options and regenerate the report" button.
3. Optionally change the "Resolution mode" to "High" or "Ultra-High".
4. Click the "Add ELF image..." button and add `u-boot` file found at `<U_BOOT_PATH>/u-boot`; this is the unstripped ELF image of the boot loader that can be
   used for resolving symbols in the **Call Paths** and **Functions** views.
5. Now click "Analyze".

Barman related modifications to U-Boot
--------------------------------------

* `libbarman/barman.xml` is the agent configuration file containing defaults that will build and run out of the box on an Arndale board. For different target
   device different processor and counters should be selected.
* `cmd/barman.c` contains the additional commands that were added to the U-Boot command line, and show how to initialise, enable and sample using barman from
  within U-Boot.
