##
## Use the progess bar in the Scripting view to show progress for some dummy tasks:
##  - a slow task with a small amount of iterations
##  - a fast task with a large amount of iterations
##  - a task with with unknown length
##

# You can import the Python standard library into your MGD scripts.
import time

# First we set the task name and the amount of work to do.
# The "monitor" variable is automatically exported in the scripting console.
task_name = "Slow but small task"
monitor.set_task(task_name, 5)

for i in xrange(0, 5):
    time.sleep(0.5)
    print task_name + ", step: " + str(i)
    # Then each time we want to update the progress we call 'incProgress'.
    monitor.increment_progress(1)

# Another example with more increments.
task_name = "Fast but large task"
monitor.set_task(task_name, 50)
for i in xrange(0, 50):
    time.sleep(0.1)
    print task_name + ", step: " + str(i)
    monitor.increment_progress(1)

# We can use the special value '-1' as the task size to say that we don't know how long the task is.
task_name = "Task with unknown length"
monitor.set_task(task_name, -1)
time.sleep(3)

# Finally we say we are finished to make sure the progress is cleared from the UI.
monitor.finish()
