##
## Find the number of draw calls that use a particular OpenGL ES program.
##
## This script teaches the basics of reading OpenGL ES/EGL states.
##

from collections import defaultdict
import operator

# Iterate through all the processes in the trace.
# The "trace" variable is automatically exported in the scripting console when a trace is opened.
for process in trace.processes():

    print(str(process) + ":")

    # Crate a dictionary with default values of 0.
    program_frequency = defaultdict(lambda: 0)

    # Loop through all the functions and find the draw calls.
    for function_call in process.function_calls():
        if function_call.is_draw_call():

            # Get the currently used program and and increment the value in the dictionary.
            current_program = function_call.states()['GL_CURRENT_PROGRAM']
            program_frequency[current_program] += 1

# Sort the frequencies so the highest frequency is first in the list.
sorted_frequencies = sorted(program_frequency.items(), key=operator.itemgetter(1), reverse=True)

# Print out the frequencies.
for program_id, number_of_draw_calls in sorted_frequencies:
    print "\tProgram {0} used in {1} draw calls.".format(program_id, number_of_draw_calls)
