##
## Check if any OpenGL ES buffers contain the same data by hashing the contents
## of the buffers at a particular function call and seeing if there are any duplicates.
##

from collections import defaultdict
import hashlib

# Iterate through all the processes in the trace.
# The "trace" variable is automatically exported in the scripting console when a trace is opened.
for process in trace.processes():

    print(str(process) + ":")

    frames = process.frames()

    # Ask the user which frame they want to analyse.
    frame_number = raw_input("Which frame number do you want to analyse in " + str(process) + "?")

    # Make sure they've given a number and it's in range.
    if not frame_number.isdigit() or int(frame_number) >= len(frames):
        print "\tInvalid frame number (" + frame_number + ") chosen"
        continue

    print "\tAnalysing frame " + frame_number

    frame = frames[int(frame_number)]

    # Use the last function call in that frame.
    functions = frame.function_calls()
    if not functions:
        print "\tNo functions in the chosen frame"
        continue;

    final_function = frame.function_calls()[-1]

    # A map from hash to IDs.
    buffer_hashes = {}

    # Go through all the buffers at this point.
    for id, buffer in final_function.assets()['Buffers'].items():
        # Make sure the buffer actually has data.
        if not buffer.has_buffer_data():
            continue

        # Calculate the MD5 hash of the data.
        hash_object = hashlib.md5(bytes(buffer.buffer_data()))
        hash = hash_object.hexdigest()

        # If we've not seen this hash before create a new list of IDs.
        if hash not in buffer_hashes:
            buffer_hashes[hash] = []

        # Add the ID to the list of IDs that match this hash.
        buffer_hashes[hash].append(id)

    # If any of the hashes has more than one entry then those buffers are likely to be the same.
    duplicates_found = False
    for hash, ids in buffer_hashes.items():
        if len(ids) > 1:
            duplicates_found = True
            print "\tThe following buffers hash to the same value: " + str(ids)

    if not duplicates_found:
        print "\tNo duplicate buffers found"

    # It's possible (although unlikely) that two different sets of data produce the same hash.
    # So at this point you could use the python '==' operator on the buffer data to make sure they
    # are the exactly the same.

    print "\n"