/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.elfdwarf;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SectionRecord {
    private final long mAddress;
    private final long mSize;
    private final long mOffset;
    private final @NonNull String mName;
    private final @NonNull File mFile;
    private final boolean mIs64Bit;
    private final boolean mIsAlloc;
    private final boolean mIsExec;
    private final boolean mIsProgbits;
    private final @Nullable ByteBuffer mData;

    public SectionRecord(long l, long l2, long l3, @NonNull String string, @NonNull File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, byte @Nullable [] byArray) {
        this.mAddress = l;
        this.mSize = l3;
        this.mOffset = l2;
        this.mName = string;
        this.mFile = file;
        this.mIs64Bit = bl;
        this.mIsAlloc = bl2;
        this.mIsExec = bl3;
        this.mIsProgbits = bl4;
        if (byArray != null) {
            this.mData = ByteBuffer.wrap(byArray);
            this.mData.order(bl5 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        } else {
            this.mData = null;
        }
    }

    public long getAddress() {
        return this.mAddress;
    }

    public long getSize() {
        return this.mSize;
    }

    public long getFileOffset() {
        return this.mOffset;
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public @NonNull File getFile() {
        return this.mFile;
    }

    public boolean is64Bit() {
        return this.mIs64Bit;
    }

    public boolean isAlloc() {
        return this.mIsAlloc;
    }

    public boolean isExec() {
        return this.mIsExec;
    }

    public boolean isProgbits() {
        return this.mIsProgbits;
    }

    public @Nullable ByteBuffer data() {
        return this.mData;
    }

    public int getArmOrAArch64Opcode(long l) {
        if (this.mData == null) {
            return 0;
        }
        if (!this.match(l &= 0xFFFFFFFFFFFFFFFCL, 4L)) {
            return 0;
        }
        int n = (int)(l - this.getAddress());
        return this.mData.getInt(n);
    }

    public int getThumbOpcode(long l) {
        if (this.mData == null) {
            return 0;
        }
        if (!this.match(l &= 0xFFFFFFFFFFFFFFFEL, 2L)) {
            return 0;
        }
        int n = (int)((l & 0xFFFFFFFFL) - (this.getAddress() & 0xFFFFFFFFL));
        return this.mData.getShort(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        @NonNull SectionRecord sectionRecord = (SectionRecord)object;
        return this.mAddress == sectionRecord.mAddress && this.mSize == sectionRecord.mSize && this.mOffset == sectionRecord.mOffset && this.mName.equals(sectionRecord.mName) && this.mFile.equals(sectionRecord.mFile) && this.mIs64Bit == sectionRecord.mIs64Bit && this.mIsAlloc == sectionRecord.mIsAlloc && this.mIsExec == sectionRecord.mIsExec && this.mIsProgbits == sectionRecord.mIsProgbits;
    }

    public int hashCode() {
        return Objects.hash(this.mAddress);
    }

    public String toString() {
        return String.format("SectionRecord{vAddr=0x%x, size=%d, offset=%d, name=%s, file=%s, is64bit=%b, isAlloc=%b, isExec=%b, isProgbits=%b}", this.mAddress, this.mSize, this.mOffset, this.mName, this.mFile.getAbsolutePath(), this.mIs64Bit, this.mIsAlloc, this.mIsExec, this.mIsProgbits);
    }

    private boolean match(long l, long l2) {
        if (!this.mIs64Bit) {
            return l >= this.getAddress() && l + l2 - 1L < this.getAddress() + this.getSize();
        }
        return Long.compareUnsigned(l, this.getAddress()) >= 0 && Long.compareUnsigned(l + l2 - 1L, this.getAddress() + this.getSize()) < 0;
    }
}

