/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.dtsl.decoders.stm.stpprotocol;

import com.arm.debug.dtsl.decoders.stm.stpprotocol.NibbleData;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPDecodeException;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPNibbleQueue;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPPacket;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPTimestamp;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STPTimestampablePacket;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_C16;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_C8;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_D;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_FLAG;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_FREQ;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_GERR;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_M16;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_M8;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_MERR;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_NULL;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_TIME;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_TRIG;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_USER;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_VERSION;
import com.arm.debug.dtsl.decoders.stm.stpprotocol.STP_XSYNC;
import java.util.Arrays;

public class STPDecoder {
    private STPNibbleQueue stpData;
    private boolean waitingForSync;
    private byte[] packetData;
    private int nibbleCount;
    private static final int MAX_PACKET_LEN = 20;
    private STP_VERSION.STPV2VERSION stpTimestampFormat;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$arm$debug$dtsl$decoders$stm$stpprotocol$STPDecodeException$Cause;

    public STPDecoder(STPNibbleQueue nibbleQueue) {
        this.stpData = nibbleQueue;
        this.waitingForSync = true;
        this.packetData = new byte[20];
        this.nibbleCount = 0;
        this.stpTimestampFormat = STP_VERSION.STPV2VERSION.STPv2NAT;
    }

    public void reSync() {
        this.waitingForSync = true;
    }

    public void assumeSynced() {
        this.waitingForSync = false;
    }

    public void setTimestampFormat(STP_VERSION.STPV2VERSION stpTimestampFormat) {
        this.stpTimestampFormat = stpTimestampFormat;
    }

    public STPPacket getPacket() throws STPDecodeException {
        if (this.waitingForSync) {
            if (!this.findSync()) {
                return null;
            }
            this.waitingForSync = false;
        }
        long location = this.getNextBufferLocation();
        STPPacket packet = this.getNextPacket();
        if (packet != null) {
            packet.setBufferLocation(location);
        }
        return packet;
    }

    private byte getNextNibble() {
        try {
            byte d = this.stpData.getNibble();
            STPDecoder.setNibble(this.packetData, this.nibbleCount++, d);
            return d;
        }
        catch (IndexOutOfBoundsException e) {
            throw new STPDecodeException(STPDecodeException.Cause.OutOfData);
        }
    }

    private long getNextBufferLocation() {
        return this.stpData.getBufferLocation();
    }

    private static void setNibble(byte[] data, int nibbleIdx, byte nibble) {
        try {
            int idx = nibbleIdx / 2;
            data[idx] = (nibbleIdx & 1) == 0 ? (byte)(data[idx] & 0xF0 | (byte)(nibble & 0xF)) : (byte)(data[idx] & 0xF | (byte)(nibble << 4));
        }
        catch (IndexOutOfBoundsException e) {
            throw new STPDecodeException(STPDecodeException.Cause.InternalBufferOverflow);
        }
    }

    private boolean findSync() {
        int xFCount = 0;
        int dCount = this.stpData.length();
        while (dCount > 0) {
            byte d = this.stpData.getNibble();
            if (d == 15) {
                ++xFCount;
            } else {
                if (d == 0 && xFCount >= 21) {
                    return true;
                }
                xFCount = 0;
            }
            --dCount;
        }
        if (xFCount > 0) {
            int fNibbleCount = Math.min(21, xFCount);
            byte[] xFData = new byte[(fNibbleCount + 1) / 2];
            Arrays.fill(xFData, (byte)-1);
            this.stpData.prependData(xFData, fNibbleCount);
        }
        return false;
    }

    private void skipASYNC() {
        int xFCount = 0;
        int dCount = this.stpData.length();
        while (dCount > 0) {
            byte d = this.getNextNibble();
            if (d == 15) {
                if (++xFCount > 19) {
                    throw new STPDecodeException(STPDecodeException.Cause.BadAsyncPacket);
                }
            } else {
                if (d == 0) {
                    if (xFCount >= 19) {
                        return;
                    }
                    throw new STPDecodeException(STPDecodeException.Cause.BadAsyncPacket);
                }
                throw new STPDecodeException(STPDecodeException.Cause.BadAsyncPacket);
            }
            --dCount;
        }
        throw new STPDecodeException(STPDecodeException.Cause.OutOfData);
    }

    /*
     * Exception decompiling
     */
    private STPPacket getNextPacket() throws STPDecodeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [44[SWITCH], 60[CASE], 62[SWITCH], 78[CASE]], but top level block is 42[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte extractByte() {
        byte data = (byte)(this.getNextNibble() << 4);
        data = (byte)(data | (byte)(this.getNextNibble() & 0xF));
        return data;
    }

    private byte[] extractWord4() {
        byte[] data = new byte[]{this.getNextNibble()};
        return data;
    }

    private byte[] extractWord8() {
        byte[] data = new byte[]{this.extractByte()};
        return data;
    }

    private byte[] extractWord16() {
        byte[] data = new byte[2];
        data[1] = this.extractByte();
        data[0] = this.extractByte();
        return data;
    }

    private byte[] extractWord32() {
        byte[] data = new byte[4];
        data[3] = this.extractByte();
        data[2] = this.extractByte();
        data[1] = this.extractByte();
        data[0] = this.extractByte();
        return data;
    }

    private byte[] extractWord64() {
        byte[] data = new byte[8];
        data[7] = this.extractByte();
        data[6] = this.extractByte();
        data[5] = this.extractByte();
        data[4] = this.extractByte();
        data[3] = this.extractByte();
        data[2] = this.extractByte();
        data[1] = this.extractByte();
        data[0] = this.extractByte();
        return data;
    }

    private byte readWord8() {
        return this.extractByte();
    }

    private int readWord16() {
        int data = this.extractByte() << 8 & 0xFF00;
        return data |= this.extractByte() & 0xFF;
    }

    private int readWord32() {
        int data = this.readWord16() << 16;
        return data |= this.readWord16() & 0xFFFF;
    }

    private STPTimestamp extractTimestamp() throws STPDecodeException {
        byte[] ts = new byte[8];
        int tsNibbleLen = 0;
        if (this.stpTimestampFormat == STP_VERSION.STPV2VERSION.STPv1) {
            ts[0] = this.extractByte();
            tsNibbleLen = 2;
        } else {
            int[] nArray = new int[16];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 8;
            nArray[9] = 9;
            nArray[10] = 10;
            nArray[11] = 11;
            nArray[12] = 12;
            nArray[13] = 14;
            nArray[14] = 16;
            int[] tsLenEnc = nArray;
            tsNibbleLen = tsLenEnc[this.getNextNibble()];
            try {
                int nIDX = tsNibbleLen - 1;
                int nLen = tsNibbleLen;
                while (nLen-- > 0) {
                    STPDecoder.setNibble(ts, nIDX--, this.getNextNibble());
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new STPDecodeException(STPDecodeException.Cause.BadTimestamp);
            }
        }
        return new STPTimestamp(tsNibbleLen, ts);
    }

    private static STPPacket parseNULL() {
        return new STP_NULL();
    }

    private STPPacket parseM8() {
        return new STP_M8(this.readWord8());
    }

    private STPPacket parseMERR() {
        return new STP_MERR(this.readWord8());
    }

    private STPPacket parseC8() {
        return new STP_C8(this.readWord8());
    }

    private STPPacket parseD8() {
        return new STP_D(new NibbleData(2, this.extractWord8()), false);
    }

    private STPPacket parseD16() {
        return new STP_D(new NibbleData(4, this.extractWord16()), false);
    }

    private STPPacket parseD32() {
        return new STP_D(new NibbleData(8, this.extractWord32()), false);
    }

    private STPPacket parseD64() {
        return new STP_D(new NibbleData(16, this.extractWord64()), false);
    }

    private STPPacket parseD8MTS() {
        byte[] word8 = this.extractWord8();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(2, word8), true, ts);
    }

    private STPPacket parseD16MTS() {
        byte[] word16 = this.extractWord16();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(4, word16), true, ts);
    }

    private STPPacket parseD32MTS() {
        byte[] word32 = this.extractWord32();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(8, word32), true, ts);
    }

    private STPPacket parseD64MTS() {
        byte[] word64 = this.extractWord64();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(16, word64), true, ts);
    }

    private STPPacket parseD4() {
        byte[] word4 = this.extractWord4();
        return new STP_D(new NibbleData(1, word4), false);
    }

    private STPPacket parseD4MTS() {
        byte[] word4 = this.extractWord4();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(1, word4), true, ts);
    }

    private STPPacket parseFLAGTS() {
        STPTimestamp ts = this.extractTimestamp();
        return new STP_FLAG(ts);
    }

    private STPPacket parseVERSION() {
        byte version = this.getNextNibble();
        switch (version) {
            case 0: 
            case 1: {
                this.stpTimestampFormat = STP_VERSION.STPV2VERSION.STPv1;
                break;
            }
            case 2: {
                this.stpTimestampFormat = STP_VERSION.STPV2VERSION.STPv2NATDELTA;
                break;
            }
            case 3: {
                this.stpTimestampFormat = STP_VERSION.STPV2VERSION.STPv2NAT;
                break;
            }
            case 4: {
                this.stpTimestampFormat = STP_VERSION.STPV2VERSION.STPv2GRAY;
                break;
            }
            default: {
                throw new STPDecodeException(STPDecodeException.Cause.UnsupportedProtocolVersion);
            }
        }
        return new STP_VERSION(this.stpTimestampFormat);
    }

    private STPPacket parseNULLTS() {
        STPTimestamp ts = this.extractTimestamp();
        return new STP_NULL(ts);
    }

    private STPPacket parseUSER() {
        int nibbleCount = this.getNextNibble() + 1;
        byte[] data = new byte[(nibbleCount + 1) / 2];
        int idx = 0;
        int count = nibbleCount;
        while (count > 1) {
            data[idx++] = this.extractByte();
            count -= 2;
        }
        if (count > 0) {
            data[idx] = this.getNextNibble();
        }
        return new STP_USER(new NibbleData(nibbleCount, data));
    }

    private STPPacket parseUSERTS() {
        int nibbleCount = this.getNextNibble() + 1;
        byte[] data = new byte[(nibbleCount + 1) / 2];
        int idx = 0;
        int count = nibbleCount;
        while (count > 1) {
            data[idx++] = this.extractByte();
            count -= 2;
        }
        if (count > 0) {
            data[idx] = this.getNextNibble();
        }
        STPTimestamp ts = this.extractTimestamp();
        return new STP_USER(new NibbleData(nibbleCount, data), ts);
    }

    private STPPacket parseTIME() {
        byte clockDomain = this.getNextNibble();
        byte version = this.getNextNibble();
        STP_VERSION.STPV2VERSION stpVersion = switch (version) {
            case 3 -> STP_VERSION.STPV2VERSION.STPv2NAT;
            case 4 -> STP_VERSION.STPV2VERSION.STPv2GRAY;
            default -> throw new STPDecodeException(STPDecodeException.Cause.UnsupportedProtocolVersion);
        };
        STPTimestamp ts = this.extractTimestamp();
        return new STP_TIME(clockDomain, stpVersion, ts);
    }

    private STPPacket parseTIMETS() {
        STPTimestampablePacket timeTs = (STPTimestampablePacket)this.parseTIME();
        STPTimestamp ts = this.extractTimestamp();
        timeTs.setTimestamp(ts);
        return timeTs;
    }

    private STPPacket parseTRIG() {
        byte word8 = this.readWord8();
        return new STP_TRIG(word8);
    }

    private STPPacket parseTRIGTS() {
        byte word8 = this.readWord8();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_TRIG(word8, ts);
    }

    private STPPacket parseFREQ() {
        long frequency = (long)this.readWord32() & 0xFFFFFFFFL;
        return new STP_FREQ(frequency);
    }

    private STPPacket parseFREQTS() {
        long frequency = (long)this.readWord32() & 0xFFFFFFFFL;
        STPTimestamp ts = this.extractTimestamp();
        return new STP_FREQ(frequency, ts);
    }

    private STPPacket parseXSYNC() {
        byte word8 = this.readWord8();
        return new STP_XSYNC(word8);
    }

    private STPPacket parseXSYNCTS() {
        byte word8 = this.readWord8();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_XSYNC(word8, ts);
    }

    private STPPacket parseM16() {
        int word16 = this.readWord16();
        return new STP_M16(word16);
    }

    private STPPacket parseGERR() {
        byte word8 = this.readWord8();
        return new STP_GERR(word8);
    }

    private STPPacket parseC16() {
        int word16 = this.readWord16();
        return new STP_C16(word16);
    }

    private STPPacket parseD8TS() {
        byte[] word8 = this.extractWord8();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(2, word8), false, ts);
    }

    private STPPacket parseD16TS() {
        byte[] word16 = this.extractWord16();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(4, word16), false, ts);
    }

    private STPPacket parseD32TS() {
        byte[] word32 = this.extractWord32();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(8, word32), false, ts);
    }

    private STPPacket parseD64TS() {
        byte[] word64 = this.extractWord64();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(16, word64), false, ts);
    }

    private STPPacket parseD8M() {
        byte[] word8 = this.extractWord8();
        return new STP_D(new NibbleData(2, word8), true);
    }

    private STPPacket parseD16M() {
        byte[] word16 = this.extractWord16();
        return new STP_D(new NibbleData(4, word16), true);
    }

    private STPPacket parseD32M() {
        byte[] word32 = this.extractWord32();
        return new STP_D(new NibbleData(8, word32), true);
    }

    private STPPacket parseD64M() {
        byte[] word64 = this.extractWord64();
        return new STP_D(new NibbleData(16, word64), true);
    }

    private STPPacket parseD4TS() {
        byte[] word4 = this.extractWord4();
        STPTimestamp ts = this.extractTimestamp();
        return new STP_D(new NibbleData(1, word4), false, ts);
    }

    private STPPacket parseD4M() {
        byte[] word4 = this.extractWord4();
        return new STP_D(new NibbleData(1, word4), true);
    }

    private static STPPacket parseFLAG() {
        return new STP_FLAG();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$arm$debug$dtsl$decoders$stm$stpprotocol$STPDecodeException$Cause() {
        if ($SWITCH_TABLE$com$arm$debug$dtsl$decoders$stm$stpprotocol$STPDecodeException$Cause != null) {
            return $SWITCH_TABLE$com$arm$debug$dtsl$decoders$stm$stpprotocol$STPDecodeException$Cause;
        }
        int[] nArray = new int[STPDecodeException.Cause.values().length];
        try {
            nArray[STPDecodeException.Cause.BadAsyncPacket.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[STPDecodeException.Cause.BadTimestamp.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[STPDecodeException.Cause.InternalBufferOverflow.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[STPDecodeException.Cause.MalformedPacket.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[STPDecodeException.Cause.OutOfData.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[STPDecodeException.Cause.PacketTooLong.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[STPDecodeException.Cause.TimestampPriorToVersion.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[STPDecodeException.Cause.UnknownPacketType.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[STPDecodeException.Cause.UnsupportedProtocolVersion.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$arm$debug$dtsl$decoders$stm$stpprotocol$STPDecodeException$Cause = nArray;
        return nArray;
    }
}

