/*
 * Decompiled with CFR 0.152.
 */
package com.arm.coresight.ds5_trace_dump;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceStreamReader
implements Closeable {
    public static final int BUFFER_LENGTH = 655536;
    private final byte[] buffer;
    private int bufferLength;
    private int bufferOffset;
    private int currentFileIndex;
    private long currentFilePosition;
    private @Nullable FileInputStream currentFileStream;
    private long currentStreamPosition;
    private final @NonNull List<@NonNull File> files;
    private final long totalStreamLength;

    public TraceStreamReader(@NonNull List<@NonNull File> files) throws IOException {
        this.files = files;
        this.buffer = new byte[655536];
        this.bufferOffset = 0;
        this.bufferLength = 0;
        this.currentFileIndex = -1;
        this.currentFileStream = this.nextFile();
        this.totalStreamLength = files.stream().mapToLong(f -> f.length()).sum();
    }

    @Override
    public void close() throws IOException {
        this.currentFilePosition = -1L;
        this.currentStreamPosition = this.totalStreamLength;
        this.currentFileIndex = this.files.size();
        this.bufferLength = 0;
        this.bufferOffset = 0;
        FileInputStream prevFileStream = this.currentFileStream;
        if (prevFileStream != null) {
            this.currentFileStream = null;
            prevFileStream.close();
        }
    }

    public @Nullable File getCurrentFile() {
        int index = this.currentFileIndex;
        if (index < 0 || index >= this.files.size()) {
            return null;
        }
        return this.files.get(index);
    }

    public long getCurrentFilePosition() {
        return this.currentFilePosition + (long)this.bufferOffset;
    }

    public long getCurrentStreamPosition() {
        return this.currentStreamPosition + (long)this.bufferOffset;
    }

    public long getTotalStreamLength() {
        return this.totalStreamLength;
    }

    public byte next() throws IOException {
        if (this.bufferOffset >= this.bufferLength) {
            this.refillBuffer();
        }
        return this.buffer[this.bufferOffset++];
    }

    public int next(byte[] target) throws IOException {
        return this.next(target, target.length);
    }

    public int next(byte[] target, int length) throws IOException {
        int amountToReturn;
        assert (length <= target.length);
        if (this.bufferOffset >= this.bufferLength) {
            this.refillBuffer();
        }
        if ((amountToReturn = Math.min(this.bufferLength - this.bufferOffset, length)) > 0) {
            System.arraycopy(this.buffer, this.bufferOffset, target, 0, amountToReturn);
            this.bufferOffset += amountToReturn;
        }
        return amountToReturn;
    }

    private @Nullable FileInputStream nextFile() throws IOException {
        int nextFileIndex = this.currentFileIndex + 1;
        if (nextFileIndex >= this.files.size()) {
            this.currentFileStream = null;
            return null;
        }
        FileInputStream prevFileStream = this.currentFileStream;
        if (prevFileStream != null) {
            this.currentFileStream = null;
            prevFileStream.close();
        }
        File nextFile = this.files.get(nextFileIndex);
        this.currentFileStream = new FileInputStream(nextFile);
        this.currentFilePosition = 0L;
        this.currentFileIndex = nextFileIndex;
        return this.currentFileStream;
    }

    private void refillBuffer() throws IOException {
        assert (this.bufferOffset >= this.bufferLength);
        this.currentFilePosition += (long)this.bufferLength;
        this.currentStreamPosition += (long)this.bufferLength;
        this.bufferOffset = 0;
        this.bufferLength = 0;
        while (true) {
            FileInputStream fileStream;
            if ((fileStream = this.currentFileStream) == null) {
                throw new EOFException();
            }
            int amountRead = 0;
            while ((amountRead = fileStream.read(this.buffer)) == 0) {
            }
            if (amountRead > 0) {
                this.bufferLength = amountRead;
                return;
            }
            if (amountRead >= 0) continue;
            this.currentFileStream = this.nextFile();
        }
    }
}

