/*
 * Decompiled with CFR 0.152.
 */
package com.arm.armnn.timeline;

import com.arm.armnn.timeline.ITimelineConsumer;
import com.arm.armnn.timeline.InvalidStreamMetadataPacketException;
import com.arm.armnn.timeline.MissingStreamMetadataPacketException;
import com.arm.armnn.timeline.PacketInfo;
import com.arm.armnn.timeline.StreamMetadata;
import com.arm.armnn.timeline.TimelineDecoderException;
import java.io.Closeable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineDecoder
implements Closeable {
    public static final boolean INITIALIZED_LIBRARY;
    private static final int PAYLOAD_START = 8;
    private static final int PIPE_MAGIC = 1162433588;
    private static final int TIMELINE_DIRECTORY = 0x4000000;
    private static final int TIMELINE_MESSAGE = 0x4010000;
    private static final int STREAM_METADATA = 0;
    private final ITimelineConsumer mConsumer;
    private long mNativeDataPointer = 0L;
    private @Nullable StreamMetadata mStreamMetadata = null;

    public TimelineDecoder(@NonNull ITimelineConsumer consumer) {
        this.mConsumer = consumer;
    }

    public void consumePacket(byte @NonNull [] packet) {
        if (this.mStreamMetadata == null) {
            this.mStreamMetadata = TimelineDecoder.parseStreamMetadata(packet);
            assert (this.mStreamMetadata != null);
            this.mNativeDataPointer = TimelineDecoder.createNativeDecoder(this.mStreamMetadata.getEndiannessAsInt(), this.mStreamMetadata.getTimelineDirectoryPacketVersion(), this.mStreamMetadata.getTimelineDataPacketVersion());
            return;
        }
        if (this.mNativeDataPointer == 0L) {
            return;
        }
        try {
            ByteBuffer buffer = ByteBuffer.wrap(packet);
            buffer.order(this.mStreamMetadata.getEndianness());
            int type = buffer.getInt();
            switch (type) {
                case 0x4000000: {
                    TimelineDecoder.decodeTimelineDirectory(packet, this.mNativeDataPointer, this.mConsumer);
                    break;
                }
                case 0x4010000: {
                    TimelineDecoder.decodeTimelineData(packet, this.mNativeDataPointer, this.mConsumer);
                    break;
                }
                default: {
                    throw new TimelineDecoderException(String.format("Unrecognised packet type: 0x%08x", type));
                }
            }
        }
        catch (BufferUnderflowException e) {
            throw new TimelineDecoderException("Malformed ArmNN timeline packet", e);
        }
    }

    @Override
    public void close() {
        if (this.mNativeDataPointer != 0L) {
            TimelineDecoder.destroyNativeDecoder(this.mNativeDataPointer);
            this.mNativeDataPointer = 0L;
        }
    }

    private static native long createNativeDecoder(int var0, int var1, int var2);

    private static native void decodeTimelineDirectory(byte[] var0, long var1, ITimelineConsumer var3);

    private static native void decodeTimelineData(byte[] var0, long var1, ITimelineConsumer var3);

    private static native void destroyNativeDecoder(long var0);

    static StreamMetadata parseStreamMetadata(byte @NonNull [] array) {
        if (array.length <= 8) {
            throw new TimelineDecoderException("Expected more than 8 bytes for stream metadata packet");
        }
        try {
            ByteBuffer buf = ByteBuffer.wrap(array);
            int typeWord = buf.order(ByteOrder.LITTLE_ENDIAN).getInt(0);
            if (typeWord != 0) {
                throw new MissingStreamMetadataPacketException(typeWord);
            }
            if (buf.order(ByteOrder.LITTLE_ENDIAN).getInt(8) != 1162433588) {
                if (buf.order(ByteOrder.BIG_ENDIAN).getInt(8) == 1162433588) {
                    throw new InvalidStreamMetadataPacketException("Big-endian ArmNN streams currently unsupported");
                }
                throw new InvalidStreamMetadataPacketException("Malformed ArmNN stream metadata packet");
            }
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            int pid = TimelineDecoder.readPid(buf);
            int packetVersionTableOffset = TimelineDecoder.readPacketVersionTableOffset(buf);
            List<PacketInfo> table = TimelineDecoder.readPacketVersionTable(buf, packetVersionTableOffset);
            Optional<PacketInfo> timelineDirVersion = TimelineDecoder.findTimelineDirectoryPacketEntry(table);
            if (!timelineDirVersion.isPresent()) {
                throw new InvalidStreamMetadataPacketException("Detected no version information for a TimelineDirectory packet in Stream Metadata");
            }
            Optional<PacketInfo> timelineDataVersion = TimelineDecoder.findTimelineDataPacketEntry(table);
            if (!timelineDataVersion.isPresent()) {
                throw new InvalidStreamMetadataPacketException("Detected no version information for a TimelineMessage packet in Stream Metadata");
            }
            return new StreamMetadata(byteOrder, pid, timelineDirVersion.get().getVersion(), timelineDataVersion.get().getVersion());
        }
        catch (BufferUnderflowException e) {
            throw new InvalidStreamMetadataPacketException("Malformed ArmNN timeline packet", e);
        }
    }

    private static int byteOffset(int wordOffset) {
        return 8 + wordOffset * 4;
    }

    private static Optional<PacketInfo> findTimelineDirectoryPacketEntry(List<PacketInfo> versionsTable) {
        return versionsTable.stream().filter(info -> 0x4000000 == info.getFirstWord()).findFirst();
    }

    private static Optional<PacketInfo> findTimelineDataPacketEntry(List<PacketInfo> versionsTable) {
        return versionsTable.stream().filter(info -> 0x4010000 == info.getFirstWord()).findFirst();
    }

    private static int readPid(ByteBuffer buf) {
        return buf.getInt(TimelineDecoder.byteOffset(3));
    }

    private static int readPacketVersionTableOffset(ByteBuffer buf) {
        return buf.getInt(TimelineDecoder.byteOffset(8)) + 8;
    }

    private static List<PacketInfo> readPacketVersionTable(ByteBuffer buf, int offset) {
        int oldPosition = buf.position();
        buf.position(offset);
        int numEntries = buf.getInt() >> 16;
        ArrayList<PacketInfo> table = new ArrayList<PacketInfo>();
        for (int i = 0; i < numEntries; ++i) {
            int familyClassAndType = buf.getInt();
            int version = buf.getInt();
            table.add(new PacketInfo(familyClassAndType, version));
        }
        buf.position(oldPosition);
        return table;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean initialized = false;
        try {
            if (osName.contains("win")) {
                System.loadLibrary("libgcc_s_seh-1");
                System.loadLibrary("libjnitimelinedecoder");
            } else {
                System.loadLibrary("jnitimelinedecoder");
            }
            initialized = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            INITIALIZED_LIBRARY = initialized;
        }
    }
}

