/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.jni.apcdbgen;

import com.arm.streamline.jni.apcdbgen.AnalysisResult;
import com.arm.streamline.jni.apcdbgen.AnalysisResultCode;
import com.arm.streamline.jni.apcdbgen.ApcDbGenLib;
import com.arm.streamline.jni.apcdbgen.IProgressMonitor;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.NativeHandle;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;

public class ApcDbGenerator {
    private final @NonNull AtomicReference<NativeDbGeneratorHandle> activeHandle = new AtomicReference<Object>(null);
    private final @NonNull File apcDirectory;
    private final @NonNull String licenseEdition;
    private final @NonNull IProgressMonitor progressMonitor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ApcDbGenerator(@NonNull File file, @NonNull String string, @NonNull IProgressMonitor iProgressMonitor) {
        this.apcDirectory = file;
        this.licenseEdition = string;
        this.progressMonitor = iProgressMonitor;
    }

    public void cancel() {
        NativeDbGeneratorHandle nativeDbGeneratorHandle = this.activeHandle.get();
        if (nativeDbGeneratorHandle != null) {
            nativeDbGeneratorHandle.cancel();
        }
    }

    public @NonNull AnalysisResult generateDb() throws CodecException, IOException {
        try {
            NativeDbGeneratorHandle nativeDbGeneratorHandle = new NativeDbGeneratorHandle();
            try {
                this.activeHandle.set(nativeDbGeneratorHandle);
                int n = nativeDbGeneratorHandle.run(this.apcDirectory.getCanonicalPath(), this.licenseEdition, this.progressMonitor);
                if (!$assertionsDisabled && n < 0) {
                    throw new AssertionError((Object)("unexpected negative analysis result " + n));
                }
                AnalysisResult analysisResult = new AnalysisResult(AnalysisResultCode.fromInt(n));
                nativeDbGeneratorHandle.close();
                return analysisResult;
            }
            catch (Throwable throwable) {
                try {
                    nativeDbGeneratorHandle.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.activeHandle.set(null);
        }
    }

    static {
        boolean bl = $assertionsDisabled = !ApcDbGenerator.class.desiredAssertionStatus();
        if (!ApcDbGenLib.isLoaded) {
            throw new AssertionError((Object)"Failed to load apcdbgen JNI lib");
        }
    }

    private static class NativeDbGeneratorHandle
    implements AutoCloseable {
        private final @NonNull NativeHandle nativeHandle = new NativeHandle(NativeDbGeneratorHandle.createNativeGenerator(), NativeDbGeneratorHandle::destroyNativeGenerator);

        private static native long createNativeGenerator();

        private static native void destroyNativeGenerator(long var0);

        private static native void performCancel(long var0);

        private static native int performDbGeneration(long var0, String var2, String var3, IProgressMonitor var4) throws CodecException, IOException;

        public void cancel() {
            this.nativeHandle.doIf(NativeDbGeneratorHandle::performCancel);
        }

        @Override
        public void close() {
            try {
                this.cancel();
            }
            finally {
                this.nativeHandle.close();
            }
        }

        public int run(String string, String string2, IProgressMonitor iProgressMonitor) throws CodecException, IOException {
            return (Integer)this.nativeHandle.doWith(l -> NativeDbGeneratorHandle.performDbGeneration(l, string, string2, iProgressMonitor));
        }
    }
}

