/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.util;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.util.IFunctionCallContainer;
import com.arm.mgd.lightweight.util.IFunctionCallContainerView;
import com.arm.mgd.utils.NullUtils;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class FunctionCallContainerView
implements IFunctionCallContainerView {
    private static final int INDEX_UNKNOWN = -1;
    private final StartAndEndIndexes indexesManager;
    private final IFunctionCallContainer parentContainer;
    private final FunctionCallIDRange range;

    private static int indexOr(int index, int dflt) {
        return index != -1 ? index : dflt;
    }

    public FunctionCallContainerView(IFunctionCallContainer parentContainer, FunctionCallIDRange range) {
        this.parentContainer = parentContainer;
        this.range = range;
        this.indexesManager = new StartAndEndIndexes();
    }

    @Override
    public boolean containsFunctionCall(FunctionCall functionCall) {
        return this.containsFunctionCall(functionCall.getID());
    }

    @Override
    public boolean containsFunctionCall(FunctionCallID functionCall) {
        if (this.range.contains(functionCall)) {
            return this.parentContainer.containsFunctionCall(functionCall);
        }
        return false;
    }

    @Override
    public @Nullable FunctionCall findFirstFunctionCallAfter(FunctionCallID id) {
        FunctionCall result;
        if (id.compareTo(this.range.getFrom()) < 0) {
            id = this.range.getFrom().prev();
        }
        if ((result = this.parentContainer.findFirstFunctionCallAfter(id)) != null && this.range.contains(result.getID())) {
            return result;
        }
        return null;
    }

    @Override
    public @Nullable FunctionCall findFirstFunctionCallOnOrAfter(FunctionCallID id) {
        FunctionCall result;
        if (id.compareTo(this.range.getFrom()) < 0) {
            id = this.range.getFrom().prev();
        }
        if ((result = this.parentContainer.findFirstFunctionCallOnOrAfter(id)) != null && this.range.contains(result.getID())) {
            return result;
        }
        return null;
    }

    @Override
    public @Nullable FunctionCall findLastFunctionCallBefore(FunctionCallID id) {
        FunctionCall result;
        FunctionCallID rangeTo = this.range.getTo();
        if (rangeTo != null && id.compareTo(rangeTo) > 0) {
            id = rangeTo;
        }
        if ((result = this.parentContainer.findLastFunctionCallBefore(id)) != null && this.range.contains(result.getID())) {
            return result;
        }
        return null;
    }

    @Override
    public @Nullable FunctionCall findLastFunctionCallOnOrBefore(FunctionCallID id) {
        FunctionCall result;
        FunctionCallID rangeTo = this.range.getTo();
        if (rangeTo != null && id.compareTo(rangeTo) > 0) {
            id = rangeTo;
        }
        if ((result = this.parentContainer.findLastFunctionCallOnOrBefore(id)) != null && this.range.contains(result.getID())) {
            return result;
        }
        return null;
    }

    @Override
    public @NonNull List<@NonNull FunctionCall> getAllFunctionCalls() {
        Indexes indexes = this.indexesManager.findIndexBounds();
        return this.parentContainer.getSubList(indexes.startIndex, indexes.endIndex);
    }

    @Override
    public @Nullable FunctionCall getFunctionCall(FunctionCallID id) {
        if (this.range.contains(id)) {
            return this.parentContainer.getFunctionCall(id);
        }
        return null;
    }

    @Override
    public @NonNull FunctionCall getFunctionCall(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Indexes indexes = this.indexesManager.findIndexBounds();
        if ((index += indexes.startIndex) < indexes.endIndex) {
            return this.parentContainer.getFunctionCall(index);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getFunctionCallCount() {
        Indexes indexes = this.indexesManager.findIndexBounds();
        return indexes.endIndex - indexes.startIndex;
    }

    @Override
    public IFunctionCallContainer getParentContainer() {
        return this.parentContainer;
    }

    @Override
    public @NonNull List<@NonNull FunctionCall> getSubList(int listFrom, int listTo) {
        if (listFrom < 0 || listTo < listFrom) {
            throw new IndexOutOfBoundsException();
        }
        Indexes indexes = this.indexesManager.findIndexBounds();
        listFrom = indexes.startIndex + listFrom;
        listTo = indexes.startIndex + listTo;
        if (listFrom >= indexes.endIndex || listTo > indexes.endIndex) {
            throw new IndexOutOfBoundsException();
        }
        return this.getSubList(listFrom, listTo);
    }

    @Override
    public @NonNull IFunctionCallContainerView getViewByCallIdRange(FunctionCallIDRange subRange) {
        return new FunctionCallContainerView(this, this.range);
    }

    @Override
    public FunctionCallIDRange getViewRange() {
        return this.range;
    }

    @Override
    public int indexOf(FunctionCall call) {
        Indexes indexes = this.indexesManager.findIndexBounds();
        if (this.range.contains(call.getID())) {
            return this.parentContainer.indexOf(call) - indexes.startIndex;
        }
        return -1;
    }

    @Override
    public @NonNull Iterator<@NonNull FunctionCall> iterator() {
        final Indexes indexes = this.indexesManager.findIndexBounds();
        final int length = indexes.endIndex - indexes.startIndex;
        return new Iterator<FunctionCall>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < length;
            }

            @Override
            public @NonNull FunctionCall next() {
                if (this.hasNext()) {
                    return FunctionCallContainerView.this.parentContainer.getFunctionCall(indexes.startIndex + this.index++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public @NonNull ListIterator<@NonNull FunctionCall> listIterator() {
        final Indexes indexes = this.indexesManager.findIndexBounds();
        final int length = indexes.endIndex - indexes.startIndex;
        return new ListIterator<FunctionCall>(){
            private int index = 0;

            @Override
            public void add(FunctionCall e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index < length;
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0 && length > 0;
            }

            @Override
            public FunctionCall next() {
                try {
                    return FunctionCallContainerView.this.parentContainer.getFunctionCall(indexes.startIndex + this.index++);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public FunctionCall previous() {
                try {
                    return FunctionCallContainerView.this.parentContainer.getFunctionCall(indexes.startIndex + --this.index);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(FunctionCall e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static final class Indexes {
        public final int endIndex;
        public final int startIndex;

        public Indexes(int startIndex, int endIndex, int parentLength) {
            this.startIndex = FunctionCallContainerView.indexOr(startIndex, 0);
            this.endIndex = FunctionCallContainerView.indexOr(endIndex, parentLength);
        }
    }

    private class StartAndEndIndexes {
        private int endIndex = -1;
        private int parentLength = 0;
        private int startIndex = -1;

        public StartAndEndIndexes() {
            this.findIndexBounds();
        }

        public synchronized Indexes findIndexBounds() {
            int currentSize = FunctionCallContainerView.this.parentContainer.getFunctionCallCount();
            if (this.parentLength < currentSize) {
                if (this.startIndex == -1) {
                    FunctionCall startingCall = FunctionCallContainerView.this.parentContainer.getFunctionCall(FunctionCallContainerView.this.range.getFrom());
                    if (startingCall == null) {
                        startingCall = FunctionCallContainerView.this.parentContainer.findFirstFunctionCallAfter(FunctionCallContainerView.this.range.getFrom());
                        if (startingCall == null) {
                            return new Indexes(0, 0, 0);
                        }
                        if (!FunctionCallContainerView.this.range.contains(startingCall.getID())) {
                            this.startIndex = 0;
                            this.endIndex = 0;
                            return new Indexes(0, 0, 0);
                        }
                    }
                    this.startIndex = FunctionCallContainerView.this.parentContainer.indexOf(startingCall);
                    assert (this.startIndex >= 0);
                }
                if (this.startIndex != -1 && this.endIndex == -1 && FunctionCallContainerView.this.range.isClosedRange()) {
                    FunctionCall endingCall = FunctionCallContainerView.this.parentContainer.getFunctionCall((FunctionCallID)NullUtils.neverNull((Object)FunctionCallContainerView.this.range.getTo()));
                    if (endingCall == null) {
                        endingCall = FunctionCallContainerView.this.parentContainer.findLastFunctionCallBefore((FunctionCallID)NullUtils.neverNull((Object)FunctionCallContainerView.this.range.getTo()));
                    }
                    if (endingCall != null) {
                        this.endIndex = FunctionCallContainerView.this.parentContainer.indexOf(endingCall);
                        assert (this.endIndex >= 0);
                        assert (this.startIndex <= this.endIndex);
                    }
                }
            }
            return new Indexes(this.startIndex, this.endIndex, this.parentLength);
        }
    }
}

