/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.util;

import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.util.ICacheableByFunctionCall;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CacheValueByFunctionId<VALUE_TYPE extends ICacheableByFunctionCall> {
    private static final int CACHE_MAX_SIZE = 16;
    private final @NonNull LinkedList<@NonNull FunctionCallID> insertionOrder = new LinkedList();
    private final @NonNull NavigableMap<@NonNull FunctionCallID, SoftReference<VALUE_TYPE>> valueCache = new TreeMap<FunctionCallID, SoftReference<VALUE_TYPE>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull VALUE_TYPE cacheAndReturn(@NonNull VALUE_TYPE value) {
        FunctionCallID at = value.getValidFunctionCallRange().getFrom();
        NavigableMap<FunctionCallID, SoftReference<VALUE_TYPE>> navigableMap = this.valueCache;
        synchronized (navigableMap) {
            this.valueCache.put(at, new SoftReference<VALUE_TYPE>(value));
            this.moveToInsertionHead(at);
            assert (this.valueCache.size() == this.insertionOrder.size());
            int trimCounter = this.valueCache.size() - 16;
            if (trimCounter > 0) {
                Iterator<@NonNull E> iterator = this.insertionOrder.iterator();
                while (iterator.hasNext() && trimCounter-- > 0) {
                    FunctionCallID key = (FunctionCallID)iterator.next();
                    this.valueCache.remove(key);
                    iterator.remove();
                }
                assert (this.valueCache.size() == this.insertionOrder.size());
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable VALUE_TYPE findNearestBefore(@NonNull FunctionCallID at) {
        NavigableMap<FunctionCallID, SoftReference<VALUE_TYPE>> navigableMap = this.valueCache;
        synchronized (navigableMap) {
            Map.Entry<FunctionCallID, SoftReference<VALUE_TYPE>> entry;
            block6: {
                entry = this.valueCache.floorEntry(at);
                if (entry != null) break block6;
                return null;
            }
            @Nullable ICacheableByFunctionCall result = (ICacheableByFunctionCall)entry.getValue().get();
            if (result == null) {
                this.valueCache.remove(entry.getKey());
                this.insertionOrder.remove(entry.getKey());
                assert (this.valueCache.size() == this.insertionOrder.size());
            }
            return (VALUE_TYPE)result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull VALUE_TYPE update(@NonNull VALUE_TYPE value) {
        FunctionCallID at = value.getValidFunctionCallRange().getFrom();
        NavigableMap<FunctionCallID, SoftReference<VALUE_TYPE>> navigableMap = this.valueCache;
        synchronized (navigableMap) {
            if (!this.moveToInsertionHead(at)) {
                this.valueCache.put(at, new SoftReference<VALUE_TYPE>(value));
            }
            assert (this.valueCache.size() == this.insertionOrder.size());
        }
        return value;
    }

    private boolean moveToInsertionHead(@NonNull FunctionCallID at) {
        boolean removed = false;
        Iterator<@NonNull FunctionCallID> it = this.insertionOrder.descendingIterator();
        while (it.hasNext()) {
            if (!it.next().equals(at)) continue;
            it.remove();
            removed = true;
            break;
        }
        this.insertionOrder.add(at);
        return removed;
    }
}

