/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.util;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.BinarySearchList;
import com.arm.mgd.core.util.Neighbours;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.FunctionCallIDRange;
import com.arm.mgd.lightweight.util.FunctionCallContainerView;
import com.arm.mgd.lightweight.util.IFunctionCallContainer;
import com.arm.mgd.lightweight.util.IFunctionCallContainerView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractFunctionCallContainer
implements IFunctionCallContainer {
    protected final Object functionCallMutex = new Object();
    private final List<@NonNull FunctionCall> functionCalls = new ArrayList<FunctionCall>();

    protected AbstractFunctionCallContainer() {
    }

    @Override
    public boolean containsFunctionCall(FunctionCall functionCall) {
        return this.containsFunctionCall(functionCall.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsFunctionCall(FunctionCallID id) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            @Nullable FunctionCall result = BinarySearchList.usingComparator(this.functionCalls, fc -> fc.getID().compareTo(id));
            return result != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable FunctionCall findFirstFunctionCallAfter(FunctionCallID id) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            block7: {
                block6: {
                    if (!this.functionCalls.isEmpty()) break block6;
                    return null;
                }
                if (this.functionCalls.get(this.functionCalls.size() - 1).getID().compareTo(id) > 0) break block7;
                return null;
            }
            Neighbours<@Nullable FunctionCall> neighbours = BinarySearchList.findNeighbours(this.functionCalls, fc -> fc.getID().compareTo(id));
            FunctionCall after = neighbours.getAfter();
            assert (after == null || after != null && after.getID().compareTo(id) > 0);
            return after;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable FunctionCall findFirstFunctionCallOnOrAfter(FunctionCallID id) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            block8: {
                block7: {
                    if (!this.functionCalls.isEmpty()) break block7;
                    return null;
                }
                if (this.functionCalls.get(this.functionCalls.size() - 1).getID().compareTo(id) >= 0) break block8;
                return null;
            }
            Neighbours<@Nullable FunctionCall> neighbours = BinarySearchList.findNeighbours(this.functionCalls, fc -> fc.getID().compareTo(id));
            if (neighbours.getMatching() != null) {
                return neighbours.getMatching();
            }
            FunctionCall after = neighbours.getAfter();
            assert (after == null || after != null && after.getID().compareTo(id) > 0);
            return after;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable FunctionCall findLastFunctionCallBefore(@NonNull FunctionCallID id) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            block7: {
                block6: {
                    if (!this.functionCalls.isEmpty()) break block6;
                    return null;
                }
                if (this.functionCalls.get(0).getID().compareTo(id) < 0) break block7;
                return null;
            }
            Neighbours<@Nullable FunctionCall> neighbours = BinarySearchList.findNeighbours(this.functionCalls, fc -> fc.getID().compareTo(id));
            FunctionCall before = neighbours.getBefore();
            assert (before == null || before != null && before.getID().compareTo(id) < 0);
            return before;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable FunctionCall findLastFunctionCallOnOrBefore(FunctionCallID id) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            block8: {
                block7: {
                    if (!this.functionCalls.isEmpty()) break block7;
                    return null;
                }
                if (this.functionCalls.get(0).getID().compareTo(id) <= 0) break block8;
                return null;
            }
            Neighbours<FunctionCall> neighbours = BinarySearchList.findNeighbours(this.functionCalls, fc -> fc.getID().compareTo(id));
            if (neighbours.getMatching() != null) {
                return neighbours.getMatching();
            }
            FunctionCall before = neighbours.getBefore();
            assert (before == null || before != null && before.getID().compareTo(id) < 0);
            return before;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull List<@NonNull FunctionCall> getAllFunctionCalls() {
        Object object = this.functionCallMutex;
        synchronized (object) {
            return new ReadOnlySubList<FunctionCall>(this.functionCalls, 0, this.functionCalls.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable FunctionCall getFunctionCall(FunctionCallID id) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            return BinarySearchList.usingComparator(this.functionCalls, fc -> fc.getID().compareTo(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FunctionCall getFunctionCall(int index) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            return this.functionCalls.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFunctionCallCount() {
        Object object = this.functionCallMutex;
        synchronized (object) {
            return this.functionCalls.size();
        }
    }

    @Override
    public List<@NonNull FunctionCall> getSubList(int from, int to) {
        return new ReadOnlySubList<FunctionCall>(this.functionCalls, from, to);
    }

    @Override
    public IFunctionCallContainerView getViewByCallIdRange(FunctionCallIDRange range) {
        return new FunctionCallContainerView(this, range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(FunctionCall call) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            return BinarySearchList.getIndexUsingComparator(this.functionCalls, fc -> fc.compareTo(call));
        }
    }

    @Override
    public Iterator<FunctionCall> iterator() {
        return new Iterator<FunctionCall>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < AbstractFunctionCallContainer.this.getFunctionCallCount();
            }

            @Override
            public @NonNull FunctionCall next() {
                try {
                    return AbstractFunctionCallContainer.this.getFunctionCall(this.index++);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    @Override
    public @NonNull ListIterator<@NonNull FunctionCall> listIterator() {
        return new ListIterator<FunctionCall>(){
            private int index = 0;

            @Override
            public void add(FunctionCall e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.index < AbstractFunctionCallContainer.this.getFunctionCallCount();
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0 && AbstractFunctionCallContainer.this.getFunctionCallCount() > 0;
            }

            @Override
            public FunctionCall next() {
                try {
                    return AbstractFunctionCallContainer.this.getFunctionCall(this.index++);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public FunctionCall previous() {
                try {
                    return AbstractFunctionCallContainer.this.getFunctionCall(--this.index);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(FunctionCall e) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void addFunctionCall(FunctionCall functionCall) {
        if (this.functionCalls.size() > 0) {
            FunctionCall lastItem = this.functionCalls.get(this.functionCalls.size() - 1);
            if (lastItem.getID().equals(functionCall.getID())) {
                return;
            }
            if (lastItem.getID().compareTo(functionCall.getID()) >= 0) {
                throw new IndexOutOfBoundsException("FunctionCall index is out of bounds with regards to the last FunctionCall seen (" + lastItem.getID() + " vs " + functionCall.getID());
            }
        }
        this.functionCalls.add(functionCall);
    }
}

