/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.value;

import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RGBAStateItemValue
extends AbstractStateItemValue<RGBA> {
    public RGBAStateItemValue(@NonNull IStateItem<RGBAStateItemValue> owner, float r, float g, float b, float a) {
        this(owner, new RGBA(r, g, b, a));
    }

    public RGBAStateItemValue(@NonNull IStateItem<RGBAStateItemValue> owner, RGBA ... values) {
        super(owner);
        int i = 0;
        while (i < values.length) {
            this.updateValue(i, values[i]);
            ++i;
        }
    }

    @Override
    public long getValueAsLong() {
        assert (false) : "Not a valid conversion from RGBA -> long";
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValue(@NonNull FunctionCall functionCall, @NonNull Float r, @NonNull Float g, @NonNull Float b, @NonNull Float a) {
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            this.updateValue(0, new RGBA(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable FloatsArgAttachment attachment) {
        if (attachment != null) {
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                assert (attachment.size() % 4 == 0);
                int count = attachment.size() / 4;
                int i = 0;
                while (i < count) {
                    int j = i * 4;
                    this.updateValue(i, new RGBA(attachment.getFloat(j + 0), attachment.getFloat(j + 1), attachment.getFloat(j + 2), attachment.getFloat(j + 3)));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable LongsArgAttachment attachment) {
        if (attachment != null) {
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                assert (attachment.size() % 4 == 0);
                int count = attachment.size() / 4;
                int i = 0;
                while (i < count) {
                    int j = i * 4;
                    this.updateValue(i, new RGBA(attachment.get(j + 0).floatValue(), attachment.get(j + 1).floatValue(), attachment.get(j + 2).floatValue(), attachment.get(j + 3).floatValue()));
                    ++i;
                }
            }
        }
    }

    @Override
    protected @Nullable RGBA getDefaultValue() {
        return new RGBA(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public <E> @NonNull E accept( @NonNull IStateItemValue.IStateItemValueVisitor<E> visitor) {
        return visitor.visit(this);
    }

    public static class RGBA {
        public final float a;
        public final float b;
        public final float g;
        public final float r;

        public RGBA(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public String toString() {
            return (String)NullUtils.neverNull((Object)String.format("{r: %s, g: %s, b: %s, a: %s}", (int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f), (int)(this.a * 255.0f)));
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof RGBA) {
                RGBA that = (RGBA)obj;
                return this.a == that.a && this.b == that.b && this.g == that.g && this.r == that.r;
            }
            return false;
        }

        public int hashCode() {
            return Float.hashCode(this.r) ^ Float.hashCode(this.g) ^ Float.hashCode(this.b) ^ Float.hashCode(this.a);
        }
    }
}

