/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.value;

import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class IntegerStateItemValue
extends AbstractStateItemValue<Long> {
    public IntegerStateItemValue(@NonNull IStateItem<IntegerStateItemValue> owner, long ... values) {
        super(owner);
        int i = 0;
        while (i < values.length) {
            this.updateValue(i, NullUtils.longValueOf((long)values[i]));
            ++i;
        }
    }

    @Override
    public long getValueAsLong() {
        Long value = (Long)this.getValue();
        return value != null ? value : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @NonNull Float value) {
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            this.updateValue(0, NullUtils.longValueOf((long)value.longValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable FloatsArgAttachment attachment) {
        if (attachment != null) {
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, NullUtils.longValueOf((long)attachment.get(i).longValue()));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, Integer ... integers) {
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            int i = 0;
            while (i < integers.length) {
                this.updateValue(i, NullUtils.longValueOf((long)integers[i].longValue()));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable LongsArgAttachment attachment) {
        if (attachment != null) {
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, attachment.get(i));
                    ++i;
                }
            }
        }
    }

    @Override
    protected @Nullable Long getDefaultValue() {
        return 0L;
    }

    @Override
    public <E> @NonNull E accept( @NonNull IStateItemValue.IStateItemValueVisitor<E> visitor) {
        return visitor.visit(this);
    }
}

