/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.value;

import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FloatStateItemValue
extends AbstractStateItemValue<Float> {
    public FloatStateItemValue(@NonNull IStateItem<FloatStateItemValue> owner, float ... values) {
        super(owner);
        int i = 0;
        while (i < values.length) {
            this.updateValue(i, NullUtils.floatValueOf((float)values[i]));
            ++i;
        }
    }

    @Override
    public long getValueAsLong() {
        Float value = (Float)this.getValue();
        return value != null ? value.longValue() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, Float ... floats) {
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            int i = 0;
            while (i < floats.length) {
                this.updateValue(i, floats[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable FloatsArgAttachment attachment) {
        if (attachment != null) {
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, attachment.get(i));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable LongsArgAttachment attachment) {
        if (attachment != null) {
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, NullUtils.floatValueOf((float)attachment.get(i).floatValue()));
                    ++i;
                }
            }
        }
    }

    @Override
    protected @Nullable Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public <E> @NonNull E accept( @NonNull IStateItemValue.IStateItemValueVisitor<E> visitor) {
        return visitor.visit(this);
    }
}

