/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.value;

import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import com.arm.mgd.lightweight.state.IStateItemWithEnumAssetMappedValue;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EnumAssetStateItemValue<T extends IAssetItem<?, ?>>
extends AbstractStateItemValue<AbstractConstantOrAliasSpecExtended>
implements IStateItemValueWithAssetValue<T, AbstractConstantOrAliasSpecExtended> {
    private final @NonNull Class<? super T> assetClass;
    private final @NonNull BiFunction<@NonNull FunctionCall, @NonNull AssetItemID, @Nullable T> assetProvider;

    public EnumAssetStateItemValue(@NonNull Class<? super T> assetClass, @NonNull IStateItemWithEnumAssetMappedValue<T> owner, @NonNull BiFunction<@NonNull FunctionCall, @NonNull AssetItemID, @Nullable T> assetProvider, AbstractConstantOrAliasSpecExtended ... values) {
        super(owner);
        this.assetClass = assetClass;
        this.assetProvider = assetProvider;
        assert (values.length <= 1);
        int i = 0;
        while (i < values.length) {
            this.updateValue(i, values[i]);
            ++i;
        }
    }

    @Override
    public void ensureAssetObjectIsValidAt(FunctionCallID at) {
        FunctionCall lastAffectingFunctionCall = this.getLastAffectingFunctionCall();
        assert (lastAffectingFunctionCall == null || lastAffectingFunctionCall.getID().compareTo(at) <= 0);
        assert (this.values.size() <= 1);
        AbstractConstantOrAliasSpecExtended constant = (AbstractConstantOrAliasSpecExtended)this.getValue();
        if (constant != null) {
            AssetItemID id = ((IStateItemWithEnumAssetMappedValue)this.parent).convertEnumToAssetItemID(constant);
            @Nullable T assetObject = this.getAssetValue();
            if (!id.equals(AssetItemID.ZERO)) {
                if (assetObject == null) {
                    if (lastAffectingFunctionCall != null) {
                        this.updateValue(lastAffectingFunctionCall, this.getDefaultValue());
                    } else {
                        this.updateValue(this.parent.getParentContainer().getCreatingFunction(), this.getDefaultValue());
                    }
                } else if (!assetObject.getLifecycleManager().isAssetRetained(at)) {
                    this.updateValue(assetObject.getLifecycleManager().getReleasingFunction(), this.getDefaultValue());
                }
            }
        }
    }

    @Override
    public Class<? super T> getAssetClass() {
        return this.assetClass;
    }

    @Override
    public @Nullable T getAssetValue() {
        AbstractConstantOrAliasSpecExtended constant;
        FunctionCall lastAffectingFunctionCall = this.getLastAffectingFunctionCall();
        if (lastAffectingFunctionCall == null) {
            lastAffectingFunctionCall = this.parent.getParentContainer().getCreatingFunction();
        }
        if ((constant = (AbstractConstantOrAliasSpecExtended)this.getValue()) == null) {
            return null;
        }
        AssetItemID idValue = ((IStateItemWithEnumAssetMappedValue)this.parent).convertEnumToAssetItemID(constant);
        return (T)((IAssetItem)this.assetProvider.apply(lastAffectingFunctionCall, idValue));
    }

    @Override
    public @Nullable AssetItemID getValueAsAssetItemID() {
        AbstractConstantOrAliasSpecExtended constant = (AbstractConstantOrAliasSpecExtended)this.getValue();
        if (constant == null) {
            return null;
        }
        return ((IStateItemWithEnumAssetMappedValue)this.parent).convertEnumToAssetItemID(constant);
    }

    @Override
    public long getValueAsLong() {
        AssetItemID id = this.getValueAsAssetItemID();
        return id != null ? id.asLong() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable FloatsArgAttachment attachment) {
        if (attachment != null) {
            assert (attachment.size() <= 1);
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, this.parent.getKapiSpec().getConstantSpecByValue(NullUtils.longValueOf((long)attachment.get(i).longValue())));
                    ++i;
                }
            }
        }
    }

    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable AbstractConstantOrAliasSpecExtended value) {
        assert (value != null);
        super.updateValue(functionCall, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, long ... constants) {
        assert (constants.length <= 1);
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            int i = 0;
            while (i < constants.length) {
                this.updateValue(i, this.parent.getKapiSpec().getConstantSpecByValue(NullUtils.longValueOf((long)constants[i])));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @NonNull Long constant) {
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            this.updateValue(0, this.parent.getKapiSpec().getConstantSpecByValue(constant));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable LongsArgAttachment attachment) {
        if (attachment != null) {
            assert (attachment.size() <= 1);
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, this.parent.getKapiSpec().getConstantSpecByValue(attachment.get(i)));
                    ++i;
                }
            }
        }
    }

    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable T assetObject) {
        if (assetObject == null) {
            this.updateValue(functionCall, this.getDefaultValue());
        } else {
            this.updateValue(functionCall, ((IStateItemWithEnumAssetMappedValue)this.parent).convertAssetItemIDToEnum(assetObject.getId()));
        }
    }

    @Override
    protected @NonNull AbstractConstantOrAliasSpecExtended getDefaultValue() {
        return ((IStateItemWithEnumAssetMappedValue)this.parent).getDefaultEnumValue();
    }

    @Override
    protected void updateValue(int index, @Nullable AbstractConstantOrAliasSpecExtended value) {
        assert (value != null);
        super.updateValue(index, value);
    }

    @Override
    public <E> @NonNull E accept( @NonNull IStateItemValue.IStateItemValueVisitor<E> visitor) {
        return visitor.visit(this);
    }
}

