/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.value;

import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BooleanStateItemValue
extends AbstractStateItemValue<Boolean> {
    private static @NonNull Boolean mapConstantValue(@NonNull AbstractConstantOrAliasSpecExtended constant) {
        return NullUtils.booleanValueOf((constant.getResolvedValue() != 0L ? 1 : 0) != 0);
    }

    public BooleanStateItemValue(@NonNull IStateItem<BooleanStateItemValue> owner, AbstractConstantOrAliasSpecExtended ... constants) {
        super(owner);
        int i = 0;
        while (i < constants.length) {
            this.updateValue(i, BooleanStateItemValue.mapConstantValue(constants[i]));
            ++i;
        }
    }

    @Override
    public long getValueAsLong() {
        assert (false) : "Not a valid conversion from boolean -> long";
        Boolean value = (Boolean)this.getValue();
        return value != null && value != false ? 1L : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable FloatsArgAttachment attachment) {
        if (attachment != null) {
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, NullUtils.booleanValueOf((attachment.getFloat(i) != 0.0f ? 1 : 0) != 0));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, AbstractConstantOrAliasSpecExtended ... constants) {
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            int i = 0;
            while (i < constants.length) {
                this.updateValue(i, BooleanStateItemValue.mapConstantValue(constants[i]));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable LongsArgAttachment attachment) {
        if (attachment != null) {
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, NullUtils.booleanValueOf((attachment.getLong(i) != 0L ? 1 : 0) != 0));
                    ++i;
                }
            }
        }
    }

    @Override
    protected @NonNull Boolean getDefaultValue() {
        return NullUtils.FALSE;
    }

    @Override
    public <E> @NonNull E accept( @NonNull IStateItemValue.IStateItemValueVisitor<E> visitor) {
        return visitor.visit(this);
    }
}

