/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.value;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemValue;
import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AssetStateItemValue<T extends IAssetItem<?, ?>>
extends AbstractStateItemValue<AssetItemID>
implements IStateItemValueWithAssetValue<T, AssetItemID> {
    private final @NonNull Class<? super T> assetClass;
    private final @NonNull BiFunction<@NonNull FunctionCall, @NonNull AssetItemID, @Nullable T> assetProvider;

    public AssetStateItemValue(@NonNull Class<? super T> assetClass, @NonNull IStateItem<AssetStateItemValue<T>> owner, @NonNull BiFunction<@NonNull FunctionCall, @NonNull AssetItemID, @Nullable T> assetProvider, long ... values) {
        super(owner);
        this.assetClass = assetClass;
        this.assetProvider = assetProvider;
        assert (values.length <= 1);
        int i = 0;
        while (i < values.length) {
            this.updateValue(i, AssetItemID.valueOf(values[i]));
            ++i;
        }
    }

    @Override
    public void ensureAssetObjectIsValidAt(FunctionCallID at) {
        FunctionCall lastAffectingFunctionCall = this.getLastAffectingFunctionCall();
        assert (lastAffectingFunctionCall == null || lastAffectingFunctionCall.getID().compareTo(at) <= 0);
        assert (this.values.size() <= 1);
        AssetItemID id = (AssetItemID)this.getValue();
        @Nullable T assetObject = this.getAssetValue();
        if (id != null && !id.equals(AssetItemID.ZERO)) {
            if (assetObject == null) {
                if (lastAffectingFunctionCall != null) {
                    this.updateValue(lastAffectingFunctionCall, this.getDefaultValue());
                } else {
                    this.updateValue(this.parent.getParentContainer().getCreatingFunction(), this.getDefaultValue());
                }
            } else if (!assetObject.getLifecycleManager().isAssetRetained(at)) {
                this.updateValue(assetObject.getLifecycleManager().getReleasingFunction(), this.getDefaultValue());
            }
        }
    }

    @Override
    public Class<? super T> getAssetClass() {
        return this.assetClass;
    }

    @Override
    public @Nullable T getAssetValue() {
        AssetItemID idValue;
        FunctionCall lastAffectingFunctionCall = this.getLastAffectingFunctionCall();
        if (lastAffectingFunctionCall == null) {
            lastAffectingFunctionCall = this.parent.getParentContainer().getCreatingFunction();
        }
        if ((idValue = (AssetItemID)this.getValue()) == null) {
            return null;
        }
        return (T)((IAssetItem)this.assetProvider.apply(lastAffectingFunctionCall, idValue));
    }

    @Override
    public @Nullable AssetItemID getValueAsAssetItemID() {
        return (AssetItemID)this.getValue();
    }

    @Override
    public long getValueAsLong() {
        AssetItemID value = (AssetItemID)this.getValue();
        return value != null ? value.asLong() : 0L;
    }

    @Override
    public void updateValue(FunctionCall functionCall, @Nullable AssetItemID value) {
        assert (value != null);
        super.updateValue(functionCall, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable FloatsArgAttachment attachment) {
        if (attachment != null) {
            assert (attachment.size() <= 1);
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, AssetItemID.valueOf(attachment.get(i).longValue()));
                    ++i;
                }
            }
        }
    }

    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @NonNull AbstractConstantOrAliasSpecExtended eglNoXXX) {
        assert (eglNoXXX == KapiSpec.EGL.constants.EGL_NO_DISPLAY || eglNoXXX == KapiSpec.EGL.constants.EGL_NO_SURFACE || eglNoXXX == KapiSpec.EGL.constants.EGL_NO_CONTEXT || eglNoXXX.getResolvedValue() == 0L);
        this.updateValue(functionCall, AssetItemID.ZERO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, long ... ids) {
        assert (ids.length <= 1);
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            int i = 0;
            while (i < ids.length) {
                this.updateValue(i, AssetItemID.valueOf(ids[i]));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @NonNull Long id) {
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            this.updateValue(0, AssetItemID.valueOf(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable LongsArgAttachment attachment) {
        if (attachment != null) {
            assert (attachment.size() <= 1);
            List list = this.values;
            synchronized (list) {
                this.updateValidCallRange(functionCall);
                int i = 0;
                while (i < attachment.size()) {
                    this.updateValue(i, AssetItemID.valueOf(attachment.get(i)));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateValue(@NonNull FunctionCall functionCall, Pointer ... ids) {
        assert (ids.length <= 1);
        List list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            int i = 0;
            while (i < ids.length) {
                this.updateValue(i, AssetItemID.valueOf(ids[i]));
                ++i;
            }
        }
    }

    @Override
    public void updateValue(@NonNull FunctionCall functionCall, @Nullable T assetObject) {
        if (assetObject == null) {
            this.updateValue(functionCall, this.getDefaultValue());
        } else {
            this.updateValue(functionCall, assetObject.getId());
        }
    }

    @Override
    protected @NonNull AssetItemID getDefaultValue() {
        return AssetItemID.ZERO;
    }

    @Override
    protected void updateValue(int index, @Nullable AssetItemID value) {
        assert (value != null);
        super.updateValue(index, value);
    }

    @Override
    public <E> @NonNull E accept( @NonNull IStateItemValue.IStateItemValueVisitor<E> visitor) {
        return visitor.visit(this);
    }
}

