/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.internal;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.lightweight.state.StateItemValueFormatter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractStateItemValue<T>
implements IStateItemValue<T> {
    protected final @NonNull IStateItem<? extends IStateItemValue<T>> parent;
    protected final @NonNull List<@Nullable T> values;
    private @Nullable FunctionCall lastAffectingFunctionCall;
    private @NonNull ClosedFunctionCallIDRange validFunctionCallRange;

    protected AbstractStateItemValue(@NonNull IStateItem<? extends IStateItemValue<T>> parent) {
        FunctionCall firstAffectingCall = parent.getFunctionCallCount() > 0 ? parent.getFunctionCall(0) : null;
        FunctionCallID defaultValidCallRangeEnd = firstAffectingCall != null ? firstAffectingCall.getID() : FunctionCallID.valueOf(0);
        this.parent = parent;
        this.values = new ArrayList<T>();
        this.validFunctionCallRange = new ClosedFunctionCallIDRange(FunctionCallID.valueOf(0), defaultValidCallRangeEnd);
        this.ensureValuesLength();
    }

    public void extendRange(@NonNull ClosedFunctionCallIDRange newRange) {
        assert (newRange.getFrom().equals(this.validFunctionCallRange.getFrom()));
        this.validFunctionCallRange = newRange;
    }

    @Override
    public IStateItem<? extends IStateItemValue<T>> getParent() {
        return this.parent;
    }

    @Override
    public ClosedFunctionCallIDRange getValidFunctionCallRange() {
        return this.validFunctionCallRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable T getValue() {
        List<T> list = this.values;
        synchronized (list) {
            if (this.values.isEmpty()) {
                return this.getDefaultValue();
            }
            return this.values.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull List<@Nullable T> getValues() {
        List<T> list = this.values;
        synchronized (list) {
            this.ensureValuesLength();
            return new ReadOnlySubList<T>(this.values, 0, this.values.size());
        }
    }

    @Override
    public boolean hasAffectingFunctions() {
        return this.lastAffectingFunctionCall != null;
    }

    @Override
    public boolean isDefaultValue() {
        IStateItemValue<T> defaultValue = this.parent.getDefaultValue();
        List<@Nullable T> defaultValueList = defaultValue.getValues();
        List<@Nullable T> ourValues = this.getValues();
        return defaultValueList.equals(ourValues);
    }

    public String toString() {
        return StateItemValueFormatter.format(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValue(@NonNull FunctionCall functionCall, @NonNull T value) {
        List<T> list = this.values;
        synchronized (list) {
            this.updateValidCallRange(functionCall);
            this.updateValue(0, value);
        }
    }

    protected abstract @Nullable T getDefaultValue();

    protected @Nullable FunctionCall getLastAffectingFunctionCall() {
        return this.lastAffectingFunctionCall;
    }

    protected void updateValidCallRange(@NonNull FunctionCall functionCall) {
        FunctionCall lastProcessedCall;
        this.lastAffectingFunctionCall = functionCall;
        FunctionCall firstCallAfter = this.parent.findFirstFunctionCallAfter(functionCall.getID());
        this.validFunctionCallRange = firstCallAfter != null ? new ClosedFunctionCallIDRange(functionCall.getID(), firstCallAfter.getID()) : ((lastProcessedCall = this.parent.getParentContainer().getLastProcessedFunctionCall()) != null && lastProcessedCall.compareTo(functionCall) > 0 ? new ClosedFunctionCallIDRange(functionCall.getID(), lastProcessedCall.getID().next()) : new ClosedFunctionCallIDRange(functionCall.getID(), functionCall.getID().next()));
    }

    protected void updateValue(int index, @NonNull T value) {
        int cardinality = this.parent.getCardinality();
        assert (index >= 0 && (index < cardinality || cardinality == 0));
        int targetSize = Math.max(index, cardinality);
        while (targetSize > this.values.size()) {
            this.values.add(this.getDefaultValue());
        }
        this.values.set(index, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureValuesLength() {
        List<T> list = this.values;
        synchronized (list) {
            int cardinality = this.parent.getCardinality();
            while (cardinality > this.values.size()) {
                this.values.add(this.getDefaultValue());
            }
        }
    }
}

