/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.internal;

import com.arm.mgd.core.target.data.CompletableProgressFuture;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.state.IStateItemBase;
import com.arm.mgd.lightweight.state.IStateItemContainer;
import com.arm.mgd.lightweight.state.IStateItemValue;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractStateItemContainer
implements IStateItemContainer {
    @Override
    public @NonNull CompletableProgressFuture<@Nullable Map<@NonNull IStateItemBase, @NonNull List<@NonNull IStateItemValue<?>>>> getAllStateItemValues(Executor executor, FunctionCall functionCall) {
        return CompletableProgressFuture.supplyAsync(executor, progressMonitor -> this.waitForAllStateItemValues((ICoreProgressMonitor)progressMonitor, functionCall));
    }

    @Override
    public @Nullable Map<@NonNull IStateItemBase, @NonNull List<@NonNull IStateItemValue<?>>> waitForAllStateItemValues(ICoreProgressMonitor progressMonitor, FunctionCall functionCall) {
        TreeMap<@NonNull IStateItemBase, @NonNull List<@NonNull IStateItemValue<?>>> result = new TreeMap();
        FunctionCallID callID = functionCall.getID();
        for (IStateItemBase stateItem : this.getBothIndexedAndNormalStateItems()) {
            if (progressMonitor.isCancelled()) {
                return null;
            }
            @Nullable List<@NonNull IStateItemValue<?>> values = stateItem.waitForAllValues(progressMonitor, callID);
            if (values == null) continue;
            result.put(stateItem, values);
        }
        return progressMonitor.isCancelled() ? null : result;
    }
}

