/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.internal;

import com.arm.mgd.core.kapi.IConstantOrAliasSpecContainer;
import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.target.data.CompletableProgressFuture;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.BinarySearchList;
import com.arm.mgd.core.util.ComparatorUtils;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.Neighbours;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.lightweight.ClosedFunctionCallIDRange;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.state.IIndexedStateItem;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemBase;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.lightweight.state.IStateItemValueWithAssetValue;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemValue;
import com.arm.mgd.lightweight.state.value.IntegerStateItemValue;
import com.arm.mgd.lightweight.util.AbstractFunctionCallContainer;
import com.arm.mgd.lightweight.util.CacheValueByFunctionId;
import com.arm.mgd.lightweight.util.FunctionCallContainer;
import com.arm.mgd.lightweight.util.IFunctionCallContainer;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractStateItem<T extends IStateItemValue<?>>
extends AbstractFunctionCallContainer
implements IStateItem<T> {
    private final @NonNull ICardinalityProvider cardinality;
    private int indexOfLastCallExaminedForModifyingFunctionCalls;
    private final @NonNull Map<FunctionCallID, MidstreamStateItem> midstreamStateChanges;
    private final @NonNull FunctionCallContainer modifyingFunctionCalls;
    private final @NonNull StateSpec stateSpec;
    private final @NonNull CacheValueByFunctionId<T> valueCache;

    protected AbstractStateItem(@NonNull StateSpec stateSpec, int cardinality) {
        this.stateSpec = stateSpec;
        this.cardinality = new ConstantCardinality(cardinality);
        this.valueCache = new CacheValueByFunctionId();
        this.midstreamStateChanges = new HashMap<FunctionCallID, MidstreamStateItem>();
        this.modifyingFunctionCalls = new FunctionCallContainer();
        this.indexOfLastCallExaminedForModifyingFunctionCalls = -1;
    }

    protected AbstractStateItem(@NonNull StateSpec stateSpec, @NonNull IStateItem<IntegerStateItemValue> cardinalityRef) {
        this.stateSpec = stateSpec;
        this.cardinality = new StateItemCardinality(cardinalityRef);
        this.valueCache = new CacheValueByFunctionId();
        this.midstreamStateChanges = new HashMap<FunctionCallID, MidstreamStateItem>();
        this.modifyingFunctionCalls = new FunctionCallContainer();
        this.indexOfLastCallExaminedForModifyingFunctionCalls = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFunctionCall(@NonNull FunctionCall functionCall) {
        Object object = this.functionCallMutex;
        synchronized (object) {
            super.addFunctionCall(functionCall);
            this.midstreamStateChanges.remove(functionCall.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMidstreamUpdate(@NonNull FunctionCall functionCall, @NonNull MidstreamStateItem stateUpdate) {
        assert (stateUpdate.getStateId().equals(this.stateSpec.getId())) : "Mismatched state ids: " + stateUpdate.getStateId() + " in " + this.stateSpec.getId();
        Object object = this.functionCallMutex;
        synchronized (object) {
            assert (!this.containsFunctionCall(functionCall)) : "Should not contain function call at this point as midstream trace item is done before call processing";
            if (this.getFunctionCallCount() == 0) {
                Object value = this.getDefaultValue();
                this.applyMidstreamStateValue(functionCall, value, stateUpdate);
                if (this.comparePreviousAndUpdatedValues(this.getDefaultValue(), value)) {
                    return;
                }
            } else {
                T previousValue = this.waitForValue(functionCall.getID().prev());
                Object updatedValue = this.getDefaultValue();
                this.applyMidstreamStateValue(functionCall, updatedValue, stateUpdate);
                if (this.comparePreviousAndUpdatedValues(previousValue, updatedValue)) {
                    return;
                }
            }
            this.midstreamStateChanges.put(functionCall.getID(), stateUpdate);
            super.addFunctionCall(functionCall);
        }
    }

    @Override
    public int compareTo(@NonNull IStateItemBase o) {
        int nameComparison = this.getStateSpec().getName().compareTo(o.getStateSpec().getName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        if (o instanceof IIndexedStateItem) {
            return -1;
        }
        return 0;
    }

    @Override
    public @Nullable FunctionCall findLastAffectingCallBefore(@NonNull FunctionCall functionCall) {
        return this.findLastFunctionCallBefore(functionCall.getID());
    }

    @Override
    public @Nullable FunctionCall findNextAffectingCallAfter(@NonNull FunctionCall functionCall) {
        return this.findFirstFunctionCallAfter(functionCall.getID());
    }

    @Override
    public int getCardinality() {
        return this.cardinality.getCardinality();
    }

    @Override
    public @NonNull StateSpec getStateSpec() {
        return this.stateSpec;
    }

    @Override
    public @NonNull CompletableProgressFuture<@NonNull T> getValue(@NonNull Executor executor, final @NonNull FunctionCallID at) {
        return (CompletableProgressFuture)NullUtils.neverNull(CompletableProgressFuture.supplyAsync(executor, new Function<ICoreProgressMonitor, T>(){

            @Override
            public @NonNull T apply(@NonNull ICoreProgressMonitor progressMonitor) {
                try {
                    return AbstractStateItem.this.waitForValue(progressMonitor, at);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    @Override
    public boolean isAffectedBy(@NonNull FunctionCall functionCall) {
        return this.containsFunctionCall(functionCall);
    }

    @Override
    public boolean isForPName(@NonNull AbstractConstantOrAliasSpecExtended byConstant) {
        return this.stateSpec.getName().equals(byConstant.getName());
    }

    @Override
    public @Nullable List<@NonNull IStateItemValue<?>> waitForAllValues(@NonNull ICoreProgressMonitor progressMonitor, @NonNull FunctionCallID at) {
        ArrayList<@NonNull IStateItemValue<?>> result = new ArrayList();
        result.add((IStateItemValue<?>)this.waitForValue(progressMonitor, at));
        return progressMonitor.isCancelled() ? null : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull IFunctionCallContainer waitForListOfModifyingFunctionCalls() {
        int functionCallCount = this.getFunctionCallCount();
        if (functionCallCount > 0 && this.indexOfLastCallExaminedForModifyingFunctionCalls + 1 < functionCallCount) {
            FunctionCallContainer functionCallContainer = this.modifyingFunctionCalls;
            synchronized (functionCallContainer) {
                Object previousValue = this.getDefaultValue();
                if (this.indexOfLastCallExaminedForModifyingFunctionCalls >= 0) {
                    this.processFunctionCallValue(this.getFunctionCall(this.indexOfLastCallExaminedForModifyingFunctionCalls), previousValue);
                }
                int i = this.indexOfLastCallExaminedForModifyingFunctionCalls + 1;
                while (i < functionCallCount) {
                    Object currentValue;
                    FunctionCall functionCall = this.getFunctionCall(i);
                    if (this.processFunctionCallValue(functionCall, currentValue = this.getDefaultValue())) {
                        if (!currentValue.getValues().equals(previousValue.getValues())) {
                            this.modifyingFunctionCalls.addFunctionCall(functionCall);
                            this.indexOfLastCallExaminedForModifyingFunctionCalls = i;
                        }
                        previousValue = currentValue;
                    }
                    ++i;
                }
            }
        }
        return this.modifyingFunctionCalls;
    }

    @Override
    public @NonNull T waitForValue(@NonNull FunctionCallID at) {
        return this.waitForValue(ICoreProgressMonitor.NULL_MONITOR, at);
    }

    @Override
    public @NonNull T waitForValue(@NonNull ICoreProgressMonitor progressMonitor, @NonNull FunctionCallID at) {
        if (this.isValueCachable()) {
            @Nullable IStateItemValue result = (IStateItemValue)this.valueCache.findNearestBefore(at);
            if (result != null) {
                ClosedFunctionCallIDRange actualRange;
                ClosedFunctionCallIDRange validRange = result.getValidFunctionCallRange();
                FunctionCallID nextAfterAt = validRange.getFrom().equals(at) ? at.next() : at;
                FunctionCallID lowerOrAtAndRangeEnd = nextAfterAt.compareTo(validRange.getTo()) <= 0 ? nextAfterAt : validRange.getTo();
                FunctionCall nextCallAfterRangeEnd = this.findFirstFunctionCallOnOrAfter(lowerOrAtAndRangeEnd);
                if (nextCallAfterRangeEnd != null) {
                    actualRange = new ClosedFunctionCallIDRange(validRange.getFrom(), nextCallAfterRangeEnd.getID());
                } else {
                    FunctionCall lastProcessedCall = this.getParentContainer().getLastProcessedFunctionCall();
                    if (lastProcessedCall != null) {
                        FunctionCallID lastID = lastProcessedCall.getID();
                        if (at.compareTo(lastID) > 0) {
                            return (T)result;
                        }
                        actualRange = lastID.compareTo(validRange.getTo()) >= 0 ? new ClosedFunctionCallIDRange(validRange.getFrom(), lastID.next()) : validRange;
                    } else {
                        actualRange = validRange;
                    }
                }
                if (actualRange.contains(at)) {
                    assert (result instanceof AbstractStateItemValue);
                    ((AbstractStateItemValue)result).extendRange(actualRange);
                    return (T)this.valueCache.update(result);
                }
            }
            return (T)((IStateItemValue)this.valueCache.cacheAndReturn(this.executeValueProcessor(progressMonitor, at)));
        }
        return this.executeValueProcessor(progressMonitor, at);
    }

    protected abstract void applyMidstreamStateValue(@NonNull FunctionCall var1, @NonNull T var2, @NonNull MidstreamStateItem var3);

    protected @NonNull IConstantOrAliasSpecContainer getIConstantOrAliasSpecContainer() {
        UsageSpec usage = this.stateSpec.getUsage();
        if (usage != null) {
            return usage;
        }
        return this.getKapiSpec();
    }

    protected boolean handleNonProcessedFunctionCall(boolean matching, @NonNull FunctionCall functionCall, @NonNull T value) {
        assert (!matching) : "Call item not processed " + functionCall + " @ " + functionCall.getID() + " in " + this.getStateSpec().getId();
        return false;
    }

    protected boolean isValueCachable() {
        return this.getFunctionCallCount() > 0;
    }

    protected abstract boolean processFunctionCallValue(@NonNull FunctionCall var1, @NonNull T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyMidstreamStateChange(@NonNull FunctionCall functionCall, @NonNull T result) {
        MidstreamStateItem midstreamItem;
        Object object = this.functionCallMutex;
        synchronized (object) {
            midstreamItem = this.midstreamStateChanges.get(functionCall.getID());
        }
        if (midstreamItem != null) {
            this.applyMidstreamStateValue(functionCall, result, midstreamItem);
            return true;
        }
        return false;
    }

    private boolean comparePreviousAndUpdatedValues(@NonNull T previousValue, @NonNull T updatedValue) {
        if (updatedValue instanceof IStateItemValueWithAssetValue) {
            Object newAsset;
            IStateItemValueWithAssetValue previousAssetValue = (IStateItemValueWithAssetValue)previousValue;
            IStateItemValueWithAssetValue newAssetValue = (IStateItemValueWithAssetValue)updatedValue;
            Object prevAsset = previousAssetValue.getAssetValue();
            if (ComparatorUtils.equalNullables(prevAsset, newAsset = newAssetValue.getAssetValue())) {
                return true;
            }
        } else if (updatedValue.getValues().equals(previousValue.getValues())) {
            return true;
        }
        return false;
    }

    private @NonNull T executeValueProcessor(@NonNull ICoreProgressMonitor progressMonitor, final @NonNull FunctionCallID at) {
        FunctionCall before;
        progressMonitor.setTask("Get " + this.getStateSpec().getName() + " state value at " + at, 1);
        Neighbours<@Nullable FunctionCall> neighbours = BinarySearchList.findNeighbours(this.getAllFunctionCalls(), new BinarySearchList.Comparator<FunctionCall>(){

            @Override
            public int compare(@NonNull FunctionCall that) {
                return that.getID().compareTo(at);
            }
        });
        Object result = this.getDefaultValue();
        FunctionCall matching = neighbours.getMatching();
        boolean processed = false;
        if (matching != null) {
            processed = this.tryProcessFunctionCall(result, matching, true);
        }
        if (!processed && (before = neighbours.getBefore()) != null) {
            processed = this.tryProcessFunctionCall(result, before, false);
        }
        if (result instanceof IStateItemValueWithAssetValue) {
            ((IStateItemValueWithAssetValue)result).ensureAssetObjectIsValidAt(at);
        }
        progressMonitor.incProgress(1);
        return result;
    }

    private boolean tryProcessFunctionCall(@NonNull T result, @NonNull FunctionCall functionCall, boolean matching) {
        boolean processed = this.applyMidstreamStateChange(functionCall, result);
        if (!processed) {
            processed = this.processFunctionCallValue(functionCall, result);
        }
        if (!processed) {
            processed = this.handleNonProcessedFunctionCall(matching, functionCall, result);
        }
        return processed;
    }

    private static class ConstantCardinality
    implements ICardinalityProvider {
        private final int cardinality;

        public ConstantCardinality(int cardinality) {
            this.cardinality = cardinality;
        }

        @Override
        public int getCardinality() {
            return this.cardinality;
        }
    }

    private static interface ICardinalityProvider {
        public int getCardinality();
    }

    private static class StateItemCardinality
    implements ICardinalityProvider {
        private final @NonNull IStateItem<IntegerStateItemValue> sourceStateItem;

        public StateItemCardinality(@NonNull IStateItem<IntegerStateItemValue> sourceStateItem) {
            this.sourceStateItem = sourceStateItem;
        }

        @Override
        public int getCardinality() {
            int functionCallCount = this.sourceStateItem.getFunctionCallCount();
            if (functionCallCount == 0) {
                return ((Long)NullUtils.neverNull((Object)((Long)this.sourceStateItem.getDefaultValue().getValue()))).intValue();
            }
            FunctionCall functionCall = this.sourceStateItem.getFunctionCall(functionCallCount - 1);
            IntegerStateItemValue value = this.sourceStateItem.waitForValue(functionCall.getID());
            return ((Long)NullUtils.neverNull((Object)((Long)value.getValue()))).intValue();
        }
    }
}

