/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.internal;

import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.lightweight.FunctionCallID;
import com.arm.mgd.lightweight.state.IIndexedStateItem;
import com.arm.mgd.lightweight.state.IIndexedStateItemChild;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemBase;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.lightweight.state.value.IntegerStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class AbstractIndexedStateItem<T extends IStateItemValue<?>>
implements IIndexedStateItem<T> {
    private final IIndexCountProvider indexCount;
    private int maxAllocatedIndex;
    private final Map<@NonNull Integer, @NonNull IIndexedStateItemChild<T>> memberStateItems;
    private final StateSpec stateSpec;

    protected AbstractIndexedStateItem(StateSpec stateSpec, int indexCount) {
        this.stateSpec = stateSpec;
        this.indexCount = new ConstantIndexCount(indexCount);
        this.memberStateItems = new TreeMap<Integer, IIndexedStateItemChild<T>>();
        this.maxAllocatedIndex = 0;
    }

    protected AbstractIndexedStateItem(StateSpec stateSpec, IStateItem<IntegerStateItemValue> indexCountRef) {
        this.stateSpec = stateSpec;
        this.indexCount = new StateItemIndexCount(indexCountRef);
        this.memberStateItems = new TreeMap<Integer, IIndexedStateItemChild<T>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMidstreamUpdate(@NonNull FunctionCall functionCall, @NonNull MidstreamStateItem stateUpdate) {
        assert (stateUpdate.getIndex() == null);
        assert (stateUpdate.getValue() == null);
        Map<Integer, IIndexedStateItemChild<T>> map = this.memberStateItems;
        synchronized (map) {
            for (IIndexedStateItemChild<T> childItem : this.memberStateItems.values()) {
                childItem.addMidstreamUpdate(functionCall, stateUpdate);
            }
        }
    }

    @Override
    public int compareTo(IStateItemBase o) {
        int nameComparison = this.getStateSpec().getName().compareTo(o.getStateSpec().getName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        if (o instanceof IStateItem) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable FunctionCall findLastAffectingCallBefore(@NonNull FunctionCall functionCall) {
        FunctionCallID targetID = functionCall.getID();
        FunctionCall result = null;
        Map<Integer, IIndexedStateItemChild<T>> map = this.memberStateItems;
        synchronized (map) {
            int i = 0;
            while (i < this.maxAllocatedIndex) {
                IIndexedStateItemChild<T> childItem = this.doGetItemForIndex(i);
                FunctionCall childResult = childItem.findLastAffectingCallBefore(functionCall);
                if (childResult != null) {
                    if (targetID.delta(childResult.getID()) == 1) {
                        return childResult;
                    }
                    if (result == null || result.compareTo(childResult) < 0) {
                        result = childResult;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable FunctionCall findNextAffectingCallAfter(@NonNull FunctionCall functionCall) {
        FunctionCallID targetID = functionCall.getID();
        FunctionCall result = null;
        Map<Integer, IIndexedStateItemChild<T>> map = this.memberStateItems;
        synchronized (map) {
            int i = 0;
            while (i < this.maxAllocatedIndex) {
                IIndexedStateItemChild<T> childItem = this.doGetItemForIndex(i);
                FunctionCall childResult = childItem.findNextAffectingCallAfter(functionCall);
                if (childResult != null) {
                    if (childResult.getID().delta(targetID) == 1) {
                        return childResult;
                    }
                    if (result == null || result.compareTo(childResult) > 0) {
                        result = childResult;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public int getIndexCount() {
        return this.indexCount.getIndexCount();
    }

    @Override
    public @Nullable IIndexedStateItemChild<T> getItemForIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int counter = this.getIndexCount();
        assert (counter == 0 || index < counter);
        return this.doGetItemForIndex(index);
    }

    @Override
    public @NonNull StateSpec getStateSpec() {
        return this.stateSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isAffectedBy(@NonNull FunctionCall functionCall) {
        Map<Integer, IIndexedStateItemChild<T>> map = this.memberStateItems;
        synchronized (map) {
            int i = 0;
            while (true) {
                if (i >= this.maxAllocatedIndex) {
                    return false;
                }
                IIndexedStateItemChild<T> childItem = this.doGetItemForIndex(i);
                if (childItem.isAffectedBy(functionCall)) {
                    return true;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isForPName(@NonNull AbstractConstantOrAliasSpecExtended byConstant) {
        return this.stateSpec.getName().equals(byConstant.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @Nullable List<@NonNull IStateItemValue<?>> waitForAllValues(ICoreProgressMonitor progressMonitor, FunctionCallID at) {
        ArrayList<@NonNull IStateItemValue<?>> result = new ArrayList();
        Map<Integer, IIndexedStateItemChild<T>> map = this.memberStateItems;
        synchronized (map) {
            int count = Math.max(this.maxAllocatedIndex, this.getIndexCount());
            int i = 0;
            while (i < count) {
                if (progressMonitor.isCancelled()) {
                    return null;
                }
                IIndexedStateItemChild<T> stateItem = this.doGetItemForIndex(i);
                result.add((IStateItemValue<?>)stateItem.waitForValue(progressMonitor, at));
                ++i;
            }
        }
        if (progressMonitor.isCancelled()) {
            return null;
        }
        ArrayList arrayList = result;
        return arrayList;
    }

    protected abstract IIndexedStateItemChild<T> allocateNewMemberStateItem(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IIndexedStateItemChild<T> doGetItemForIndex(int index) {
        Map<Integer, IIndexedStateItemChild<T>> map = this.memberStateItems;
        synchronized (map) {
            @NonNull Integer indexObj = NullUtils.intValueOf((int)index);
            if (!this.memberStateItems.containsKey(indexObj)) {
                this.memberStateItems.put(indexObj, this.allocateNewMemberStateItem(indexObj));
                this.maxAllocatedIndex = Math.max(this.maxAllocatedIndex, indexObj);
            }
            return this.memberStateItems.get(indexObj);
        }
    }

    private static class ConstantIndexCount
    implements IIndexCountProvider {
        private final int indexCount;

        public ConstantIndexCount(int indexCount) {
            this.indexCount = indexCount;
        }

        @Override
        public int getIndexCount() {
            return this.indexCount;
        }
    }

    private static interface IIndexCountProvider {
        public int getIndexCount();
    }

    private static class StateItemIndexCount
    implements IIndexCountProvider {
        private final IStateItem<IntegerStateItemValue> sourceStateItem;

        public StateItemIndexCount(IStateItem<IntegerStateItemValue> sourceStateItem) {
            this.sourceStateItem = sourceStateItem;
        }

        @Override
        public int getIndexCount() {
            int functionCallCount = this.sourceStateItem.getFunctionCallCount();
            if (functionCallCount == 0) {
                return ((Long)NullUtils.neverNull((Object)((Long)this.sourceStateItem.getDefaultValue().getValue()))).intValue();
            }
            FunctionCall functionCall = this.sourceStateItem.getFunctionCall(functionCallCount - 1);
            IntegerStateItemValue value = this.sourceStateItem.waitForValue(functionCall.getID());
            Long longValue = (Long)value.getValue();
            return longValue != null ? longValue.intValue() : 0;
        }
    }
}

