/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.gles.gen;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.asset.gles.GlTextureAsset;
import com.arm.mgd.lightweight.asset.gles.GlTextureUnitAsset;
import com.arm.mgd.lightweight.state.AbstractStateItemCallProcessor;
import com.arm.mgd.lightweight.state.IIndexedStateItem;
import com.arm.mgd.lightweight.state.IIndexedStateItemChild;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.gles.gen.GlesStateItems;
import com.arm.mgd.lightweight.state.value.AssetStateItemValue;
import com.arm.mgd.lightweight.state.value.BooleanStateItemValue;
import com.arm.mgd.lightweight.state.value.EnumAssetStateItemValue;
import com.arm.mgd.lightweight.state.value.EnumStateItemValue;
import com.arm.mgd.lightweight.state.value.IntegerStateItemValue;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GlesStateProcessor {
    private static final Map<IFunctionOrAliasSpecExtended, AbstractStateItemCallProcessor<GlesStateItems>> FUNCTION_CALL_PROCESSORS = new HashMap<IFunctionOrAliasSpecExtended, AbstractStateItemCallProcessor<GlesStateItems>>(){
        {
            this.put(KapiSpec.GLES.functions.GLACTIVETEXTURE, new GlActiveTexture());
            this.put(KapiSpec.GLES.functions.GLBEGINQUERY, new GlBeginQuery());
            this.put(KapiSpec.GLES.functions.GLBEGINTRANSFORMFEEDBACK, new GlBeginTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLBINDBUFFER, new GlBindBuffer());
            this.put(KapiSpec.GLES.functions.GLBINDBUFFERBASE, new GlBindBufferBase());
            this.put(KapiSpec.GLES.functions.GLBINDBUFFERRANGE, new GlBindBufferRange());
            this.put(KapiSpec.GLES.functions.GLBINDFRAMEBUFFER, new GlBindFramebuffer());
            this.put(KapiSpec.GLES.functions.GLBINDIMAGETEXTURE, new GlBindImageTexture());
            this.put(KapiSpec.GLES.functions.GLBINDPROGRAMPIPELINE, new GlBindProgramPipeline());
            this.put(KapiSpec.GLES.functions.GLBINDRENDERBUFFER, new GlBindRenderbuffer());
            this.put(KapiSpec.GLES.functions.GLBINDSAMPLER, new GlBindSampler());
            this.put(KapiSpec.GLES.functions.GLBINDTEXTURE, new GlBindTexture());
            this.put(KapiSpec.GLES.functions.GLBINDTRANSFORMFEEDBACK, new GlBindTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLBINDVERTEXARRAY, new GlBindVertexArray());
            this.put(KapiSpec.GLES.functions.GLBLENDCOLOR, new GlBlendColor());
            this.put(KapiSpec.GLES.functions.GLBLENDEQUATION, new GlBlendEquation());
            this.put(KapiSpec.GLES.functions.GLBLENDEQUATIONSEPARATE, new GlBlendEquationSeparate());
            this.put(KapiSpec.GLES.functions.GLBLENDFUNC, new GlBlendFunc());
            this.put(KapiSpec.GLES.functions.GLBLENDFUNCSEPARATE, new GlBlendFuncSeparate());
            this.put(KapiSpec.GLES.functions.GLCLEARCOLOR, new GlClearColor());
            this.put(KapiSpec.GLES.functions.GLCLEARDEPTHF, new GlClearDepthf());
            this.put(KapiSpec.GLES.functions.GLCLEARSTENCIL, new GlClearStencil());
            this.put(KapiSpec.GLES.functions.GLCOLORMASK, new GlColorMask());
            this.put(KapiSpec.GLES.functions.GLCULLFACE, new GlCullFace());
            this.put(KapiSpec.GLES.functions.GLDEPTHFUNC, new GlDepthFunc());
            this.put(KapiSpec.GLES.functions.GLDEPTHMASK, new GlDepthMask());
            this.put(KapiSpec.GLES.functions.GLDEPTHRANGEF, new GlDepthRangef());
            this.put(KapiSpec.GLES.functions.GLDISABLE, new GlDisable());
            this.put(KapiSpec.GLES.functions.GLENABLE, new GlEnable());
            this.put(KapiSpec.GLES.functions.GLENDTRANSFORMFEEDBACK, new GlEndTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLFRONTFACE, new GlFrontFace());
            this.put(KapiSpec.GLES.functions.GLGETBOOLEANI_V, new GlGetBooleaniV());
            this.put(KapiSpec.GLES.functions.GLGETBOOLEANV, new GlGetBooleanv());
            this.put(KapiSpec.GLES.functions.GLGETFLOATV, new GlGetFloatv());
            this.put(KapiSpec.GLES.functions.GLGETINTEGER64I_V, new GlGetInteger64IV());
            this.put(KapiSpec.GLES.functions.GLGETINTEGER64V, new GlGetInteger64V());
            this.put(KapiSpec.GLES.functions.GLGETINTEGERI_V, new GlGetIntegeriV());
            this.put(KapiSpec.GLES.functions.GLGETINTEGERV, new GlGetIntegerv());
            this.put(KapiSpec.GLES.functions.GLHINT, new GlHint());
            this.put(KapiSpec.GLES.functions.GLISENABLED, new GlIsEnabled());
            this.put(KapiSpec.GLES.functions.GLLINEWIDTH, new GlLineWidth());
            this.put(KapiSpec.GLES.functions.GLMINSAMPLESHADING, new GlMinSampleShading());
            this.put(KapiSpec.GLES.functions.GLPATCHPARAMETERI, new GlPatchParameteri());
            this.put(KapiSpec.GLES.functions.GLPAUSETRANSFORMFEEDBACK, new GlPauseTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLPIXELSTOREI, new GlPixelStorei());
            this.put(KapiSpec.GLES.functions.GLPOLYGONOFFSET, new GlPolygonOffset());
            this.put(KapiSpec.GLES.functions.GLRESUMETRANSFORMFEEDBACK, new GlResumeTransformFeedback());
            this.put(KapiSpec.GLES.functions.GLSAMPLECOVERAGE, new GlSampleCoverage());
            this.put(KapiSpec.GLES.functions.GLSCISSOR, new GlScissor());
            this.put(KapiSpec.GLES.functions.GLSTENCILFUNC, new GlStencilFunc());
            this.put(KapiSpec.GLES.functions.GLSTENCILFUNCSEPARATE, new GlStencilFuncSeparate());
            this.put(KapiSpec.GLES.functions.GLSTENCILMASK, new GlStencilMask());
            this.put(KapiSpec.GLES.functions.GLSTENCILMASKSEPARATE, new GlStencilMaskSeparate());
            this.put(KapiSpec.GLES.functions.GLSTENCILOP, new GlStencilOp());
            this.put(KapiSpec.GLES.functions.GLSTENCILOPSEPARATE, new GlStencilOpSeparate());
            this.put(KapiSpec.GLES.functions.GLUSEPROGRAM, new GlUseProgram());
            this.put(KapiSpec.GLES.functions.GLVIEWPORT, new GlViewport());
        }
    };

    public static @Nullable AbstractStateItemCallProcessor<GlesStateItems> getProcessorFor(@NonNull IFunctionOrAliasSpecExtended functionSpec) {
        return FUNCTION_CALL_PROCESSORS.get(functionSpec);
    }

    private static class GlActiveTexture
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlActiveTexture() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLACTIVETEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_texture = GLES.GlActiveTextureDecorator.getArgumentTexture(functionCall);
                if (stateItemContainer.GL_ACTIVE_TEXTURE != null) {
                    stateItemContainer.GL_ACTIVE_TEXTURE.addFunctionCall(functionCall);
                    stateItemContainer.GL_SAMPLER_BINDING.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_2D.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_2D_ARRAY.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_3D.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_BUFFER.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP_ARRAY.addFunctionCall(functionCall);
                    stateItemContainer.GL_TEXTURE_BINDING_EXTERNAL_OES.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBeginQuery
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBeginQuery() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBEGINQUERY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBeginQueryDecorator.getArgumentTarget(functionCall);
                Long arg_id = GLES.GlBeginQueryDecorator.getArgumentId(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(KapiSpec.GLES.targetBindingMaps.QUERY_TARGETS.specObject, false, arg_target);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBeginTransformFeedback
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBeginTransformFeedback() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBEGINTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_primitiveMode = GLES.GlBeginTransformFeedbackDecorator.getArgumentPrimitiveMode(functionCall);
                if (stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE != null) {
                    stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindBuffer
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindBuffer() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferDecorator.getArgumentTarget(functionCall);
                Long arg_buffer = GLES.GlBindBufferDecorator.getArgumentBuffer(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(KapiSpec.GLES.targetBindingMaps.BUFFER_TARGETS.specObject, false, arg_target);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindBufferBase
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindBufferBase() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDBUFFERBASE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                IIndexedStateItemChild<?> temp_1;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlBindBufferBaseDecorator.getArgumentIndex(functionCall);
                Long arg_buffer = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
                IIndexedStateItem<?> temp_0 = stateItemContainer.lookupIndexedStateItem(KapiSpec.GLES.targetBindingMaps.INDEXED_BUFFER_TARGETS.specObject, false, arg_target);
                if (temp_0 != null && (temp_1 = temp_0.getItemForIndex(arg_index.intValue())) != null) {
                    temp_1.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindBufferRange
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindBufferRange() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDBUFFERRANGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                IIndexedStateItemChild<?> temp_1;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlBindBufferRangeDecorator.getArgumentIndex(functionCall);
                Long arg_buffer = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
                Long arg_offset = GLES.GlBindBufferRangeDecorator.getArgumentOffset(functionCall);
                Long arg_size = GLES.GlBindBufferRangeDecorator.getArgumentSize(functionCall);
                IIndexedStateItem<?> temp_0 = stateItemContainer.lookupIndexedStateItem(KapiSpec.GLES.targetBindingMaps.INDEXED_BUFFER_TARGETS.specObject, false, arg_target);
                if (temp_0 != null && (temp_1 = temp_0.getItemForIndex(arg_index.intValue())) != null) {
                    temp_1.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindFramebuffer
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindFramebuffer() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindFramebufferDecorator.getArgumentTarget(functionCall);
                Long arg_framebuffer = GLES.GlBindFramebufferDecorator.getArgumentFramebuffer(functionCall);
                if (arg_target.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER) && stateItemContainer.GL_DRAW_FRAMEBUFFER_BINDING != null) {
                    stateItemContainer.GL_DRAW_FRAMEBUFFER_BINDING.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER) && stateItemContainer.GL_READ_FRAMEBUFFER_BINDING != null) {
                    stateItemContainer.GL_READ_FRAMEBUFFER_BINDING.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_DRAW_FRAMEBUFFER) && stateItemContainer.GL_DRAW_FRAMEBUFFER_BINDING != null) {
                    stateItemContainer.GL_DRAW_FRAMEBUFFER_BINDING.addFunctionCall(functionCall);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_READ_FRAMEBUFFER) && stateItemContainer.GL_READ_FRAMEBUFFER_BINDING != null) {
                    stateItemContainer.GL_READ_FRAMEBUFFER_BINDING.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindImageTexture
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindImageTexture() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDIMAGETEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_unit = GLES.GlBindImageTextureDecorator.getArgumentUnit(functionCall);
                Long arg_texture = GLES.GlBindImageTextureDecorator.getArgumentTexture(functionCall);
                Integer arg_level = GLES.GlBindImageTextureDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_layered = GLES.GlBindImageTextureDecorator.getArgumentLayered(functionCall);
                Integer arg_layer = GLES.GlBindImageTextureDecorator.getArgumentLayer(functionCall);
                AbstractConstantOrAliasSpecExtended arg_access = GLES.GlBindImageTextureDecorator.getArgumentAccess(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlBindImageTextureDecorator.getArgumentFormat(functionCall);
                IIndexedStateItemChild<EnumStateItemValue> temp_0 = stateItemContainer.INDEXED_GL_IMAGE_BINDING_ACCESS.getItemForIndex(arg_unit.intValue());
                IIndexedStateItemChild<EnumStateItemValue> temp_1 = stateItemContainer.INDEXED_GL_IMAGE_BINDING_FORMAT.getItemForIndex(arg_unit.intValue());
                IIndexedStateItemChild<IntegerStateItemValue> temp_2 = stateItemContainer.INDEXED_GL_IMAGE_BINDING_LEVEL.getItemForIndex(arg_unit.intValue());
                IIndexedStateItemChild<IntegerStateItemValue> temp_3 = stateItemContainer.INDEXED_GL_IMAGE_BINDING_LAYER.getItemForIndex(arg_unit.intValue());
                IIndexedStateItemChild<BooleanStateItemValue> temp_4 = stateItemContainer.INDEXED_GL_IMAGE_BINDING_LAYERED.getItemForIndex(arg_unit.intValue());
                IIndexedStateItemChild<AssetStateItemValue<GlTextureAsset>> temp_5 = stateItemContainer.INDEXED_GL_IMAGE_BINDING_NAME.getItemForIndex(arg_unit.intValue());
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                }
                if (temp_1 != null) {
                    temp_1.addFunctionCall(functionCall);
                }
                if (temp_2 != null) {
                    temp_2.addFunctionCall(functionCall);
                }
                if (temp_3 != null) {
                    temp_3.addFunctionCall(functionCall);
                }
                if (temp_4 != null) {
                    temp_4.addFunctionCall(functionCall);
                }
                if (temp_5 != null) {
                    temp_5.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindProgramPipeline
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindProgramPipeline() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDPROGRAMPIPELINE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_pipeline = GLES.GlBindProgramPipelineDecorator.getArgumentPipeline(functionCall);
                if (stateItemContainer.GL_PROGRAM_PIPELINE_BINDING != null) {
                    stateItemContainer.GL_PROGRAM_PIPELINE_BINDING.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindRenderbuffer
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindRenderbuffer() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDRENDERBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindRenderbufferDecorator.getArgumentTarget(functionCall);
                Long arg_renderbuffer = GLES.GlBindRenderbufferDecorator.getArgumentRenderbuffer(functionCall);
                if (arg_target.equals(KapiSpec.GLES.constants.GL_RENDERBUFFER) && stateItemContainer.GL_RENDERBUFFER_BINDING != null) {
                    stateItemContainer.GL_RENDERBUFFER_BINDING.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindSampler
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindSampler() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDSAMPLER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_unit = GLES.GlBindSamplerDecorator.getArgumentUnit(functionCall);
                Long arg_sampler = GLES.GlBindSamplerDecorator.getArgumentSampler(functionCall);
                long longValue_return_value_temp_1 = arg_unit;
                EnumAssetStateItemValue<GlTextureUnitAsset> getStateItemValue_return_value_temp_0 = GlBindSampler.getStateItemValue(functionCall, stateItemContainer.GL_ACTIVE_TEXTURE);
                assert (getStateItemValue_return_value_temp_0 != null);
                long getValueAsLong_return_value_temp_2 = getStateItemValue_return_value_temp_0.getValueAsLong();
                if (longValue_return_value_temp_1 == getValueAsLong_return_value_temp_2 && stateItemContainer.GL_SAMPLER_BINDING != null) {
                    stateItemContainer.GL_SAMPLER_BINDING.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindTexture
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindTexture() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDTEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindTextureDecorator.getArgumentTarget(functionCall);
                Long arg_texture = GLES.GlBindTextureDecorator.getArgumentTexture(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, false, arg_target);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindTransformFeedback
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindTransformFeedback() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindTransformFeedbackDecorator.getArgumentTarget(functionCall);
                Long arg_id = GLES.GlBindTransformFeedbackDecorator.getArgumentId(functionCall);
                if (stateItemContainer.GL_TRANSFORM_FEEDBACK_BINDING != null) {
                    stateItemContainer.GL_TRANSFORM_FEEDBACK_BINDING.addFunctionCall(functionCall);
                    stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE.addFunctionCall(functionCall);
                    stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBindVertexArray
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBindVertexArray() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBINDVERTEXARRAY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_array = GLES.GlBindVertexArrayDecorator.getArgumentArray(functionCall);
                if (stateItemContainer.GL_VERTEX_ARRAY_BINDING != null) {
                    stateItemContainer.GL_VERTEX_ARRAY_BINDING.addFunctionCall(functionCall);
                    stateItemContainer.GL_ELEMENT_ARRAY_BUFFER_BINDING.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBlendColor
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBlendColor() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBLENDCOLOR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Float arg_red = GLES.GlBlendColorDecorator.getArgumentRed(functionCall);
                Float arg_green = GLES.GlBlendColorDecorator.getArgumentGreen(functionCall);
                Float arg_blue = GLES.GlBlendColorDecorator.getArgumentBlue(functionCall);
                Float arg_alpha = GLES.GlBlendColorDecorator.getArgumentAlpha(functionCall);
                if (stateItemContainer.GL_BLEND_COLOR != null) {
                    stateItemContainer.GL_BLEND_COLOR.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBlendEquation
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBlendEquation() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBLENDEQUATION.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_mode = GLES.GlBlendEquationDecorator.getArgumentMode(functionCall);
                if (stateItemContainer.GL_BLEND_EQUATION_RGB != null) {
                    stateItemContainer.GL_BLEND_EQUATION_RGB.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_BLEND_EQUATION_ALPHA != null) {
                    stateItemContainer.GL_BLEND_EQUATION_ALPHA.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBlendEquationSeparate
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBlendEquationSeparate() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBLENDEQUATIONSEPARATE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_modeRGB = GLES.GlBlendEquationSeparateDecorator.getArgumentModeRGB(functionCall);
                AbstractConstantOrAliasSpecExtended arg_modeAlpha = GLES.GlBlendEquationSeparateDecorator.getArgumentModeAlpha(functionCall);
                if (stateItemContainer.GL_BLEND_EQUATION_RGB != null) {
                    stateItemContainer.GL_BLEND_EQUATION_RGB.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_BLEND_EQUATION_ALPHA != null) {
                    stateItemContainer.GL_BLEND_EQUATION_ALPHA.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBlendFunc
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBlendFunc() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBLENDFUNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_sfactor = GLES.GlBlendFuncDecorator.getArgumentSfactor(functionCall);
                AbstractConstantOrAliasSpecExtended arg_dfactor = GLES.GlBlendFuncDecorator.getArgumentDfactor(functionCall);
                if (stateItemContainer.GL_BLEND_SRC_RGB != null) {
                    stateItemContainer.GL_BLEND_SRC_RGB.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_BLEND_SRC_ALPHA != null) {
                    stateItemContainer.GL_BLEND_SRC_ALPHA.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_BLEND_DST_RGB != null) {
                    stateItemContainer.GL_BLEND_DST_RGB.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_BLEND_DST_ALPHA != null) {
                    stateItemContainer.GL_BLEND_DST_ALPHA.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlBlendFuncSeparate
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlBlendFuncSeparate() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLBLENDFUNCSEPARATE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_sfactorRGB = GLES.GlBlendFuncSeparateDecorator.getArgumentSfactorRGB(functionCall);
                AbstractConstantOrAliasSpecExtended arg_dfactorRGB = GLES.GlBlendFuncSeparateDecorator.getArgumentDfactorRGB(functionCall);
                AbstractConstantOrAliasSpecExtended arg_sfactorAlpha = GLES.GlBlendFuncSeparateDecorator.getArgumentSfactorAlpha(functionCall);
                AbstractConstantOrAliasSpecExtended arg_dfactorAlpha = GLES.GlBlendFuncSeparateDecorator.getArgumentDfactorAlpha(functionCall);
                if (stateItemContainer.GL_BLEND_SRC_RGB != null) {
                    stateItemContainer.GL_BLEND_SRC_RGB.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_BLEND_SRC_ALPHA != null) {
                    stateItemContainer.GL_BLEND_SRC_ALPHA.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_BLEND_DST_RGB != null) {
                    stateItemContainer.GL_BLEND_DST_RGB.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_BLEND_DST_ALPHA != null) {
                    stateItemContainer.GL_BLEND_DST_ALPHA.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlClearColor
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlClearColor() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLCLEARCOLOR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Float arg_red = GLES.GlClearColorDecorator.getArgumentRed(functionCall);
                Float arg_green = GLES.GlClearColorDecorator.getArgumentGreen(functionCall);
                Float arg_blue = GLES.GlClearColorDecorator.getArgumentBlue(functionCall);
                Float arg_alpha = GLES.GlClearColorDecorator.getArgumentAlpha(functionCall);
                if (stateItemContainer.GL_COLOR_CLEAR_VALUE != null) {
                    stateItemContainer.GL_COLOR_CLEAR_VALUE.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlClearDepthf
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlClearDepthf() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLCLEARDEPTHF.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Float arg_d = GLES.GlClearDepthfDecorator.getArgumentD(functionCall);
                if (stateItemContainer.GL_DEPTH_CLEAR_VALUE != null) {
                    stateItemContainer.GL_DEPTH_CLEAR_VALUE.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlClearStencil
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlClearStencil() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLCLEARSTENCIL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_s = GLES.GlClearStencilDecorator.getArgumentS(functionCall);
                if (stateItemContainer.GL_STENCIL_CLEAR_VALUE != null) {
                    stateItemContainer.GL_STENCIL_CLEAR_VALUE.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlColorMask
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlColorMask() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLCOLORMASK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_red = GLES.GlColorMaskDecorator.getArgumentRed(functionCall);
                AbstractConstantOrAliasSpecExtended arg_green = GLES.GlColorMaskDecorator.getArgumentGreen(functionCall);
                AbstractConstantOrAliasSpecExtended arg_blue = GLES.GlColorMaskDecorator.getArgumentBlue(functionCall);
                AbstractConstantOrAliasSpecExtended arg_alpha = GLES.GlColorMaskDecorator.getArgumentAlpha(functionCall);
                if (stateItemContainer.GL_COLOR_WRITEMASK != null) {
                    stateItemContainer.GL_COLOR_WRITEMASK.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlCullFace
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlCullFace() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLCULLFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_mode = GLES.GlCullFaceDecorator.getArgumentMode(functionCall);
                if (stateItemContainer.GL_CULL_FACE_MODE != null) {
                    stateItemContainer.GL_CULL_FACE_MODE.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlDepthFunc
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlDepthFunc() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLDEPTHFUNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_func = GLES.GlDepthFuncDecorator.getArgumentFunc(functionCall);
                if (stateItemContainer.GL_DEPTH_FUNC != null) {
                    stateItemContainer.GL_DEPTH_FUNC.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlDepthMask
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlDepthMask() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLDEPTHMASK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_flag = GLES.GlDepthMaskDecorator.getArgumentFlag(functionCall);
                if (stateItemContainer.GL_DEPTH_WRITEMASK != null) {
                    stateItemContainer.GL_DEPTH_WRITEMASK.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlDepthRangef
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlDepthRangef() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLDEPTHRANGEF.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Float arg_n = GLES.GlDepthRangefDecorator.getArgumentN(functionCall);
                Float arg_f = GLES.GlDepthRangefDecorator.getArgumentF(functionCall);
                if (stateItemContainer.GL_DEPTH_RANGE != null) {
                    stateItemContainer.GL_DEPTH_RANGE.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlDisable
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlDisable() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            AbstractConstantOrAliasSpecExtended arg_cap;
            IStateItem<?> temp_0;
            assert (KapiSpec.GLES.functions.GLDISABLE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (temp_0 = stateItemContainer.lookupStateItem(arg_cap = GLES.GlDisableDecorator.getArgumentCap(functionCall))) != null) {
                temp_0.addFunctionCall(functionCall);
            }
        }
    }

    private static class GlEnable
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlEnable() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            AbstractConstantOrAliasSpecExtended arg_cap;
            IStateItem<?> temp_0;
            assert (KapiSpec.GLES.functions.GLENABLE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (temp_0 = stateItemContainer.lookupStateItem(arg_cap = GLES.GlEnableDecorator.getArgumentCap(functionCall))) != null) {
                temp_0.addFunctionCall(functionCall);
            }
        }
    }

    private static class GlEndTransformFeedback
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlEndTransformFeedback() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLENDTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                if (stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE != null) {
                    stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED != null) {
                    stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlFrontFace
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlFrontFace() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLFRONTFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_mode = GLES.GlFrontFaceDecorator.getArgumentMode(functionCall);
                if (stateItemContainer.GL_FRONT_FACE != null) {
                    stateItemContainer.GL_FRONT_FACE.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlGetBooleaniV
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlGetBooleaniV() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLGETBOOLEANI_V.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                IIndexedStateItemChild<?> temp_1;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlGetBooleani_vDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlGetBooleani_vDecorator.getArgumentIndex(functionCall);
                LongsArgAttachment arg_data = GLES.GlGetBooleani_vDecorator.getArgumentData(functionCall);
                IIndexedStateItem<?> temp_0 = stateItemContainer.lookupIndexedStateItem(arg_target);
                if (temp_0 != null && (temp_1 = temp_0.getItemForIndex(arg_index.intValue())) != null) {
                    temp_1.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlGetBooleanv
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlGetBooleanv() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLGETBOOLEANV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlGetBooleanvDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_data = GLES.GlGetBooleanvDecorator.getArgumentData(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(arg_pname);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                    if (temp_0.equals(stateItemContainer.GL_TRANSFORM_FEEDBACK_BINDING)) {
                        stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE.addFunctionCall(functionCall);
                        stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED.addFunctionCall(functionCall);
                    }
                    if (temp_0.equals(stateItemContainer.GL_VERTEX_ARRAY_BINDING)) {
                        stateItemContainer.GL_ELEMENT_ARRAY_BUFFER_BINDING.addFunctionCall(functionCall);
                    }
                    if (temp_0.equals(stateItemContainer.GL_ACTIVE_TEXTURE)) {
                        stateItemContainer.GL_SAMPLER_BINDING.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_3D.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_BUFFER.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_EXTERNAL_OES.addFunctionCall(functionCall);
                    }
                }
            }
        }
    }

    private static class GlGetFloatv
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlGetFloatv() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLGETFLOATV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlGetFloatvDecorator.getArgumentPname(functionCall);
                FloatsArgAttachment arg_data = GLES.GlGetFloatvDecorator.getArgumentData(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(arg_pname);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                    if (temp_0.equals(stateItemContainer.GL_TRANSFORM_FEEDBACK_BINDING)) {
                        stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE.addFunctionCall(functionCall);
                        stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED.addFunctionCall(functionCall);
                    }
                    if (temp_0.equals(stateItemContainer.GL_VERTEX_ARRAY_BINDING)) {
                        stateItemContainer.GL_ELEMENT_ARRAY_BUFFER_BINDING.addFunctionCall(functionCall);
                    }
                    if (temp_0.equals(stateItemContainer.GL_ACTIVE_TEXTURE)) {
                        stateItemContainer.GL_SAMPLER_BINDING.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_3D.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_BUFFER.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_EXTERNAL_OES.addFunctionCall(functionCall);
                    }
                }
            }
        }
    }

    private static class GlGetInteger64IV
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlGetInteger64IV() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLGETINTEGER64I_V.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                IIndexedStateItemChild<?> temp_1;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlGetInteger64i_vDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlGetInteger64i_vDecorator.getArgumentIndex(functionCall);
                LongsArgAttachment arg_data = GLES.GlGetInteger64i_vDecorator.getArgumentData(functionCall);
                IIndexedStateItem<?> temp_0 = stateItemContainer.lookupIndexedStateItem(KapiSpec.GLES.targetBindingMaps.INDEXED_BUFFER_TARGETS.specObject, true, arg_target);
                if (temp_0 != null && (temp_1 = temp_0.getItemForIndex(arg_index.intValue())) != null) {
                    temp_1.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlGetInteger64V
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlGetInteger64V() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLGETINTEGER64V.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlGetInteger64vDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_data = GLES.GlGetInteger64vDecorator.getArgumentData(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(arg_pname);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                    if (temp_0.equals(stateItemContainer.GL_TRANSFORM_FEEDBACK_BINDING)) {
                        stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE.addFunctionCall(functionCall);
                        stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED.addFunctionCall(functionCall);
                    }
                    if (temp_0.equals(stateItemContainer.GL_VERTEX_ARRAY_BINDING)) {
                        stateItemContainer.GL_ELEMENT_ARRAY_BUFFER_BINDING.addFunctionCall(functionCall);
                    }
                    if (temp_0.equals(stateItemContainer.GL_ACTIVE_TEXTURE)) {
                        stateItemContainer.GL_SAMPLER_BINDING.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_3D.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_BUFFER.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_EXTERNAL_OES.addFunctionCall(functionCall);
                    }
                }
            }
        }
    }

    private static class GlGetIntegeriV
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlGetIntegeriV() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLGETINTEGERI_V.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                IIndexedStateItemChild<?> temp_1;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlGetIntegeri_vDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlGetIntegeri_vDecorator.getArgumentIndex(functionCall);
                LongsArgAttachment arg_data = GLES.GlGetIntegeri_vDecorator.getArgumentData(functionCall);
                IIndexedStateItem<?> temp_0 = stateItemContainer.lookupIndexedStateItem(KapiSpec.GLES.targetBindingMaps.INDEXED_BUFFER_TARGETS.specObject, true, arg_target);
                if (temp_0 != null && (temp_1 = temp_0.getItemForIndex(arg_index.intValue())) != null) {
                    temp_1.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlGetIntegerv
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlGetIntegerv() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLGETINTEGERV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlGetIntegervDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_data = GLES.GlGetIntegervDecorator.getArgumentData(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(arg_pname);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                    if (temp_0.equals(stateItemContainer.GL_TRANSFORM_FEEDBACK_BINDING)) {
                        stateItemContainer.GL_TRANSFORM_FEEDBACK_ACTIVE.addFunctionCall(functionCall);
                        stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED.addFunctionCall(functionCall);
                    }
                    if (temp_0.equals(stateItemContainer.GL_VERTEX_ARRAY_BINDING)) {
                        stateItemContainer.GL_ELEMENT_ARRAY_BUFFER_BINDING.addFunctionCall(functionCall);
                    }
                    if (temp_0.equals(stateItemContainer.GL_ACTIVE_TEXTURE)) {
                        stateItemContainer.GL_SAMPLER_BINDING.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_3D.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_BUFFER.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_CUBE_MAP_ARRAY.addFunctionCall(functionCall);
                        stateItemContainer.GL_TEXTURE_BINDING_EXTERNAL_OES.addFunctionCall(functionCall);
                    }
                }
            }
        }
    }

    private static class GlHint
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlHint() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLHINT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlHintDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_mode = GLES.GlHintDecorator.getArgumentMode(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(arg_target);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlIsEnabled
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlIsEnabled() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLISENABLED.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_cap = GLES.GlIsEnabledDecorator.getArgumentCap(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = GLES.GlIsEnabledDecorator.getReturnValue(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(arg_cap);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlLineWidth
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlLineWidth() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLLINEWIDTH.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Float arg_width = GLES.GlLineWidthDecorator.getArgumentWidth(functionCall);
                if (stateItemContainer.GL_LINE_WIDTH != null) {
                    stateItemContainer.GL_LINE_WIDTH.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlMinSampleShading
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlMinSampleShading() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLMINSAMPLESHADING.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Float arg_value = GLES.GlMinSampleShadingDecorator.getArgumentValue(functionCall);
                if (stateItemContainer.GL_MIN_SAMPLE_SHADING_VALUE != null) {
                    stateItemContainer.GL_MIN_SAMPLE_SHADING_VALUE.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlPatchParameteri
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlPatchParameteri() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLPATCHPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlPatchParameteriDecorator.getArgumentPname(functionCall);
                Integer arg_value = GLES.GlPatchParameteriDecorator.getArgumentValue(functionCall);
                if (arg_pname.equals(KapiSpec.GLES.constants.GL_PATCH_VERTICES) && stateItemContainer.GL_PATCH_VERTICES != null) {
                    stateItemContainer.GL_PATCH_VERTICES.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlPauseTransformFeedback
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlPauseTransformFeedback() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLPAUSETRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED != null) {
                stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED.addFunctionCall(functionCall);
            }
        }
    }

    private static class GlPixelStorei
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlPixelStorei() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLPIXELSTOREI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlPixelStoreiDecorator.getArgumentPname(functionCall);
                Integer arg_param = GLES.GlPixelStoreiDecorator.getArgumentParam(functionCall);
                IStateItem<?> temp_0 = stateItemContainer.lookupStateItem(arg_pname);
                if (temp_0 != null) {
                    temp_0.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlPolygonOffset
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlPolygonOffset() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLPOLYGONOFFSET.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Float arg_factor = GLES.GlPolygonOffsetDecorator.getArgumentFactor(functionCall);
                Float arg_units = GLES.GlPolygonOffsetDecorator.getArgumentUnits(functionCall);
                if (stateItemContainer.GL_POLYGON_OFFSET_FACTOR != null) {
                    stateItemContainer.GL_POLYGON_OFFSET_FACTOR.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_POLYGON_OFFSET_UNITS != null) {
                    stateItemContainer.GL_POLYGON_OFFSET_UNITS.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlResumeTransformFeedback
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlResumeTransformFeedback() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLRESUMETRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED != null) {
                stateItemContainer.GL_TRANSFORM_FEEDBACK_PAUSED.addFunctionCall(functionCall);
            }
        }
    }

    private static class GlSampleCoverage
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlSampleCoverage() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLSAMPLECOVERAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Float arg_value = GLES.GlSampleCoverageDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended arg_invert = GLES.GlSampleCoverageDecorator.getArgumentInvert(functionCall);
                if (stateItemContainer.GL_SAMPLE_COVERAGE_VALUE != null) {
                    stateItemContainer.GL_SAMPLE_COVERAGE_VALUE.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_SAMPLE_COVERAGE_INVERT != null) {
                    stateItemContainer.GL_SAMPLE_COVERAGE_INVERT.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlScissor
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlScissor() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLSCISSOR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_x = GLES.GlScissorDecorator.getArgumentX(functionCall);
                Integer arg_y = GLES.GlScissorDecorator.getArgumentY(functionCall);
                Integer arg_width = GLES.GlScissorDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlScissorDecorator.getArgumentHeight(functionCall);
                if (stateItemContainer.GL_SCISSOR_BOX != null) {
                    stateItemContainer.GL_SCISSOR_BOX.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlStencilFunc
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlStencilFunc() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLSTENCILFUNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_func = GLES.GlStencilFuncDecorator.getArgumentFunc(functionCall);
                Integer arg_ref = GLES.GlStencilFuncDecorator.getArgumentRef(functionCall);
                Long arg_mask = GLES.GlStencilFuncDecorator.getArgumentMask(functionCall);
                if (stateItemContainer.GL_STENCIL_FUNC != null) {
                    stateItemContainer.GL_STENCIL_FUNC.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_BACK_FUNC != null) {
                    stateItemContainer.GL_STENCIL_BACK_FUNC.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_REF != null) {
                    stateItemContainer.GL_STENCIL_REF.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_BACK_REF != null) {
                    stateItemContainer.GL_STENCIL_BACK_REF.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_VALUE_MASK != null) {
                    stateItemContainer.GL_STENCIL_VALUE_MASK.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_BACK_VALUE_MASK != null) {
                    stateItemContainer.GL_STENCIL_BACK_VALUE_MASK.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlStencilFuncSeparate
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlStencilFuncSeparate() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLSTENCILFUNCSEPARATE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_face = GLES.GlStencilFuncSeparateDecorator.getArgumentFace(functionCall);
                AbstractConstantOrAliasSpecExtended arg_func = GLES.GlStencilFuncSeparateDecorator.getArgumentFunc(functionCall);
                Integer arg_ref = GLES.GlStencilFuncSeparateDecorator.getArgumentRef(functionCall);
                Long arg_mask = GLES.GlStencilFuncSeparateDecorator.getArgumentMask(functionCall);
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_FRONT) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_FUNC != null) {
                    stateItemContainer.GL_STENCIL_FUNC.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_BACK) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_BACK_FUNC != null) {
                    stateItemContainer.GL_STENCIL_BACK_FUNC.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_FRONT) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_REF != null) {
                    stateItemContainer.GL_STENCIL_REF.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_BACK) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_BACK_REF != null) {
                    stateItemContainer.GL_STENCIL_BACK_REF.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_FRONT) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_VALUE_MASK != null) {
                    stateItemContainer.GL_STENCIL_VALUE_MASK.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_BACK) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_BACK_VALUE_MASK != null) {
                    stateItemContainer.GL_STENCIL_BACK_VALUE_MASK.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlStencilMask
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlStencilMask() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLSTENCILMASK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_mask = GLES.GlStencilMaskDecorator.getArgumentMask(functionCall);
                if (stateItemContainer.GL_STENCIL_WRITEMASK != null) {
                    stateItemContainer.GL_STENCIL_WRITEMASK.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_BACK_WRITEMASK != null) {
                    stateItemContainer.GL_STENCIL_BACK_WRITEMASK.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlStencilMaskSeparate
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlStencilMaskSeparate() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLSTENCILMASKSEPARATE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_face = GLES.GlStencilMaskSeparateDecorator.getArgumentFace(functionCall);
                Long arg_mask = GLES.GlStencilMaskSeparateDecorator.getArgumentMask(functionCall);
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_FRONT) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_WRITEMASK != null) {
                    stateItemContainer.GL_STENCIL_WRITEMASK.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_BACK) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_BACK_WRITEMASK != null) {
                    stateItemContainer.GL_STENCIL_BACK_WRITEMASK.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlStencilOp
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlStencilOp() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLSTENCILOP.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_fail = GLES.GlStencilOpDecorator.getArgumentFail(functionCall);
                AbstractConstantOrAliasSpecExtended arg_zfail = GLES.GlStencilOpDecorator.getArgumentZfail(functionCall);
                AbstractConstantOrAliasSpecExtended arg_zpass = GLES.GlStencilOpDecorator.getArgumentZpass(functionCall);
                if (stateItemContainer.GL_STENCIL_FAIL != null) {
                    stateItemContainer.GL_STENCIL_FAIL.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_BACK_FAIL != null) {
                    stateItemContainer.GL_STENCIL_BACK_FAIL.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_PASS_DEPTH_FAIL != null) {
                    stateItemContainer.GL_STENCIL_PASS_DEPTH_FAIL.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_BACK_PASS_DEPTH_FAIL != null) {
                    stateItemContainer.GL_STENCIL_BACK_PASS_DEPTH_FAIL.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_PASS_DEPTH_PASS != null) {
                    stateItemContainer.GL_STENCIL_PASS_DEPTH_PASS.addFunctionCall(functionCall);
                }
                if (stateItemContainer.GL_STENCIL_BACK_PASS_DEPTH_PASS != null) {
                    stateItemContainer.GL_STENCIL_BACK_PASS_DEPTH_PASS.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlStencilOpSeparate
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlStencilOpSeparate() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLSTENCILOPSEPARATE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_face = GLES.GlStencilOpSeparateDecorator.getArgumentFace(functionCall);
                AbstractConstantOrAliasSpecExtended arg_sfail = GLES.GlStencilOpSeparateDecorator.getArgumentSfail(functionCall);
                AbstractConstantOrAliasSpecExtended arg_dpfail = GLES.GlStencilOpSeparateDecorator.getArgumentDpfail(functionCall);
                AbstractConstantOrAliasSpecExtended arg_dppass = GLES.GlStencilOpSeparateDecorator.getArgumentDppass(functionCall);
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_FRONT) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_FAIL != null) {
                    stateItemContainer.GL_STENCIL_FAIL.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_BACK) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_BACK_FAIL != null) {
                    stateItemContainer.GL_STENCIL_BACK_FAIL.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_FRONT) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_PASS_DEPTH_FAIL != null) {
                    stateItemContainer.GL_STENCIL_PASS_DEPTH_FAIL.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_BACK) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_BACK_PASS_DEPTH_FAIL != null) {
                    stateItemContainer.GL_STENCIL_BACK_PASS_DEPTH_FAIL.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_FRONT) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_PASS_DEPTH_PASS != null) {
                    stateItemContainer.GL_STENCIL_PASS_DEPTH_PASS.addFunctionCall(functionCall);
                }
                if ((arg_face.equals(KapiSpec.GLES.constants.GL_BACK) || arg_face.equals(KapiSpec.GLES.constants.GL_FRONT_AND_BACK)) && stateItemContainer.GL_STENCIL_BACK_PASS_DEPTH_PASS != null) {
                    stateItemContainer.GL_STENCIL_BACK_PASS_DEPTH_PASS.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlUseProgram
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlUseProgram() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLUSEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlUseProgramDecorator.getArgumentProgram(functionCall);
                if (stateItemContainer.GL_CURRENT_PROGRAM != null) {
                    stateItemContainer.GL_CURRENT_PROGRAM.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class GlViewport
    extends AbstractStateItemCallProcessor<GlesStateItems> {
        private GlViewport() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull GlesStateItems stateItemContainer) {
            assert (KapiSpec.GLES.functions.GLVIEWPORT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_x = GLES.GlViewportDecorator.getArgumentX(functionCall);
                Integer arg_y = GLES.GlViewportDecorator.getArgumentY(functionCall);
                Integer arg_width = GLES.GlViewportDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlViewportDecorator.getArgumentHeight(functionCall);
                if (stateItemContainer.GL_VIEWPORT != null) {
                    stateItemContainer.GL_VIEWPORT.addFunctionCall(functionCall);
                }
            }
        }
    }
}

