/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.egl.gen;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.EGL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.lightweight.state.AbstractStateItemCallProcessor;
import com.arm.mgd.lightweight.state.egl.gen.EglStateItems;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class EglStateProcessor {
    private static final Map<IFunctionOrAliasSpecExtended, AbstractStateItemCallProcessor<EglStateItems>> FUNCTION_CALL_PROCESSORS = new HashMap<IFunctionOrAliasSpecExtended, AbstractStateItemCallProcessor<EglStateItems>>(){
        {
            this.put(KapiSpec.EGL.functions.EGLBINDAPI, new EglBindApi());
            this.put(KapiSpec.EGL.functions.EGLMAKECURRENT, new EglMakeCurrent());
            this.put(KapiSpec.EGL.functions.EGLRELEASETHREAD, new EglReleaseThread());
        }
    };

    public static @Nullable AbstractStateItemCallProcessor<EglStateItems> getProcessorFor(@NonNull IFunctionOrAliasSpecExtended functionSpec) {
        return FUNCTION_CALL_PROCESSORS.get(functionSpec);
    }

    private static class EglBindApi
    extends AbstractStateItemCallProcessor<EglStateItems> {
        private EglBindApi() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull EglStateItems stateItemContainer) {
            assert (KapiSpec.EGL.functions.EGLBINDAPI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_api = EGL.EglBindAPIDecorator.getArgumentApi(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglBindAPIDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_API != null) {
                    stateItemContainer.EGL_CURRENT_API.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class EglMakeCurrent
    extends AbstractStateItemCallProcessor<EglStateItems> {
        private EglMakeCurrent() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull EglStateItems stateItemContainer) {
            assert (KapiSpec.EGL.functions.EGLMAKECURRENT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_3;
                Pointer arg_dpy = EGL.EglMakeCurrentDecorator.getArgumentDpy(functionCall);
                Pointer arg_draw = EGL.EglMakeCurrentDecorator.getArgumentDraw(functionCall);
                Pointer arg_read = EGL.EglMakeCurrentDecorator.getArgumentRead(functionCall);
                Pointer arg_ctx = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglMakeCurrentDecorator.getReturnValue(functionCall);
                long temp_temp_2 = arg_ctx != null ? arg_ctx.address() : 0L;
                long l = temp_temp_3 = arg_ctx != null ? arg_ctx.address() : 0L;
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && temp_temp_2 != 0L && stateItemContainer.EGL_CURRENT_DISPLAY != null) {
                    stateItemContainer.EGL_CURRENT_DISPLAY.addFunctionCall(functionCall);
                }
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && temp_temp_3 == 0L && stateItemContainer.EGL_CURRENT_DISPLAY != null) {
                    stateItemContainer.EGL_CURRENT_DISPLAY.addFunctionCall(functionCall);
                }
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_DRAW_SURFACE != null) {
                    stateItemContainer.EGL_CURRENT_DRAW_SURFACE.addFunctionCall(functionCall);
                }
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_READ_SURFACE != null) {
                    stateItemContainer.EGL_CURRENT_READ_SURFACE.addFunctionCall(functionCall);
                }
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_CONTEXT != null) {
                    stateItemContainer.EGL_CURRENT_CONTEXT.addFunctionCall(functionCall);
                }
            }
        }
    }

    private static class EglReleaseThread
    extends AbstractStateItemCallProcessor<EglStateItems> {
        private EglReleaseThread() {
        }

        @Override
        public void execute(@NonNull FunctionCall functionCall, @NonNull EglStateItems stateItemContainer) {
            assert (KapiSpec.EGL.functions.EGLRELEASETHREAD.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglReleaseThreadDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_API != null) {
                    stateItemContainer.EGL_CURRENT_API.addFunctionCall(functionCall);
                }
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_DISPLAY != null) {
                    stateItemContainer.EGL_CURRENT_DISPLAY.addFunctionCall(functionCall);
                }
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_DRAW_SURFACE != null) {
                    stateItemContainer.EGL_CURRENT_DRAW_SURFACE.addFunctionCall(functionCall);
                }
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_READ_SURFACE != null) {
                    stateItemContainer.EGL_CURRENT_READ_SURFACE.addFunctionCall(functionCall);
                }
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && stateItemContainer.EGL_CURRENT_CONTEXT != null) {
                    stateItemContainer.EGL_CURRENT_CONTEXT.addFunctionCall(functionCall);
                }
            }
        }
    }
}

