/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state.egl.gen;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.EGL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.MidstreamStateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.marshaller.utils.FunctionCallArgumentDescriptor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.TargetBindingGroupSpec;
import com.arm.mgd.kapi.gen.TargetBindingSpec;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.asset.egl.AllEglAssets;
import com.arm.mgd.lightweight.asset.egl.EglContextAsset;
import com.arm.mgd.lightweight.asset.egl.EglDisplayAsset;
import com.arm.mgd.lightweight.asset.egl.EglSurfaceAsset;
import com.arm.mgd.lightweight.model.EglPerThreadData;
import com.arm.mgd.lightweight.state.IIndexedStateItem;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemBase;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.lightweight.state.internal.AbstractAssetStateItem;
import com.arm.mgd.lightweight.state.internal.AbstractStateItem;
import com.arm.mgd.lightweight.state.internal.AbstractStateItemContainer;
import com.arm.mgd.lightweight.state.value.AssetStateItemValue;
import com.arm.mgd.lightweight.state.value.EnumStateItemValue;
import com.arm.mgd.lightweight.state.value.StringStateItemValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class EglStateItems
extends AbstractStateItemContainer {
    public final IStateItem<EnumStateItemValue> EGL_CURRENT_API;
    public final IStateItem<AssetStateItemValue<EglContextAsset>> EGL_CURRENT_CONTEXT;
    public final IStateItem<AssetStateItemValue<EglDisplayAsset>> EGL_CURRENT_DISPLAY;
    public final IStateItem<AssetStateItemValue<EglSurfaceAsset<?, ?>>> EGL_CURRENT_DRAW_SURFACE;
    public final IStateItem<AssetStateItemValue<EglSurfaceAsset<?, ?>>> EGL_CURRENT_READ_SURFACE;
    public final IStateItem<StringStateItemValue> EGL_EXTENSIONS;
    private final @NonNull Map<@NonNull StateSpec, @NonNull IStateItem<?>> stateMap;
    private final @NonNull Map<@NonNull StateSpec, @NonNull IIndexedStateItem<?>> indexedStateMap;
    private final @NonNull EglPerThreadData owner;
    private final @NonNull List<@NonNull IStateItem<?>> allStateItems;
    private final @NonNull List<@NonNull IIndexedStateItem<?>> allIndexedStateItems;
    private final @NonNull List<@NonNull IStateItemBase> bothIndexedAndNormalStateItems;
    private final @NonNull AllEglAssets.CurrentAssetProvider currentAssetProvider;

    public EglStateItems(@NonNull EglPerThreadData owner) {
        this.owner = owner;
        this.stateMap = new HashMap();
        this.indexedStateMap = new HashMap();
        this.allStateItems = new ArrayList();
        this.allIndexedStateItems = new ArrayList();
        this.bothIndexedAndNormalStateItems = new ArrayList<IStateItemBase>();
        this.currentAssetProvider = new AllEglAssets.CurrentAssetProvider(owner.getParentModel());
        this.EGL_CURRENT_API = new EglCurrentApiStateItem(this);
        this.stateMap.put(this.EGL_CURRENT_API.getStateSpec(), this.EGL_CURRENT_API);
        this.allStateItems.add(this.EGL_CURRENT_API);
        this.bothIndexedAndNormalStateItems.add(this.EGL_CURRENT_API);
        this.EGL_CURRENT_CONTEXT = new EglCurrentContextStateItem(this);
        this.stateMap.put(this.EGL_CURRENT_CONTEXT.getStateSpec(), this.EGL_CURRENT_CONTEXT);
        this.allStateItems.add(this.EGL_CURRENT_CONTEXT);
        this.bothIndexedAndNormalStateItems.add(this.EGL_CURRENT_CONTEXT);
        this.EGL_CURRENT_DISPLAY = new EglCurrentDisplayStateItem(this);
        this.stateMap.put(this.EGL_CURRENT_DISPLAY.getStateSpec(), this.EGL_CURRENT_DISPLAY);
        this.allStateItems.add(this.EGL_CURRENT_DISPLAY);
        this.bothIndexedAndNormalStateItems.add(this.EGL_CURRENT_DISPLAY);
        this.EGL_CURRENT_DRAW_SURFACE = new EglCurrentDrawSurfaceStateItem(this);
        this.stateMap.put(this.EGL_CURRENT_DRAW_SURFACE.getStateSpec(), this.EGL_CURRENT_DRAW_SURFACE);
        this.allStateItems.add(this.EGL_CURRENT_DRAW_SURFACE);
        this.bothIndexedAndNormalStateItems.add(this.EGL_CURRENT_DRAW_SURFACE);
        this.EGL_CURRENT_READ_SURFACE = new EglCurrentReadSurfaceStateItem(this);
        this.stateMap.put(this.EGL_CURRENT_READ_SURFACE.getStateSpec(), this.EGL_CURRENT_READ_SURFACE);
        this.allStateItems.add(this.EGL_CURRENT_READ_SURFACE);
        this.bothIndexedAndNormalStateItems.add(this.EGL_CURRENT_READ_SURFACE);
        this.EGL_EXTENSIONS = new EglExtensionsStateItem(this);
        this.stateMap.put(this.EGL_EXTENSIONS.getStateSpec(), this.EGL_EXTENSIONS);
        this.allStateItems.add(this.EGL_EXTENSIONS);
        this.bothIndexedAndNormalStateItems.add(this.EGL_EXTENSIONS);
    }

    @Override
    public @Nullable IStateItem<?> lookupStateItem(@NonNull AbstractConstantOrAliasSpecExtended byConstant) {
        for (IStateItem<?> stateItem : this.stateMap.values()) {
            if (!stateItem.isForPName(byConstant)) continue;
            return stateItem;
        }
        return null;
    }

    @Override
    public @Nullable IIndexedStateItem<?> lookupIndexedStateItem(@NonNull AbstractConstantOrAliasSpecExtended byConstant) {
        for (IIndexedStateItem<?> stateItem : this.indexedStateMap.values()) {
            if (!stateItem.isForPName(byConstant)) continue;
            return stateItem;
        }
        return null;
    }

    @Override
    public @Nullable IStateItem<?> lookupStateItem(@NonNull StateSpec stateSpec) {
        return this.stateMap.get(stateSpec);
    }

    @Override
    public @Nullable IIndexedStateItem<?> lookupIndexedStateItem(@NonNull StateSpec stateSpec) {
        return this.indexedStateMap.get(stateSpec);
    }

    @Override
    public @Nullable IStateItem<?> lookupStateItem(@NonNull TargetBindingGroupSpec tbgSpec, boolean mixed, @NonNull AbstractConstantOrAliasSpecExtended target) {
        TargetBindingSpec binding = tbgSpec.getTargetBinding(target);
        if (binding != null) {
            assert (binding.getState() != null) : "Missing state value for TargetBindingGroupSpec " + tbgSpec.getName();
            return this.lookupStateItem(binding.getState());
        }
        if (!mixed) {
            return null;
        }
        return this.lookupStateItem(target);
    }

    @Override
    public @Nullable IIndexedStateItem<?> lookupIndexedStateItem(@NonNull TargetBindingGroupSpec tbgSpec, boolean mixed, @NonNull AbstractConstantOrAliasSpecExtended target) {
        TargetBindingSpec binding = tbgSpec.getTargetBinding(target);
        if (binding != null) {
            assert (binding.getState() != null) : "Missing state value for TargetBindingGroupSpec " + tbgSpec.getName();
            return this.lookupIndexedStateItem(binding.getState());
        }
        if (!mixed) {
            return null;
        }
        return this.lookupIndexedStateItem(target);
    }

    @Override
    public List<@NonNull IStateItem<?>> getAllStateItems() {
        return Collections.unmodifiableList(this.allStateItems);
    }

    @Override
    public List<@NonNull IIndexedStateItem<?>> getAllIndexedStateItems() {
        return Collections.unmodifiableList(this.allIndexedStateItems);
    }

    @Override
    public List<@NonNull IStateItemBase> getBothIndexedAndNormalStateItems() {
        return Collections.unmodifiableList(this.bothIndexedAndNormalStateItems);
    }

    @Override
    public @Nullable FunctionCall getLastProcessedFunctionCall() {
        return this.owner.getLastProcessedStateProcessorFunctionCall();
    }

    @Override
    public @NonNull FunctionCall getCreatingFunction() {
        return this.owner.getCreatingFunction();
    }

    private static final class EglCurrentApiStateItem
    extends AbstractStateItem<EnumStateItemValue> {
        private final @NonNull EglStateItems parent;

        public EglCurrentApiStateItem(@NonNull EglStateItems parent) {
            super(KapiSpec.EGL.states.EGL_CURRENT_API, 1);
            this.parent = parent;
        }

        @Override
        public @NonNull EglStateItems getParentContainer() {
            return this.parent;
        }

        @Override
        public @NonNull KapiSpec getKapiSpec() {
            return KapiSpec.EGL;
        }

        @Override
        public @NonNull EnumStateItemValue getDefaultValue() {
            return new EnumStateItemValue(this, new AbstractConstantOrAliasSpecExtended[0]);
        }

        @Override
        protected boolean processFunctionCallValue(@NonNull FunctionCall functionCall, @NonNull EnumStateItemValue value) {
            AbstractConstantOrAliasSpecExtended returnValue_;
            IFunctionOrAliasSpecExtended functionSpec = functionCall.getFunctionSpec();
            assert (!functionCall.hasError());
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLBINDAPI)) {
                AbstractConstantOrAliasSpecExtended arg_api = EGL.EglBindAPIDecorator.getArgumentApi(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_2 = EGL.EglBindAPIDecorator.getReturnValue(functionCall);
                if (returnValue_2.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    value.updateValue(functionCall, arg_api);
                    return true;
                }
            }
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLRELEASETHREAD) && (returnValue_ = EGL.EglReleaseThreadDecorator.getReturnValue(functionCall)).equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                value.updateValue(functionCall, KapiSpec.EGL.constants.EGL_OPENGL_ES_API);
                return true;
            }
            return false;
        }

        @Override
        protected void applyMidstreamStateValue(@NonNull FunctionCall functionCall, @NonNull EnumStateItemValue value, @NonNull MidstreamStateItem midstreamItem) {
            FunctionCallArgumentDescriptor dataValue = midstreamItem.getValue();
            if (dataValue != null) {
                value.updateValue(functionCall, dataValue.getObjectValue(this.getIConstantOrAliasSpecContainer(), AbstractConstantOrAliasSpecExtended.class));
            }
        }
    }

    private static final class EglCurrentContextStateItem
    extends AbstractAssetStateItem<AssetStateItemValue<EglContextAsset>> {
        private final @NonNull EglStateItems parent;
        private @Nullable EglContextAsset assetObjectAtLastAdd;

        public EglCurrentContextStateItem(@NonNull EglStateItems parent) {
            super(KapiSpec.EGL.states.EGL_CURRENT_CONTEXT, 1);
            this.parent = parent;
            this.assetObjectAtLastAdd = null;
        }

        @Override
        public @NonNull EglStateItems getParentContainer() {
            return this.parent;
        }

        @Override
        public @NonNull KapiSpec getKapiSpec() {
            return KapiSpec.EGL;
        }

        @Override
        public @NonNull AssetStateItemValue<EglContextAsset> getDefaultValue() {
            return new AssetStateItemValue<EglContextAsset>(EglContextAsset.class, this, (functionCall, id) -> {
                AssetStateItemValue<EglDisplayAsset> parentAssetValue = this.parent.EGL_CURRENT_DISPLAY.waitForValue(functionCall.getID());
                EglDisplayAsset parentAsset = parentAssetValue.getAssetValue();
                if (parentAsset != null) {
                    return parentAsset.getEglContextAssetAt(functionCall.getID(), (AssetItemID)id, false);
                }
                return null;
            }, new long[0]);
        }

        @Override
        protected boolean processFunctionCallValue(@NonNull FunctionCall functionCall, @NonNull AssetStateItemValue<EglContextAsset> value) {
            AbstractConstantOrAliasSpecExtended returnValue_;
            IFunctionOrAliasSpecExtended functionSpec = functionCall.getFunctionSpec();
            assert (!functionCall.hasError());
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLMAKECURRENT)) {
                Pointer arg_dpy = EGL.EglMakeCurrentDecorator.getArgumentDpy(functionCall);
                Pointer arg_draw = EGL.EglMakeCurrentDecorator.getArgumentDraw(functionCall);
                Pointer arg_read = EGL.EglMakeCurrentDecorator.getArgumentRead(functionCall);
                Pointer arg_ctx = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_2 = EGL.EglMakeCurrentDecorator.getReturnValue(functionCall);
                if (returnValue_2.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    value.updateValue(functionCall, arg_ctx);
                    return true;
                }
            }
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLRELEASETHREAD) && (returnValue_ = EGL.EglReleaseThreadDecorator.getReturnValue(functionCall)).equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                value.updateValue(functionCall, KapiSpec.EGL.constants.EGL_NO_CONTEXT);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addFunctionCall(@NonNull FunctionCall functionCall) {
            Object object = this.functionCallMutex;
            synchronized (object) {
                EglContextAsset afterAsset;
                super.addFunctionCall(functionCall);
                IStateItemValue afterValue = this.getDefaultValue();
                if (!this.processFunctionCallValue(functionCall, (AssetStateItemValue<EglContextAsset>)afterValue)) assert (false) : "EglCurrentContextStateItem.processFunctionCallValue returned false";
                EglContextAsset beforeAsset = this.assetObjectAtLastAdd;
                this.assetObjectAtLastAdd = afterAsset = (EglContextAsset)((AssetStateItemValue)afterValue).getAssetValue();
                if (beforeAsset != null) {
                    beforeAsset.getLifecycleManager().trackReleasedFromStateItem(functionCall, this);
                }
                if (afterAsset != null) {
                    afterAsset.getLifecycleManager().trackRetainedByStateItem(functionCall, this);
                }
            }
        }

        @Override
        protected void applyMidstreamStateValue(@NonNull FunctionCall functionCall, @NonNull AssetStateItemValue<EglContextAsset> value, @NonNull MidstreamStateItem midstreamItem) {
            FunctionCallArgumentDescriptor dataValue = midstreamItem.getValue();
            if (dataValue != null) {
                value.updateValue(functionCall, dataValue.getObjectValue(this.getIConstantOrAliasSpecContainer(), Pointer.class));
            }
        }
    }

    private static final class EglCurrentDisplayStateItem
    extends AbstractAssetStateItem<AssetStateItemValue<EglDisplayAsset>> {
        private final @NonNull EglStateItems parent;
        private @Nullable EglDisplayAsset assetObjectAtLastAdd;

        public EglCurrentDisplayStateItem(@NonNull EglStateItems parent) {
            super(KapiSpec.EGL.states.EGL_CURRENT_DISPLAY, 1);
            this.parent = parent;
            this.assetObjectAtLastAdd = null;
        }

        @Override
        public @NonNull EglStateItems getParentContainer() {
            return this.parent;
        }

        @Override
        public @NonNull KapiSpec getKapiSpec() {
            return KapiSpec.EGL;
        }

        @Override
        public @NonNull AssetStateItemValue<EglDisplayAsset> getDefaultValue() {
            return new AssetStateItemValue<EglDisplayAsset>(EglDisplayAsset.class, this, (functionCall, id) -> this.parent.currentAssetProvider.getEglDisplayAssetAt((FunctionCall)functionCall, (AssetItemID)id, false), new long[0]);
        }

        @Override
        protected boolean processFunctionCallValue(@NonNull FunctionCall functionCall, @NonNull AssetStateItemValue<EglDisplayAsset> value) {
            AbstractConstantOrAliasSpecExtended returnValue_;
            AbstractConstantOrAliasSpecExtended returnValue_2;
            Pointer arg_ctx;
            Pointer arg_read;
            Pointer arg_draw;
            Pointer arg_dpy;
            IFunctionOrAliasSpecExtended functionSpec = functionCall.getFunctionSpec();
            assert (!functionCall.hasError());
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLMAKECURRENT)) {
                long temp_temp_0;
                arg_dpy = EGL.EglMakeCurrentDecorator.getArgumentDpy(functionCall);
                arg_draw = EGL.EglMakeCurrentDecorator.getArgumentDraw(functionCall);
                arg_read = EGL.EglMakeCurrentDecorator.getArgumentRead(functionCall);
                arg_ctx = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
                returnValue_2 = EGL.EglMakeCurrentDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = arg_ctx != null ? arg_ctx.address() : 0L;
                if (returnValue_2.equals(KapiSpec.EGL.constants.EGL_TRUE) && temp_temp_0 != 0L) {
                    value.updateValue(functionCall, arg_dpy);
                    return true;
                }
            }
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLMAKECURRENT)) {
                long temp_temp_1;
                arg_dpy = EGL.EglMakeCurrentDecorator.getArgumentDpy(functionCall);
                arg_draw = EGL.EglMakeCurrentDecorator.getArgumentDraw(functionCall);
                arg_read = EGL.EglMakeCurrentDecorator.getArgumentRead(functionCall);
                arg_ctx = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
                returnValue_2 = EGL.EglMakeCurrentDecorator.getReturnValue(functionCall);
                long l = temp_temp_1 = arg_ctx != null ? arg_ctx.address() : 0L;
                if (returnValue_2.equals(KapiSpec.EGL.constants.EGL_TRUE) && temp_temp_1 == 0L) {
                    value.updateValue(functionCall, KapiSpec.EGL.constants.EGL_NO_DISPLAY);
                    return true;
                }
            }
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLRELEASETHREAD) && (returnValue_ = EGL.EglReleaseThreadDecorator.getReturnValue(functionCall)).equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                value.updateValue(functionCall, KapiSpec.EGL.constants.EGL_NO_DISPLAY);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addFunctionCall(@NonNull FunctionCall functionCall) {
            Object object = this.functionCallMutex;
            synchronized (object) {
                EglDisplayAsset afterAsset;
                super.addFunctionCall(functionCall);
                IStateItemValue afterValue = this.getDefaultValue();
                if (!this.processFunctionCallValue(functionCall, (AssetStateItemValue<EglDisplayAsset>)afterValue)) assert (false) : "EglCurrentDisplayStateItem.processFunctionCallValue returned false";
                EglDisplayAsset beforeAsset = this.assetObjectAtLastAdd;
                this.assetObjectAtLastAdd = afterAsset = (EglDisplayAsset)((AssetStateItemValue)afterValue).getAssetValue();
                if (beforeAsset != null) {
                    beforeAsset.getLifecycleManager().trackReleasedFromStateItem(functionCall, this);
                }
                if (afterAsset != null) {
                    afterAsset.getLifecycleManager().trackRetainedByStateItem(functionCall, this);
                }
            }
        }

        @Override
        protected void applyMidstreamStateValue(@NonNull FunctionCall functionCall, @NonNull AssetStateItemValue<EglDisplayAsset> value, @NonNull MidstreamStateItem midstreamItem) {
            FunctionCallArgumentDescriptor dataValue = midstreamItem.getValue();
            if (dataValue != null) {
                value.updateValue(functionCall, dataValue.getObjectValue(this.getIConstantOrAliasSpecContainer(), Pointer.class));
            }
        }
    }

    private static final class EglCurrentDrawSurfaceStateItem
    extends AbstractAssetStateItem<AssetStateItemValue<EglSurfaceAsset<?, ?>>> {
        private final @NonNull EglStateItems parent;
        private @Nullable EglSurfaceAsset<?, ?> assetObjectAtLastAdd;

        public EglCurrentDrawSurfaceStateItem(@NonNull EglStateItems parent) {
            super(KapiSpec.EGL.states.EGL_CURRENT_DRAW_SURFACE, 1);
            this.parent = parent;
            this.assetObjectAtLastAdd = null;
        }

        @Override
        public @NonNull EglStateItems getParentContainer() {
            return this.parent;
        }

        @Override
        public @NonNull KapiSpec getKapiSpec() {
            return KapiSpec.EGL;
        }

        @Override
        public @NonNull AssetStateItemValue<EglSurfaceAsset<?, ?>> getDefaultValue() {
            return new AssetStateItemValue(EglSurfaceAsset.class, this, (functionCall, id) -> {
                AssetStateItemValue<EglDisplayAsset> parentAssetValue = this.parent.EGL_CURRENT_DISPLAY.waitForValue(functionCall.getID());
                EglDisplayAsset parentAsset = parentAssetValue.getAssetValue();
                if (parentAsset != null) {
                    return parentAsset.getEglSurfaceAssetAt(functionCall.getID(), (AssetItemID)id, false);
                }
                return null;
            }, new long[0]);
        }

        @Override
        protected boolean processFunctionCallValue(@NonNull FunctionCall functionCall, @NonNull AssetStateItemValue<EglSurfaceAsset<?, ?>> value) {
            AbstractConstantOrAliasSpecExtended returnValue_;
            IFunctionOrAliasSpecExtended functionSpec = functionCall.getFunctionSpec();
            assert (!functionCall.hasError());
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLMAKECURRENT)) {
                Pointer arg_dpy = EGL.EglMakeCurrentDecorator.getArgumentDpy(functionCall);
                Pointer arg_draw = EGL.EglMakeCurrentDecorator.getArgumentDraw(functionCall);
                Pointer arg_read = EGL.EglMakeCurrentDecorator.getArgumentRead(functionCall);
                Pointer arg_ctx = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_2 = EGL.EglMakeCurrentDecorator.getReturnValue(functionCall);
                if (returnValue_2.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    value.updateValue(functionCall, arg_draw);
                    return true;
                }
            }
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLRELEASETHREAD) && (returnValue_ = EGL.EglReleaseThreadDecorator.getReturnValue(functionCall)).equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                value.updateValue(functionCall, KapiSpec.EGL.constants.EGL_NO_SURFACE);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addFunctionCall(@NonNull FunctionCall functionCall) {
            Object object = this.functionCallMutex;
            synchronized (object) {
                EglSurfaceAsset afterAsset;
                super.addFunctionCall(functionCall);
                IStateItemValue afterValue = this.getDefaultValue();
                if (!this.processFunctionCallValue(functionCall, (AssetStateItemValue<EglSurfaceAsset<?, ?>>)afterValue)) assert (false) : "EglCurrentDrawSurfaceStateItem.processFunctionCallValue returned false";
                EglSurfaceAsset<?, ?> beforeAsset = this.assetObjectAtLastAdd;
                this.assetObjectAtLastAdd = afterAsset = (EglSurfaceAsset)((AssetStateItemValue)afterValue).getAssetValue();
                if (beforeAsset != null) {
                    beforeAsset.getLifecycleManager().trackReleasedFromStateItem(functionCall, this);
                }
                if (afterAsset != null) {
                    afterAsset.getLifecycleManager().trackRetainedByStateItem(functionCall, this);
                }
            }
        }

        @Override
        protected void applyMidstreamStateValue(@NonNull FunctionCall functionCall, @NonNull AssetStateItemValue<EglSurfaceAsset<?, ?>> value, @NonNull MidstreamStateItem midstreamItem) {
            FunctionCallArgumentDescriptor dataValue = midstreamItem.getValue();
            if (dataValue != null) {
                value.updateValue(functionCall, dataValue.getObjectValue(this.getIConstantOrAliasSpecContainer(), Pointer.class));
            }
        }
    }

    private static final class EglCurrentReadSurfaceStateItem
    extends AbstractAssetStateItem<AssetStateItemValue<EglSurfaceAsset<?, ?>>> {
        private final @NonNull EglStateItems parent;
        private @Nullable EglSurfaceAsset<?, ?> assetObjectAtLastAdd;

        public EglCurrentReadSurfaceStateItem(@NonNull EglStateItems parent) {
            super(KapiSpec.EGL.states.EGL_CURRENT_READ_SURFACE, 1);
            this.parent = parent;
            this.assetObjectAtLastAdd = null;
        }

        @Override
        public @NonNull EglStateItems getParentContainer() {
            return this.parent;
        }

        @Override
        public @NonNull KapiSpec getKapiSpec() {
            return KapiSpec.EGL;
        }

        @Override
        public @NonNull AssetStateItemValue<EglSurfaceAsset<?, ?>> getDefaultValue() {
            return new AssetStateItemValue(EglSurfaceAsset.class, this, (functionCall, id) -> {
                AssetStateItemValue<EglDisplayAsset> parentAssetValue = this.parent.EGL_CURRENT_DISPLAY.waitForValue(functionCall.getID());
                EglDisplayAsset parentAsset = parentAssetValue.getAssetValue();
                if (parentAsset != null) {
                    return parentAsset.getEglSurfaceAssetAt(functionCall.getID(), (AssetItemID)id, false);
                }
                return null;
            }, new long[0]);
        }

        @Override
        protected boolean processFunctionCallValue(@NonNull FunctionCall functionCall, @NonNull AssetStateItemValue<EglSurfaceAsset<?, ?>> value) {
            AbstractConstantOrAliasSpecExtended returnValue_;
            IFunctionOrAliasSpecExtended functionSpec = functionCall.getFunctionSpec();
            assert (!functionCall.hasError());
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLMAKECURRENT)) {
                Pointer arg_dpy = EGL.EglMakeCurrentDecorator.getArgumentDpy(functionCall);
                Pointer arg_draw = EGL.EglMakeCurrentDecorator.getArgumentDraw(functionCall);
                Pointer arg_read = EGL.EglMakeCurrentDecorator.getArgumentRead(functionCall);
                Pointer arg_ctx = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_2 = EGL.EglMakeCurrentDecorator.getReturnValue(functionCall);
                if (returnValue_2.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    value.updateValue(functionCall, arg_read);
                    return true;
                }
            }
            if (functionSpec.equals(KapiSpec.EGL.functions.EGLRELEASETHREAD) && (returnValue_ = EGL.EglReleaseThreadDecorator.getReturnValue(functionCall)).equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                value.updateValue(functionCall, KapiSpec.EGL.constants.EGL_NO_SURFACE);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addFunctionCall(@NonNull FunctionCall functionCall) {
            Object object = this.functionCallMutex;
            synchronized (object) {
                EglSurfaceAsset afterAsset;
                super.addFunctionCall(functionCall);
                IStateItemValue afterValue = this.getDefaultValue();
                if (!this.processFunctionCallValue(functionCall, (AssetStateItemValue<EglSurfaceAsset<?, ?>>)afterValue)) assert (false) : "EglCurrentReadSurfaceStateItem.processFunctionCallValue returned false";
                EglSurfaceAsset<?, ?> beforeAsset = this.assetObjectAtLastAdd;
                this.assetObjectAtLastAdd = afterAsset = (EglSurfaceAsset)((AssetStateItemValue)afterValue).getAssetValue();
                if (beforeAsset != null) {
                    beforeAsset.getLifecycleManager().trackReleasedFromStateItem(functionCall, this);
                }
                if (afterAsset != null) {
                    afterAsset.getLifecycleManager().trackRetainedByStateItem(functionCall, this);
                }
            }
        }

        @Override
        protected void applyMidstreamStateValue(@NonNull FunctionCall functionCall, @NonNull AssetStateItemValue<EglSurfaceAsset<?, ?>> value, @NonNull MidstreamStateItem midstreamItem) {
            FunctionCallArgumentDescriptor dataValue = midstreamItem.getValue();
            if (dataValue != null) {
                value.updateValue(functionCall, dataValue.getObjectValue(this.getIConstantOrAliasSpecContainer(), Pointer.class));
            }
        }
    }

    private static final class EglExtensionsStateItem
    extends AbstractStateItem<StringStateItemValue> {
        private final @NonNull EglStateItems parent;

        public EglExtensionsStateItem(@NonNull EglStateItems parent) {
            super(KapiSpec.EGL.states.EGL_EXTENSIONS, 1);
            this.parent = parent;
        }

        @Override
        public @NonNull EglStateItems getParentContainer() {
            return this.parent;
        }

        @Override
        public @NonNull KapiSpec getKapiSpec() {
            return KapiSpec.EGL;
        }

        @Override
        public @NonNull StringStateItemValue getDefaultValue() {
            return new StringStateItemValue(this, new String[0]);
        }

        @Override
        protected boolean processFunctionCallValue(@NonNull FunctionCall functionCall, @NonNull StringStateItemValue value) {
            IFunctionOrAliasSpecExtended functionSpec = functionCall.getFunctionSpec();
            assert (!functionCall.hasError());
            return false;
        }

        @Override
        protected void applyMidstreamStateValue(@NonNull FunctionCall functionCall, @NonNull StringStateItemValue value, @NonNull MidstreamStateItem midstreamItem) {
            FunctionCallArgumentDescriptor dataValue = midstreamItem.getValue();
            if (dataValue != null) {
                value.updateValue(functionCall, dataValue.getObjectValue(this.getIConstantOrAliasSpecContainer(), String.class));
            }
        }
    }
}

