/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.state;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.StateVariableTypeSpec;
import com.arm.mgd.lightweight.asset.AssetItemID;
import com.arm.mgd.lightweight.state.IStateItem;
import com.arm.mgd.lightweight.state.IStateItemValue;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StateItemValueFormatter {
    private static final @NonNull String UNKNOWN_VALUE = "<UNKNOWN>";

    public static <T, R> @NonNull R format(@NonNull IStateItemValue<? extends T> stateItemValue, @NonNull Function<IStateItem<? extends IStateItemValue<? extends T>>, @NonNull IStateItemValueFormatter<? super T, R>> formatterFactory) {
        IStateItem<IStateItemValue<T>> parent = stateItemValue.getParent();
        IStateItemValueFormatter<T, R> formatter = formatterFactory.apply(parent);
        List<@Nullable T> values = stateItemValue.getValues();
        int cardinality = parent.getCardinality();
        int numValues = values.size();
        int count = Math.max(cardinality, numValues);
        boolean single = cardinality == 1 && numValues <= 1 || cardinality == 0 && numValues == 1;
        boolean first = true;
        int i = 0;
        while (i < count) {
            if (!first) {
                formatter.appendEntrySeparator(cardinality, i);
            }
            first = false;
            if (i < numValues) {
                @Nullable T value = values.get(i);
                if (value != null) {
                    formatter.appendValue(cardinality, i, value);
                } else {
                    formatter.appendNullValue(cardinality, i);
                }
            } else {
                formatter.appendUnknownValue(cardinality, i);
            }
            ++i;
        }
        if (single) {
            return formatter.formatSingleResult(cardinality);
        }
        return formatter.formatMultiResult(cardinality);
    }

    public static <T> @NonNull String format(@NonNull IStateItemValue<T> stateItemValue) {
        return (String)StateItemValueFormatter.format(stateItemValue, parent -> new DefaultFormatter(parent));
    }

    public static class DefaultFormatter<T>
    implements IStateItemValueFormatter<T, String> {
        private final @NonNull IStateItem<? extends IStateItemValue<? extends T>> parent;
        private final @NonNull StringBuilder result = new StringBuilder();

        public DefaultFormatter(@NonNull IStateItem<? extends IStateItemValue<? extends T>> parent) {
            this.parent = parent;
        }

        @Override
        public void appendEntrySeparator(int cardinality, int index) {
            this.result.append(", ");
        }

        @Override
        public void appendNullValue(int cardinality, int index) {
            this.result.append(StateItemValueFormatter.UNKNOWN_VALUE);
        }

        @Override
        public void appendUnknownValue(int cardinality, int index) {
            this.result.append(StateItemValueFormatter.UNKNOWN_VALUE);
        }

        @Override
        public void appendValue(int cardinality, int index, @NonNull T value) {
            if (this.parent.getStateSpec().getStateType().getStateVariableType() == StateVariableTypeSpec.Y) {
                if (value instanceof Number) {
                    this.result.append("0x");
                    this.result.append(Long.toHexString(((Number)value).longValue()));
                } else if (value instanceof AssetItemID) {
                    this.result.append("0x");
                    this.result.append(Long.toHexString(((AssetItemID)value).asLong()));
                } else {
                    assert (false) : "what is this : " + value + " (" + value.getClass().getCanonicalName() + ")";
                    this.result.append(value);
                }
            } else if (value instanceof Boolean) {
                boolean b = (Boolean)value;
                StateSpec stateSpec = this.parent.getStateSpec();
                if (stateSpec.getKapiSpec() == KapiSpec.EGL) {
                    this.result.append(b ? KapiSpec.EGL.constants.EGL_TRUE : KapiSpec.EGL.constants.EGL_FALSE);
                } else if (stateSpec.getKapiSpec() == KapiSpec.GLES) {
                    this.result.append(b ? KapiSpec.GLES.constants.GL_TRUE : KapiSpec.GLES.constants.GL_FALSE);
                } else {
                    this.result.append(value);
                }
            } else {
                this.result.append(value);
            }
        }

        @Override
        public @NonNull String formatMultiResult(int cardinality) {
            return (String)NullUtils.neverNull((Object)String.format("[%s]", this.result));
        }

        @Override
        public @NonNull String formatSingleResult(int cardinality) {
            return (String)NullUtils.neverNull((Object)this.result.toString());
        }
    }

    public static interface IStateItemValueFormatter<T, R> {
        public void appendEntrySeparator(int var1, int var2);

        public void appendNullValue(int var1, int var2);

        public void appendUnknownValue(int var1, int var2);

        public void appendValue(int var1, int var2, @NonNull T var3);

        public @NonNull R formatMultiResult(int var1);

        public @NonNull R formatSingleResult(int var1);
    }
}

