/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors.util;

import com.arm.mgd.lightweight.processors.util.AbstractProcessor;
import com.arm.mgd.lightweight.processors.util.IQueueItemProcessor;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractSynchronousPushProcessor<T, P extends IQueueItemProcessor<T>>
extends AbstractProcessor<T> {
    protected final @NonNull P processor;
    private boolean busy;

    public AbstractSynchronousPushProcessor(@NonNull P processor) {
        this.processor = processor;
    }

    public AbstractSynchronousPushProcessor(@NonNull String threadName, int queueSize, @NonNull P processor) {
        this(processor);
    }

    @Override
    public boolean enqueueItem(@NonNull T itemToEnqueue) {
        if (!this.isShutdownRequested()) {
            try {
                this.setBusy(true);
                if (this.processor.process(itemToEnqueue)) {
                    this.pushDependentProcessors(itemToEnqueue);
                }
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.setBusy(false);
                this.setLastProcessedItem(itemToEnqueue);
                this.notifyProcessor();
            }
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.shutdownDependentProcessors();
    }

    private synchronized void setBusy(boolean busy) {
        this.busy = busy;
    }
}

