/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.lightweight.processors.util;

import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.lightweight.processors.IPushProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractProcessor<T>
implements IPushProcessor<T> {
    private final @NonNull List<@NonNull IPushProcessor<? super T>> dependentProcessors = new ArrayList<IPushProcessor<? super T>>();
    private volatile @Nullable T lastProcessedItem;
    private int waitCount = 0;
    private volatile boolean shutdown = false;
    private volatile boolean shutdownRequested = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addDependentProcessor(@NonNull IPushProcessor<? super T> dependentProcessor) {
        List<IPushProcessor<? super T>> list = this.dependentProcessors;
        synchronized (list) {
            this.dependentProcessors.add(dependentProcessor);
        }
    }

    @Override
    public final @Nullable FunctionCall getLastCompletedFunctionCall() {
        FunctionCall ourLastFunctionCall = this.lastProcessedItem instanceof FunctionCall ? (FunctionCall)this.lastProcessedItem : null;
        IPushProcessor<?> parentProcessor = this.getParentProcessor();
        if (this.isBusy() || parentProcessor == null) {
            return ourLastFunctionCall;
        }
        FunctionCall parentsLastFunctionCall = parentProcessor.getLastCompletedFunctionCall();
        if (parentsLastFunctionCall == null) {
            return ourLastFunctionCall;
        }
        return parentsLastFunctionCall;
    }

    @Override
    public final @Nullable T getLastProcessedItem() {
        return this.lastProcessedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isShutdown() {
        if (!this.shutdown) {
            return false;
        }
        List<IPushProcessor<? super T>> list = this.dependentProcessors;
        synchronized (list) {
            IPushProcessor<T> dependentProcessor;
            Iterator<IPushProcessor<T>> iterator = this.dependentProcessors.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((dependentProcessor = iterator.next()).isShutdown());
            return false;
        }
    }

    @Override
    public final boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    @Override
    public void shutdown() {
        assert (!this.shutdownRequested);
        this.shutdownRequested = true;
        this.notifyProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitOnEvent() throws InterruptedException {
        AbstractProcessor abstractProcessor = this;
        synchronized (abstractProcessor) {
            if (this.isBusy() && !this.shutdownRequested) {
                try {
                    ++this.waitCount;
                    this.wait();
                }
                finally {
                    --this.waitCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyProcessor() {
        AbstractProcessor abstractProcessor = this;
        synchronized (abstractProcessor) {
            if (this.waitCount != 0) {
                this.notifyAll();
            }
        }
    }

    protected void onShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void pushDependentProcessors(@NonNull T itemToProcess) {
        List<IPushProcessor<? super T>> list = this.dependentProcessors;
        synchronized (list) {
            for (IPushProcessor<T> dependentProcessor : this.dependentProcessors) {
                dependentProcessor.enqueueItem(itemToProcess);
            }
        }
    }

    protected final void setLastProcessedItem(@NonNull T itemToProcess) {
        this.lastProcessedItem = itemToProcess;
        this.notifyProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdownDependentProcessors() {
        this.shutdown = true;
        this.onShutdown();
        List<IPushProcessor<? super T>> list = this.dependentProcessors;
        synchronized (list) {
            for (IPushProcessor<T> dependentProcessor : this.dependentProcessors) {
                dependentProcessor.shutdown();
            }
        }
    }
}

